FILE: 'Alan Kay.md'
---
exported: 2026-02-07T20:34:35.911Z
source: NotebookLM
type: chat
title: Alan Kay on 💬What is Complexity
tags:
  - What-is-complexity
  - Alan-Kay
author: Alan Kay
---
**Complexity** is defined as the intrinsic property of an organization of ingredients required to satisfy a specific goal, whereas **complication** is extrinsic "noise and mess" introduced by poor human design or execution\[1\]. Kay argues that while complexity pays its way by being interesting and important, complications should be weeded out by finding better ways to think about and represent ideas\[2\].

To deal with complexity, Kay advocates shifting from a "mechanical" or "clockwork" mindset to a "biological" or "systems" mindset\[3\]\[4\]. Here is the specific advice on managing complexity found in the sources:

### 1\. Distinguish Scaling form Construction

**"Good ideas don't often scale"**\[5\]\[6\]. A method that works for a small problem (like building a doghouse) will fail disastrously if simply enlarged to a massive scale (like a cathedral or skyscraper)\[7\].

• **Architecture Dominates Material:** As the scale increases, the architecture becomes more important than the materials used. You cannot simply pile up "bricks" (tactics) to build a large structure; you need a strategic principle, like the arch\[8\]\[9\].

• **Avoid the "Turing Tarpit":** The computer offers infinite degrees of freedom, which makes it the most interesting machine ever invented, but this freedom allows us to create "festering" slums of code if we do not impose architectural discipline\[10\].

### 2\. Adopt the Biological Metaphor

To handle systems of immense scale (like the trillions of cells in a body or the Internet), one must mimic biology rather than clockwork mechanisms\[11\]\[12\].

• **Universal Building Blocks:** Use a single, universal building block (like a cell) that is a "whole virtual computer" capable of communicating, rather than passive data structures\[13\]\[14\].

• **Encapsulation:** Use a strong "membrane" to hide and protect the interior details of these blocks. The interior processes can be "kludgy," but the system remains clean because the outside only sees the message interface\[12\]\[15\].

• **Messaging:** Components should communicate via "requests" (messages) rather than commands. This reduces dependencies and allows for negotiation between parts of the system\[16\]\[17\].

### 3\. Separate Meaning from Optimization

A critical error in modern software is intertwining the _meaning_ (what is needed) with the _optimization_ (how it is done)\[18\]\[19\].

• **Design for Meaning:** You should be able to write and debug the design in terms of "runnable meanings" or "runnable requirements"\[18\]\[20\].

• **Optimize Separately:** Optimizations should be treated as "hints from the side" or a separate fabrication phase (FAB) that does not pollute the semantic design. A system should be able to run (perhaps slowly) with all optimizations turned off\[21\].

### 4\. Use Late Binding

**Delay commitment** to specific hardware, representations, or implementations as long as possible\[24\]\[25\].

• **System Life:** Late binding allows a system to grow and change while it is running, similar to how biological systems renew themselves without stopping\[4\]\[26\].

• **Flexibility:** It is much easier to remove degrees of freedom later if needed than to try to add flexibility to an early-bound, rigid system\[27\].

### 5\. Shift Context

**"Point of view is worth 80 IQ points"**\[28\]\[29\].

• **Change the Representation:** Many problems that are complex in one context (e.g., calculating with Roman numerals) become simple in another (e.g., Arabic numerals)\[30\].

• **Find WIAN:** Instead of incrementally improving a bad design ("better"), search for "What Is Actually Needed" (WIAN), which often requires a qualitative jump to a new context\[31\]\[32\].

---
> [!info]- References
> [1] Alan Kay - Quora 2023-11.pdf
> [2] Alan Kay - Quora 2023-11.pdf
> [3] OOP in a Nutshell From Clockwork to Biology.pdf
> [4] OOP in a Nutshell From Clockwork to Biology.pdf
> [5] Alan Kay - Quora 2023-11.pdf
> [6] Alan Kay - Quora 2023-11.pdf
> [7] OOP in a Nutshell From Clockwork to Biology.pdf
> [8] Alan Kay - Turing Tarpit Transcript 06_15_12.pdf
> [9] IsSoftwareEngineeringAnOxymoron.pdf
> [10] Alan Kay - Turing Tarpit Transcript 06_15_12.pdf
> [11] OOP in a Nutshell From Clockwork to Biology.pdf
> [12] OOP in a Nutshell From Clockwork to Biology.pdf
> [13] Alan Kay - Quora 2023-11.pdf
> [14] Alan Kay - Quora 2023-11.pdf
> [15] OOP in a Nutshell From Clockwork to Biology.pdf
> [16] Alan Kay - Quora 2023-11.pdf
> [17] Alan Kay - Quora 2023-11.pdf
> [18] Alan Kay - Quora 2023-11.pdf
> [19] Alan Kay - Quora 2023-11.pdf
> [20] [Book] AlanKay - 70th Points of View.pdf
> [21] Alan Kay - Quora 2023-11.pdf
> [24] Alan Kay - Quora 2023-11.pdf
> [25] Kay - Moving to Tomorrows Computing Infrastructure.pdf
> [26] OOP in a Nutshell From Clockwork to Biology.pdf
> [27] Alan Kay - Quora 2023-11.pdf
> [28] Alan Kay - Quora 2023-11.pdf
> [29] Alan Kay - Quora 2023-11.pdf
> [30] [Book] AlanKay - 70th Points of View.pdf
> [31] Alan Kay - Quora 2023-11.pdf
> [32] Alan Kay - Quora 2023-11.pdf


FILE: 'Alicia Juarrero.md'
---
tags:
  - Alicia-Juarrero
  - What-is-complexity
title: Alicia Juarrero on 💬What is Complexity
author: Alicia Juarrero
---
In the context of the sources, **complexity** is not merely a measure of "complicatedness" or the number of parts an object has, but rather describes **coherent dynamics** that emerge from the **interactions and feedback loops** among numerous variables 1-3. Unlike a simple aggregate, where the parts remain independent, a complex system is a **unified whole** where the behavior of each component is constrained by its relationship to the others 4-6.

### The Nature of Complexity

According to the sources, complexity is characterised by several key concepts:

* **Self-Organisation and Emergence**: Complex systems spontaneously create higher levels of order and **qualitatively novel properties** that cannot be predicted by looking at the individual parts in isolation 3, 7, 8\.  
* **Open Systems Far from Equilibrium**: These systems, known as **dissipative structures**, persist by continuously exchanging energy, matter, and information with their environment 9-11.  
* **Nonlinearity and Sensitivity**: Small perturbations can lead to massive, unpredictable changes (bifurcations), making the system's trajectory highly sensitive to **initial conditions** 12-14.  
* **Context and History**: Complexity is inherently **path-dependent**; a system’s identity and current state are fundamentally shaped by its unique history and the environment in which it is embedded 13, 15-17.  
* **Multiple Realisability**: The same high-level function or "type" can be realised by many different low-level "tokens" or microstates, which provides the system with **flexibility and robustness** 18-21.

### Advice on How to Deal with Complexity

The sources provide several pieces of advice for navigating and managing complex systems:  
**1\. Shift from Reductionism to Systems Thinking**One must abandon the "nothing but-ism" approach that tries to explain everything by breaking it down into basic particles 22, 23\. Instead, deal with the system as a **coherent whole**, recognising that **top-down (mereological) constraints** are real and exert active power over components 24-26.  
**2\. Accept the Limits of Prediction**In a complex world, **precise prediction is often impossible** because of the system's sensitivity to initial conditions and the role of chance fluctuations 14, 27-29. One should learn to **embrace uncertainty** rather than fruitlessly seeking the absolute certitude of Newtonian "clockwork" models 27, 30\.  
**3\. Use Narrative and Interpretive Explanations**Because complex systems are historical and unique, they cannot be fully explained by universal laws alone 31, 32\. The sources suggest that we should use **hermeneutical narratives**—stories that retrace the specific, concrete details and context of an event—to provide understanding, especially when dealing with radical transformations or **phase changes** 33-36.  
**4\. Focus on Constraints Rather than Force**Instead of trying to push a system with direct "efficient" causes, one should influence it by altering its **enabling or governing constraints** 37, 38\. This involves changing the "rules of the game," the environment, or the boundaries of what is possible to **channel behavior** in a desired direction 38-41.  
**5\. Prioritise Resilience over Rigid Stability**Rigid systems are brittle and likely to collapse when the environment changes 42-44. Advice in the sources suggests building **"safe-fail" systems** that are resilient enough to absorb changes and adapt, rather than attempting to design "fail-safe" systems that aim for unattainable perfection 45-47.  
**6\. Cultivate Practical Wisdom (Phronesis)**Dealing with complexity requires **practical wisdom**, or the ability to make reasoned judgments that are tailored to the specific **context and timing** of a situation (*pros ton kairon*) 48-51. This sensibility is nurtured through experience and habituation rather than the study of abstract formulas 51, 52\.  
**7\. Utilise Analog Decision-Making**For managing real-time behavior in a messy world, **analog control** (which processes continuous variables and "tagged" feelings like fear or pleasure) is more energy-efficient and **noise-tolerant** than purely digital or binary logic 53-56. Trusting a "gut feel" is often a sophisticated form of processing complex contextual information 55, 57\.  


FILE: 'Barry Richmond.md'
---
exported: '2026-01-31T12:00:47.954Z'
source: NotebookLM
type: chat
title: Barry Richmond on 💬What is Complexity
tags:
  - Barry-Richmond
  - What-is-complexity
author: Barry Richmond
---

**Complexity** is defined by systems that are **adaptive, non-linear, and characterized by emergence**, where the component parts interact in ways that produce properties that cannot be understood by analyzing those parts in isolation\[1\].

### **What is Complexity?**

The sources distinguish between systems that are "complicated" and those that are "complex":

• **Complex vs. Complicated:** A complicated system (like a car engine or an aircraft) has many parts, but they are connected in a **deterministic, predictable way**\[3\]\[4\]. A complex system (like a living cell, a corporation, or an ecosystem) is a **Complex Adaptive System (CAS)**—a dynamic network of agents acting in parallel, constantly reacting to each other's actions\[2\]\[5\].

• **Key Attributes:**

    ◦ **Emergence:** The whole exhibits properties that are "greater than the sum of its parts" and cannot be reduced to the properties of individual components\[6\].    ◦ **Non-linearity:** Small changes can trigger disproportionately large effects (the "butterfly effect"), and causality is often circular rather than one-way\[9\].    ◦ **Self-Organization:** Structure and order emerge spontaneously from internal interactions without a central controller\[2\].    ◦ **Feedback Loops:** Systems are governed by reinforcing loops (which amplify change) and balancing loops (which seek equilibrium)\[13\].    ◦ **Compensating Feedback:** When one part of a complex system is changed, the system often "pushes back" to maintain its own implicit goals, leading to unintended consequences\[17\]\[18\].
### **How to Deal with Complexity**

The sources provide extensive advice on navigating complex environments, summarized into these principles:

**1\. Shift the Thinking Paradigm**

• **Move from "Laundry List" to "Closed-Loop" Thinking:** Avoid listing independent factors that "influence" an outcome\[19\]. Instead, recognize that causality runs in circles where every "effect" eventually feeds back to influence its "cause"\[22\].

• **Employ Operational Thinking:** Focus on the "physics" or infrastructure of the system—the **stocks** (accumulations) and **flows** (activities)—to understand how behavior is actually generated\[25\].

• **Practice 10,000-Meter Thinking:** Stand back far enough from the "fray" of daily events to see the "forest of relationships" rather than individual "trees" or isolated events\[28\].

**2\. Adopt Strategic Adaptive Management (SAM)**

• **Learning-by-Doing:** Because complex systems are unpredictable, management must be an iterative process of experimentation and reflection\[32\].

• **Establish a Vision and Thresholds:** Set a clear desired future state and identify **Thresholds of Potential Concern (TPCs)**—auditable endpoints that signal when a system is moving toward an undesirable state\[33\]\[35\].

• **Maintain Flexibility:** Avoid rigid, "command-and-control" approaches that attempt to eliminate variability, as this often reduces the system's **resilience** and makes it more vulnerable to collapse\[36\].

**3\. Use Simulation and Modeling Tools**

• **Externalize Mental Models:** Human intuition is poor at predicting the behavior of systems with multiple feedback loops and delays\[39\]. Use computer models (like STELLA) to make mental models explicit and testable\[42\].

• **Compress Space and Time:** Use "Management Flight Simulators" to experience the long-term consequences of decisions in a safe, compressed environment\[45\].

**4\. Seek "Requisite Simplicity"**

• Do not try to "model the system" in all its infinite detail, which leads to cognitive overload\[49\]. Instead, identify the **minimum set of relationships** (the "physics") that can self-generate the behavior of interest\[52\].

**5\. Identify Leverage Points**

• Look for **high-leverage interventions**—places in the system where a small shift in one area can yield large, long-lasting improvements across the whole\[46\]\[55\]. These are often found by changing the **goals** of the system or addressing non-physical variables like commitment and trust\[56\]\[57\].

**6\. Strengthen Feedback and Self-Regulation**

• Ensure that information about the system's state is accurately and timely returned to decision-makers\[13\]\[58\]. Functional, multi-scale feedback loops are the basis for a **learning and reflexive system**\[59\]\[60\].

---
> [!info]- References
> [1] 200RefsSystems2c.pdf
> [2] KV 277.pdf
> [3] KV 277.pdf
> [4] KV 277.pdf
> [5] KV 277.pdf
> [6] 200RefsSystems2c.pdf
> [9] KV 277.pdf
> [13] KV 277.pdf
> [17] 2005 Fisher - The prophet of unintended consequences.pdf
> [18] 2005 Fisher - The prophet of unintended consequences.pdf
> [19] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [22] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [25] Richmond 1994 systems thinking lets just get on with it.pdf
> [28] Richmond - Systems Thinking four key questions.pdf
> [32] KV 277.pdf
> [33] KV 277.pdf
> [35] KV 277.pdf
> [36] KV 277.pdf
> [39] 2005 Fisher - The prophet of unintended consequences.pdf
> [42] SDSTletsjustgetonwithit.pdf
> [45] 111-116-1-PB(a).pdf
> [46] System Archetypes Stories that Repeat.pdf
> [49] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [52] KV 277.pdf
> [55] 2005 Fisher - The prophet of unintended consequences.pdf
> [56] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [57] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [58] KV 277.pdf
> [59] KV 277.pdf
> [60] KV 277.pdf


FILE: 'Bob Williams.md'
---
exported: 2026-02-07T20:35:10.875Z
source: NotebookLM
type: chat
title: Bob Williams on 💬What is Complexity
tags:
  - What-is-complexity
  - Bob-Williams
author: Bob Williams
---
Based on the provided sources, here is an explanation of what complexity is and the advice offered on how to deal with it.

### **1\. What is Complexity?**

In systems thinking, complexity is not simply about having a lot of "moving parts." The sources distinguish between being "complicated" (having many parts that work in a predictable way, like an engine) and being "complex" (where parts interact in unpredictable ways, like a family or a forest).

**Key Characteristics of Complexity:**

• **Dynamic Complexity (Messes) vs. Detailed Complexity (Difficulties):** Complexity is often described as a "mess." Unlike a "difficulty" (e.g., a broken car) which can be fixed by logic and expertise, a "mess" (e.g., homelessness) involves shifting targets, contested issues, and no clear agreement on the problem or solution\[1\].

• **The "Unknown Unknowns":** In the **Cynefin framework**, the complex domain is the realm of the "unknowable." Cause and effect are only visible in retrospect. You cannot predict outcomes with certainty because the system behavior depends heavily on initial conditions and context\[2\]\[3\].

• **Emergence:** This is a central concept. Emergent properties are outcomes that arise from the interaction of the parts but cannot be predicted by looking at the parts in isolation. For example, the "culture" of an organization is an emergent property of the interactions between employees; you cannot find the "culture" by analyzing a single employee\[4\].

• **Non-linearity:** In complex systems, there is no proportional relationship between cause and effect. A small intervention can lead to a massive systemic shift (a tipping point), or a massive intervention can be absorbed by the system with no visible change\[1\].

• **Social and Human Dynamics:** Human systems are complex because people have free will, memories, and the ability to learn. They do not react like billiard balls; they adapt. Therefore, social systems are "complex adaptive systems" (CAS) that evolve and self-organize\[7\]\[8\].

\--------------------------------------------------------------------------------

### **2\. Advice on How to Deal with Complexity**

The sources unanimously agree that you cannot "solve" or "control" complexity using traditional, linear management tools (like rigid logframes or detailed long-term planning)\[9\]\[10\]. Instead, the advice focuses on **influencing**, **learning**, and **adapting**.

**A. Strategy: Probe, Sense, Respond (The Cynefin Approach)**

Because you cannot predict the future in a complex situation, you should not spend months analyzing data before acting. Instead, you must experiment.

• **Probe:** Create small, "safe-to-fail" experiments (probes) to test the system.

• **Sense:** Watch the results closely to see what patterns emerge.

• **Respond:** If a pattern is positive, amplify it (do more of what works). If it is negative, dampen it (stop doing it). This allows strategy to _emerge_ rather than be pre-planned\[11\].

**B. Influence the Conditions for Self-Organization (The CDE Model)**

Since you cannot control the outcomes, you should focus on managing the _conditions_ under which the system operates. Glenda Eoyang suggests focusing on three variables (CDE)\[12\]\[13\]:

1\. **Container (C):** Bounding the system (e.g., clarifying the team, the department, or the physical location) to determine who interacts with whom.

2\. **Differences (D):** Ensuring there is enough diversity (of opinion, skill, or background) to drive change, but not so much that it causes chaos. Difference is the "engine" of self-organization.

3\. **Exchanges (E):** Managing how agents interact (e.g., decision-making processes, communication flows, trust building). Altering the exchanges often shifts the system's behavior.

**C. Establish "Simple Rules"**

In complex systems, coherent behavior often emerges from agents following a few simple guiding principles rather than a thick rulebook.

• **Advice:** Develop a short list of "Simple Rules" that guide decision-making at all levels. For example, in a chaotic social services department, a simple rule like "Stay Connected" or "Learn your way into a shared future" helps independent staff align their actions without needing micromanagement\[14\]\[15\].

**D. Shift from "Gap Analysis" to "Appreciative Inquiry"**

Traditional management looks for gaps (what is missing) and tries to fill them. Complexity thinking suggests looking for **attractors** or "what is working."

• **Advice:** Identify positive patterns that are already naturally emerging (even if they are small) and fan the flames. Look for where energy and resources are naturally clustering and work with those forces rather than against them\[4\]\[16\].

**E. Use "Double-Loop" and "Triple-Loop" Learning**

Dealing with complexity requires more than just fixing errors (single-loop learning).

• **Double-Loop:** You must constantly question your underlying assumptions: "Are we doing the right things?"\[17\].

• **Triple-Loop:** You must question how you are deciding what is right, engaging with power dynamics and values: "How do we decide what is right?"\[18\].

**F. Adopt an Evolutionary Approach to Design**

Do not "design and install" a program. Instead, treat interventions as evolutionary.

• **Advice:** Be modest and humble. Recognize that the "best practice" from one context likely won't work in another. Design interventions that can co-evolve with the environment, allowing the "solution" to be discovered over time through interaction with local stakeholders\[19\].

### **Summary Table: The Shift in Approach**

| Traditional Approach (Reductionist) | Complexity Approach (Systems Thinking) |
| --- | --- |
| View of Reality: The world is a machine. | View of Reality: The world is a living organism. |
| Goal: Control and prediction. | Goal: Adaptation and resilience. |
| Method: Detailed pre-planning. | Method: Experimentation (Probe-Sense-Respond). |
| Focus: Parts and hierarchies. | Focus: Relationships and patterns. |
| Action: Implement "Best Practices." | Action: Develop "Simple Rules" and local solutions.[7] |

---
> [!info]- References
> [1] 118-The idea and practice of systems thinking and their rele.pdf
> [2] Evaluation-2011-Hummelbrunner-395-403.pdf
> [3] System Diagrams.pdf
> [4] 118-The idea and practice of systems thinking and their rele.pdf
> [7] CAP0901_37_ENG_DEF_LR Small.pdf
> [8] Systems thinking for evaluation.pdf
> [9] 118-The idea and practice of systems thinking and their rele.pdf
> [10] 118-The idea and practice of systems thinking and their rele.pdf
> [11] System Diagrams.pdf
> [12] Systems thinking for evaluation.pdf
> [13] Systems thinking for evaluation.pdf
> [14] Systems thinking for evaluation.pdf
> [15] Systems thinking for evaluation.pdf
> [16] Systems thinking for evaluation.pdf
> [17] Hummelbrunner - Learning systems concepts and values in evaluation.pdf
> [18] Hummelbrunner - Learning systems concepts and values in evaluation.pdf
> [19] CAP0901_37_ENG_DEF_LR Small.pdf


FILE: 'C. West Churchman.md'
---
exported: '2026-01-27T21:33:03.284Z'
source: NotebookLM
type: chat
title: C. West Churchman on 💬What is Complexity
tags:
  - West-Churchman
  - What-is-complexity
author: C. West Churchman
---
Based on the provided sources, particularly the works of C. West Churchman and his students like Peter Checkland and Werner Ulrich, complexity is fundamentally tied to the interconnectedness of systems, the limitations of human observation, and the moral implications of decision-making. Dealing with complexity requires a shift from seeking "optimal" mathematical solutions to engaging in continuous, ethical, and dialectical inquiry.

### What is Complexity?

**1\. Interconnectedness and the "Whole"**Complexity arises because components of the world are not separable; understanding a specific problem requires understanding the "whole system" in which it is embedded. Churchman draws on the theorem of Anaxagoras: "In everything there is everything," meaning that if a problem is unraveled far enough, one will encounter all other problems\[1\]. Consequently, complexity is the state where the observer is unable to fully comprehend the multi-dimensionality of a social system designing situation and becomes confused by it\[2\].

**2\. The Environmental Fallacy**Complexity manifests through the "environmental fallacy." This occurs when a decision-maker attempts to solve a problem by isolating it, failing to recognize that the system’s environment (factors outside the immediate control of the decision-maker) and the responses of outside systems will impact the outcome\[1\]. Churchman warns that ignoring these connections leads to "suboptimization," where improving a part of the system actually makes the whole system worse\[3\].

**3\. Wicked Problems**In the social realm, complexity takes the form of "wicked problems" (a term attributed to Horst Rittel). These are problems that are ill-formulated, where information is confusing, where there are many decision-makers with conflicting values, and where the ramifications throughout the whole system are confusing\[4\],\[5\]. Unlike "tame" problems (like puzzles or mathematics), wicked problems have no "stopping rule"—the problem solving process is never truly finished\[6\],\[7\].

### Advice on How to Deal with Complexity

Churchman and his colleagues propose that we cannot "solve" complexity in the traditional sense, but we can manage our inquiry into it through specific philosophical and practical approaches.

**1\. The "Systems Approach" Principles**Dealing with complexity requires a specific mindset regarding perspective and expertise. Churchman outlines the principles of a "deception-perception" approach:

• **See through the eyes of another:** The systems approach begins when you view the world through the eyes of another person\[8\],\[9\].

• **Recognize restriction:** It proceeds to the discovery that every worldview is terribly restricted\[8\],\[10\].

• **Abandon expertise:** There are no experts in the systems approach; assuming one can see the "whole elephant" is a piece of arrogance\[11\],\[8\].

**2\. "Sweeping In" and "Unfolding"**To counter the tendency to isolate problems, Churchman advocates for a Singerian approach of "sweeping in." This involves bringing in as many variables, perspectives, and disciplines as possible to understand the problem\[12\],\[13\]. This is coupled with the process of "unfolding," which analyzes the structural components of the system—such as the client, the decision-maker, and the purpose—to reveal the implications of the design\[14\],\[15\].

**3\. Dialectics and the "Enemies"**One must not rely solely on rational, logical models (hard systems thinking) to deal with complexity. Churchman argues that the "enemies" of the rational systems approach—Politics, Morality, Religion, and Aesthetics—must be embraced\[16\],\[17\].

• **Dialectical Inquiry:** The inquirer should use conflict and debate (Hegelian inquiry) to generate a synthesis from opposing worldviews\[18\],\[19\],\[20\].

• **Subjectivity:** One must recognize that data is not objective; it is "given" based on the system's underlying assumptions\[21\],\[22\].

**4\. The Design of Inquiring Systems**Dealing with complexity requires designing systems that can learn. Churchman categorizes different ways of inquiring based on historical philosophers:

• **Leibnizian:** Building fact nets and formal models (useful for structured complexity)\[23\].

• **Lockean:** Seeking consensus among a community\[23\].

• **Kantian:** Building different models (representations) to see which best fits the data\[23\],\[24\].

• **Singerian:** A "heroic" mood that sweeps in ethics and realizes that inquiry is endless\[18\].

**5\. Securing Improvement and Ethics**The ultimate advice for dealing with complexity is ethical. The goal is not just to solve a puzzle but to "secure improvement in the human condition"\[25\],\[26\].

• **The Inverted Sandwich:** In operations research, the "meat" is not the mathematical technique in the middle, but the beginning (understanding the system) and the end (implementation)\[27\].

• **Moral Outrage:** A system planner should be motivated by moral outrage (e.g., "kids are starving") rather than just a felt need or intellectual curiosity\[28\],\[29\].

• **Implementation:** An essential part of dealing with complexity is ensuring that the solution can actually be implemented ("secured") in the real world\[30\],\[26\].

**6\. Soft Systems Methodology (SSM)**Building on Churchman’s work, Peter Checkland suggests that in complex human affairs, we must abandon the "hard" engineering goal of optimizing a system towards a known goal. Instead, we should view systems as a learning process (Soft Systems Methodology). We construct intellectual models to structure a debate about change, seeking "accommodations" between conflicting interests rather than optimal solutions\[31\],\[32\].

In summary, the advice is to move from a "hard" view of the world as a set of problems to be solved by experts, to a "soft" or "critical" view where complexity is managed through continuous learning, debating conflicting values, inclusive "sweeping in" of perspectives, and a deep ethical commitment to human improvement\[26\],\[33\].
---

## 引用来源

[1] [Book] Gigch - Wisdom, Knowledge, and Management A Critique and Analysis of Churchmans Systems Approach.pdf
[2] [Book] Gigch - Wisdom, Knowledge, and Management A Critique and Analysis of Churchmans Systems Approach.pdf
[3] Churchman-Challenge-Reason-1-223-1968.pdf
[4] Assad 2011 C West Churchman.pdf
[5] churchman - on wicked problems.pdf
[6] Nelson 2003 - The Legacy of C West Churchman.pdf
[7] churchman in memoriam horst rittel.pdf
[8] Assad 2011 C West Churchman.pdf
[9] Gigch - 2006 - WISDOM , KNOWLEDGE , AND MANAGEMENT A Critique and Analysis of Churchman's Systems Approach - Unknown.pdf
[10] Gigch - 2006 - WISDOM , KNOWLEDGE , AND MANAGEMENT A Critique and Analysis of Churchman's Systems Approach - Unknown.pdf
[11] Assad 2011 C West Churchman.pdf
[12] Assad 2011 C West Churchman.pdf
[13] Mason 2014 - Churchman Interview with Mason and Mitroff.pdf
[14] Nelson 2003 - The Legacy of C West Churchman.pdf
[15] Retmolds - Churchman and Maturana enriching the notion of self organization for social design.pdf
[16] Assad 2011 C West Churchman.pdf
[17] Mason 2014 - Churchman Interview with Mason and Mitroff.pdf
[18] Checkland 1988 - Churchmans Anatomy of System Teleology revisited.pdf
[19] [Book] Churchman - The Design of Inquiring Systems.pdf
[20] [Book] Gigch - Wisdom, Knowledge, and Management A Critique and Analysis of Churchmans Systems Approach.pdf
[21] Assad 2011 C West Churchman.pdf
[22] [Book] Churchman - The Design of Inquiring Systems.pdf
[23] Checkland 1988 - Churchmans Anatomy of System Teleology revisited.pdf
[24] Churchman-Challenge-Reason-1-223-1968.pdf
[25] Assad 2011 C West Churchman.pdf
[26] Assad 2011 C West Churchman.pdf
[27] Assad 2011 C West Churchman.pdf
[28] Mason 2014 - Churchman Interview with Mason and Mitroff.pdf
[29] ulrich_2002f.pdf
[30] Assad 2011 C West Churchman.pdf
[31] Checkland 1988 - Churchmans Anatomy of System Teleology revisited.pdf
[32] Stowell - The Art of Systems Inquiry - retracing the footsteps of Churchman and Checkland.pdf
[33] Checkland 1988 - Churchmans Anatomy of System Teleology revisited.pdf


FILE: 'Christopher Alexander.md'
---
exported: 2026-02-09T23:36:51.252Z
source: NotebookLM
type: chat
title: Based on the sources, complexity in the built envi...
tags:
  - Christopher-Alexander
  - What-is-complexity
---
Based on the sources, complexity in the built environment is a condition of **organized complexity** characterized by nonlinear, non-random interactions between variables that produce emergent properties and coherent wholes\[1\]\[2\]. Christopher Alexander argues that modern design problems have reached "insoluble levels of complexity" because they involve a background of social, cultural, and informational needs that are too intricately related for the human mind to grasp intuitively\[3\].

To deal with this complexity, the sources provide the following advice and principles:

### **1\. Use Decompositions to Manage Cognitive Limits**

Since human designers have a limited capacity for the number of issues they can consider simultaneously, they must find ways to simplify the problem without losing its essential structure\[6\]\[7\].

• **Subsystem-by-Subsystem Adaptation:** No complex system can adapt successfully unless it proceeds by modifying independent subsystems one at a time\[8\].

• **Formalizing Misfits:** Designers should define a problem by identifying specific "misfits" (potential errors or points of failure) rather than trying to list all requirements, as it is easier to define what does not fit than what does\[11\].

### **2\. Implement Generative Systems**

Alexander advises shifting from a "fabricated" approach (building from a static blueprint) to a "generated" approach (growing from a set of rules)\[14\]\[15\].

• **Pattern Languages:** A pattern language provides a "kit of parts" and rules for combination that allow complex, well-adapted structures to emerge\[15\]\[16\]. Each pattern identifies a recurring problem in a specific context and offers a configuration that resolves the conflicting forces involved\[17\].

• **Compression:** Patterns function as a form of "compression," encoding rich spatial relationships and human experience into a scannable format that laypeople and professionals alike can use to solve complex problems\[20\]\[21\].

### **3\. Adopt Piecemeal Growth and Incremental Adaptation**

Large-scale "master planning" often fails because it attempts to solve more complexity than a single mind can assimilate at once\[22\]\[23\].

• **Incremental Growth:** The only effective way to cope with change is through "piecemeal growth," where construction is weighted toward small projects and continuous repair rather than "large lump" development\[24\]\[25\].

• **Testing and Learning:** This stage-by-stage process allows for time to get decisions right, as mistakes can be corrected after initial construction through constant adaptation to change\[24\]\[26\].

### **4\. Follow an "Unfolding" Process**

Instead of imposing an abstract form, design should be a process of "differentiation" where the whole precedes the parts\[27\]\[28\].

• **Structure-Preserving Transformations:** Complexity should be handled by applying transformations that strengthen and enhance the "wholeness" or "centers" already present at a site\[27\].

• **Harmony-Seeking Computations:** This approach treats design as a series of steps where each move forward evaluates how it participates in and heals the larger whole around it\[31\]\[32\].

### **5\. Empower Local Agency and Human Feeling**

Complexity is best mastered by those directly involved in a space\[26\].

• **User Participation:** Alexander insists that all decisions about what and how to build should be in the hands of the users, who possess the local knowledge necessary to recognize misfits and implement exact repairs\[25\]\[26\].

• **Feeling as a Precision Tool:** Human feeling should be treated as an objective, measurable indicator of a system's "life" or "harmony"\[33\]. A structure is well-adapted if it mirrors or expands the user's own sense of wholeness\[36\]\[37\].

### **6\. Seek Deep Simplicity**

Alexander argues that true simplicity is not the absence of complexity but the result of a process that resolves it elegantly\[38\].

• **Simplicity via Complexity:** One should strive for "the simplest way to add the necessary complexity" to a structure to resolve its internal conflicts\[38\]\[39\].

• **The Edge of Chaos:** Effective design exists at the boundary of order and chaos—a place balanced between predictability and unpredictability that produces "Beauty" and "Life"\[40\].

---
> [!info]- References
> [1] A search for beauty a struggle with complexity Alexander.pdf
> [2] Alexander - Harmony seeking computations.pdf
> [3] Alexander - 1965 The Theory And Invention Of Form.pdf
> [6] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [7] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [8] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [11] Thesis - Steenseon - architectures of information  christopher alexander  cedric price.pdf
> [14] A search for beauty a struggle with complexity Alexander.pdf
> [15] Coevolving innovations systems generating systems architectural design theory by Christopher Alexander -1968.pdf
> [16] Coevolving innovations systems generating systems architectural design theory by Christopher Alexander -1968.pdf
> [17] A search for beauty a struggle with complexity Alexander.pdf
> [20] Thesis - Steenseon - architectures of information  christopher alexander  cedric price.pdf
> [21] Thesis - Steenseon - architectures of information  christopher alexander  cedric price.pdf
> [22] A search for beauty a struggle with complexity Alexander.pdf
> [23] A search for beauty a struggle with complexity Alexander.pdf
> [24] A search for beauty a struggle with complexity Alexander.pdf
> [25] A search for beauty a struggle with complexity Alexander.pdf
> [26] A search for beauty a struggle with complexity Alexander.pdf
> [27] A search for beauty a struggle with complexity Alexander.pdf
> [28] Systems Changes Ing Learning Alexander Legacy.pdf
> [31] Alexander - Harmony seeking computations.pdf
> [32] Alexander - Harmony seeking computations.pdf
> [33] A search for beauty a struggle with complexity Alexander.pdf
> [36] A search for beauty a struggle with complexity Alexander.pdf
> [37] Analytical approach on design theories of christopher alexander.pdf
> [38] A search for beauty a struggle with complexity Alexander.pdf
> [39] A search for beauty a struggle with complexity Alexander.pdf
> [40] A search for beauty a struggle with complexity Alexander.pdf


FILE: 'Claude Shannon.md'
---
exported: '2026-01-27T21:57:36.419Z'
source: NotebookLM
type: chat
title: Claude Shannon on 💬What is Complexity
tags:
  - Claude-Shannon
  - What-is-complexity
aliases:
  - Complexity is a multifaceted concept often charact...
linter-yaml-title-alias: Complexity is a multifaceted concept often charact...
author: Claude Shannon
---

# Complexity is a multifaceted concept often charact...

导出时间: 27/01/2026, 21:57:36

---

Complexity is a multifaceted concept often characterized by the presence of numerous interacting components that produce behaviors not predictable from the properties of the individual parts alone. Dealing with complexity requires shifting from rigid, deterministic management styles to adaptive, experimental, and transdisciplinary approaches.

### **Defining Complexity**

There is no single, consistently understood definition of complexity, but several key distinctions and categories appear across the sources:

• **Complex vs. Complicated:** A critical distinction is made between these two terms. A "complicated" system, such as a jumbo jet, has many intricate parts, but they can be identified, analyzed, dissembled, and reassembled without changing the nature of the system\[1\],\[2\]. In contrast, a "complex" system, like mayonnaise, involves interactions that are irreversible; once the elements interact, they cannot be simply separated back into their original components\[3\],\[2\].

• **Emergence:** This is often considered the defining characteristic of complexity\[4\],\[5\]. Emergence refers to global behaviors or phenomena that arise from the interactions of the system's parts but cannot be traced back to or predicted by any individual component\[6\],\[7\]. It creates a "non-additive property" where the whole is greater than the sum of its parts\[7\].

• **Organized vs. Disorganized:** Weaver distinguished between "disorganized complexity" (problems with millions of variables addressed by statistics) and "organized complexity," which involves a sizable number of variables that interact in correlated, organic ways\[8\],\[9\].

• **Variety Induced Complexity:** In industrial contexts, complexity is often driven by a high variety of product variants (internal variety) responding to market demands (external variety)\[10\],\[11\]. This leads to "complexity cost," which is the cost of indirect functions like designing, testing, and documenting variants\[12\].

• **Algorithmic Complexity:** From a mathematical perspective, Kolmogorov defined complexity as the length of the shortest binary computer program required to describe a sequence\[13\].

### **The Implications of Complexity**

Complexity introduces unpredictability and non-linearity into systems. In complex systems, seemingly minor changes can produce significant consequences (the butterfly effect), and solutions often emerge dynamically rather than following a linear plan\[14\]. Because of these traits, traditional systems engineering—which relies on requirements and predicting outcomes—often fails when applied to complex systems\[15\],\[16\]. The root of many failures in large programs is the attempt to predict the outcome of a process that is fundamentally not predictable\[16\].

### **Advice on How to Deal with Complexity**

The sources suggest that complexity cannot be eliminated, but it can be managed or mitigated through specific frameworks and shifts in mindset.

**1\. Adopt Sensemaking Frameworks (The Cynefin Framework)**

To determine the appropriate management strategy, one must identify the type of system using the Cynefin Framework:

• **Obvious/Simple:** Causality is clear. Use "Best Practice" and a **Sense-Categorize-Respond** approach\[17\].

• **Complicated:** Cause and effect require analysis. Use "Good Practice" and a **Sense-Analyze-Respond** approach\[18\].

• **Complex:** Cause and effect are only visible in hindsight. There are no right answers in advance. The advice is to use a **Probe-Sense-Respond** approach, conducting multiple safe-to-fail experiments to allow solutions to emerge\[19\],\[18\].

• **Chaotic:** No clear cause and effect. Requires immediate action to stabilize the situation (**Act-Sense-Respond**)\[20\].

**2\. Utilize Agile and Adaptive Methods**

Because complex systems are unpredictable, relying on rigid, pre-planned requirements is often impractical\[21\].

• **Agile Development:** Use small, cross-functional teams (typically under 15 people) that work in short iterations\[22\],\[23\]. This allows for rapid learning, constant feedback, and the flexibility to respond to change rather than following a fixed plan\[23\],\[24\].

• **Safe-to-Fail Experiments:** Instead of trying to avoid failure, use rapid, small-scale experiments to learn what works and what does not\[25\],\[24\].

**3\. Implement the "Digital Twin"**

For engineering complex systems, a "Digital Twin" can be used to mitigate unpredictable, undesirable emergent behaviors\[26\].

• This involves creating a virtual version of the system to simulate design, manufacturing, and usage\[26\].

• By "front-running" simulations with real-time data, engineers can uncover complexity issues and potential failures before the physical system is deployed\[27\],\[28\].

**4\. Manage Variety and Costs (Modularization)**

To handle variety-induced complexity in manufacturing:

• **Modularization:** Develop modular product families where components have standardized interfaces and decoupled functions\[29\]. This allows for "commonality," where different product variants share common modules, reducing internal complexity costs while maintaining external variety\[29\],\[30\].

• **Cost Analysis:** Use transdisciplinary cost estimation methods to understand how complexity impacts different departments (sales, logistics, production) differently\[31\].

**5\. Achieve Organizational Congruence (The CX Tool)**

To manage the complexity of human and organizational systems, leaders should strive for "congruence" between what the organization thinks (Organizational Intelligence) and what it does (Performance Management)\[32\],\[33\].

• The **CX Tool** helps visualize and measure the alignment between ideas, processes, and actions\[34\]. When thinking and doing are aligned, the system functions more effectively; when they are disjointed, dysfunction arises\[35\].

**6\. Apply Triz for Problem Solving**

For solving difficult problems within complex systems without trading off one benefit for another (e.g., strength vs. weight), the **Triz** methodology (Theory of Inventive Problem Solving) is recommended\[36\].

• Triz aims to resolve contradictions entirely rather than compromising\[37\].

• It focuses on increasing the "ideality" of a system—maximizing useful functions while minimizing harmful ones\[38\].

**7\. Challenge Deep-Rooted Assumptions**

Finally, some advice points to a fundamental shift in perception. The burden of complexity may be a symptom of using an outdated worldview (the "craftsman mentality") that views systems as constructions of parts\[39\],\[40\].

• **Alternative Viewpoint:** Instead of focusing on parts and connections, complexity may be better managed by viewing systems as "coherent wholes" or "value structures" that seek to satisfy specific objectives\[41\],\[42\]. This shift involves defining a system not by its components, but by its ability to resolve a need\[42\].

In summary, dealing with complexity requires acknowledging that unpredictability is inherent\[43\]. Success comes not from rigid control, but from adaptive learning, modular design, holistic alignment of organizational goals, and the use of simulation and experimentation to probe the system's behavior\[24\],\[27\],\[44\].
---

## 引用来源

[1] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[2] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[3] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[4] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[5] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[6] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[7] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[8] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[9] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[10] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[11] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[12] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[13] Rioul - This is IT a primer on Shannon Entropy and Information.pdf
[14] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[15] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[16] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[17] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[18] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[19] Unknown - Medical Leadership Complex Systems Open Data - Shannon, Shannon - Unknown.pdf
[20] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[21] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[22] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[23] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[24] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[25] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[26] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[27] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[28] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[29] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[30] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[31] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[32] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[33] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[34] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[35] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[36] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[37] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[38] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[39] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[40] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[41] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[42] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[43] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
[44] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf


FILE: 'Colin Eden.md'
---
tags:
  - Colin-Eden
  - What-is-complexity
title: Colin Eden on 💬What is Complexity
author: Colin Eden
---
Complexity is defined as a state involving **many interactions and associations, emergent understandings, and nonlinear dynamics** 1-3. It is frequently associated with "Grand Challenges" (GC) or "wicked, messy problems" that lack clear solutions or definitive formulations 4-6. In social systems, complexity is often measured by **variety**, which refers to the number of distinguishable elements and relationships contained within a system boundary 7, 8\.

### Dimensions of Complexity

Complexity is generally understood through several distinct dimensions:

* **Process Complexity:** This involves the engagement of **multiple stakeholders from diverse backgrounds** who bring varying perspectives, interests, and fundamental philosophies to a problem 9-11.  
* **Content (or Cognitive) Complexity:** This relates to significant intangibles, **perplexing uncertainties**, and the extensive interactivity between different issues or systems 12-14.  
* **Time and Distance Complexity:** Particularly in "super wicked" problems like climate change, complexity is extended by the need for **sustained effort over long horizons** and the requirement to cut across extensive geographical and jurisdictional boundaries 5, 15-17.

### Advice for Dealing with Complexity

The sources recommend utilizing **Problem Structuring Methods (PSM)** and **Behavioural Operational Research (BOR)** to navigate these environments 4, 12, 18\. Specific advice includes:  
**1\. Attend to both Process and Content**To successfully navigate complex challenges, you must elicit a comprehensive understanding of the data (content) while simultaneously attending to **myriad socio-political considerations** (process) 4, 19, 20\. Effective group work requires a balance between achieving high-quality rationality and building **emotional commitment** among those who must implement the decisions 21, 22\.  
**2\. Use Visual Mapping Techniques**Techniques such as **Cognitive Mapping** and **SODA (Strategic Options Development and Analysis)** are advised to capture and structure the thinking of various actors 13, 23, 24\. These maps help manage **cognitive load** by providing a graphical representation of a problematic situation, allowing groups to explore options and their ramifications without becoming overwhelmed by information 13, 14, 23, 25\.  
**3\. Implement "Chunking" and Clustering**When faced with a highly complex model or map, advice is to **"chunk" the information into clusters** or themes 26-28. This disaggregates the "big picture" into more manageable portions, allowing the group to identify a system of interrelated sub-problems rather than trying to solve a single, massive "mess" all at once 26, 29, 30\.  
**4\. Create Participatory Architectures and Safe Spaces**Because complex problems are comprehended in multiple ways depending on an actor's position, you should provide **"safe spaces" for effective dialogue** 9, 11, 31\. This might include using software that allows for **anonymous contributions**, ensuring that "multivocality" is preserved and that all stakeholders feel their views have been heard, which promotes a sense of **procedural justice** 11, 32-34.  
**5\. Pursue Robust Action and "Small Wins"**In environments of radical uncertainty, it is impossible to define all future states 35\. Advice is to adopt strategies of **robust action**, which involve pursuing **small incremental wins** that foster learning and increase engagement 31, 36, 37\. Focus on options that are "robust" because they remain effective across multiple possible future scenarios 38-40.  
**6\. Avoid Inappropriate Simplification**While managing complexity is essential, the sources warn that **simplification can be dangerous** if it strips away the subtlety and richness that characterize the real issue 41-43. Instead of reducing variety, aim to **structure it** so that the "nub of the issue" can be identified while retaining a systemic view of the situation 23, 44, 45\.  


FILE: 'Dave Snowden.md'
---
exported: '2026-01-27T20:01:33.730Z'
source: NotebookLM
type: chat
title: Dave Snowden on 💬What is Complexity
tags:
  - Dave-Snowden
  - What-is-complexity
author: Dave Snowden
---
In the context of the Cynefin framework and complexity science, a complex system is fundamentally distinct from an ordered one; it is characterized by "unknown unknowns" where the relationship between cause and effect exists but can only be perceived in retrospect\[1\],\[2\],\[3\]. Unlike an ordered system, where outcomes are predictable and repeatable, a complex system involves large numbers of interacting elements (agents) where minor changes can produce disproportionately major consequences\[4\]. In these systems, agents and the system constrain one another over time, meaning the system is dynamic and irreversible; one cannot simply reset it to a prior state\[4\].

Complexity is described as "dispositional" rather than "causal," meaning the system has a propensity to evolve in certain directions, but specific outcomes cannot be predicted or modeled using standard linear physics\[5\]. It is the domain of emergence, where solutions cannot be imposed but must arise from the circumstances\[4\]. A useful metaphor provided in the sources contrasts a Ferrari with the Brazilian rainforest: a Ferrari is complicated (an expert can take it apart and reassemble it), whereas a rainforest is complex (it is in constant flux, and the whole is far greater than the sum of its parts)\[6\].

Furthermore, "anthro-complexity" distinguishes human complex systems from biological ones (like ant colonies) because human agents possess identity, intelligence, and intention, and are capable of fluidly changing identities based on context\[7\],\[8\],\[9\].

### Advice on How to Deal with Complexity

Dealing with complexity requires a fundamental shift away from the command-and-control styles suited for ordered environments\[10\]. The primary advice for navigating complexity includes:

**1\. The Decision Model: Probe, Sense, Respond**Instead of attempting to analyze the situation upfront (which works for complicated problems) or categorizing it (which works for simple problems), leaders in a complex domain must "probe, sense, and respond"\[11\],\[12\]. This involves acting experimentally to determine the landscape before making large commitments\[12\].

**2\. Safe-to-Fail Experiments**The most critical advice is to manage in the present through parallel, "safe-to-fail" experimentation\[13\].

• **Parallelism:** Experiments should run in parallel rather than sequentially (like in Lean Startup methods) because complex systems change; sequential testing may lead to false positives based on obsolete context\[14\].

• **Amplification and Dampening:** Leaders must monitor these experiments for emergent patterns; beneficial patterns should be amplified, while negative patterns should be dampened\[13\],\[14\],\[15\].

• **Tolerance for Failure:** Leaders must accept failure as a necessary part of learning in this domain; demanding fail-safe business plans in a complex context will lead to failure\[16\].

**3\. Manage Starting Conditions and Constraints**Because you cannot forecast outcomes in a complex system, you must manage the "starting conditions" and monitor for emergence\[17\],\[18\].

• **Enabling Constraints:** Move from rigid, governing constraints (typical of ordered systems) to enabling constraints\[19\],\[20\]. These constraints should be flexible and permeable, allowing for the discovery of new possibilities\[21\].

• **Granularity:** Work with fine-grained objects and information to allow for more flexible recombination and adaptation\[22\],\[23\].

**4\. Abandon "Best Practice"**Applying "best practice" in a complex domain is illegitimate and dangerous because it assumes a repeatability that does not exist\[24\],\[25\]. In complex contexts, practice is "emergent," meaning a new way of doing things evolves from the specific situation\[11\],\[26\]. Relying on expert diagnosis alone is also insufficient, as experts are prone to "entrained thinking" and may miss novel solutions\[27\].

**5\. Utilize Distributed Cognition and Diversity**To detect weak signals and emerging patterns, organizations should leverage distributed cognition and human sensor networks\[28\],\[8\].

• **Requisite Diversity:** Increase levels of interaction and communication, and encourage dissent and diversity to challenge established thinking\[10\],\[18\].

• **Disintermediation:** Decision-makers need direct contact with raw data and the environment, rather than relying on sanitized reports which may strip away critical context\[22\],\[29\].

**6\. Manage for Serendipity and Pattern Recognition**Humans make decisions based on patterns rather than logical rules; therefore, the goal is to create environments where beneficial patterns can emerge\[30\],\[31\]. This involves managing attractors (things that stabilize behavior) and barriers to influence the system's trajectory without trying to control specific outputs\[32\],\[33\].

**7\. Avoid "Chaos" through Awareness**If a complex system is over-constrained or treated as a simple system, it is liable to suffer a catastrophic collapse into chaos\[19\],\[34\]. This collapse is often represented as a "cliff" between the Simple and Chaotic domains\[35\]. To avoid this, leaders must recognize when a situation is complex and resist the urge to impose excessive order or bureaucracy\[36\].

---
> [!info]- References
> [1] 27036324 HBR snowden leaders decision making.pdf
> [2] 27036324 HBR snowden leaders decision making.pdf
> [3] cynefin framework for clinical reasoning and decision making.pdf
> [4] 27036324 HBR snowden leaders decision making.pdf
> [5] 044_ Making Sense of Human Systems an interview with Professor Dave Snowden.pdf
> [6] 27036324 HBR snowden leaders decision making.pdf
> [7] Separated by a common language_ - The Cynefin Co.pdf
> [8] Snowden - Good fences make good neighbors 2011.pdf
> [9] snowden complex acts of knowing.pdf
> [10] 27036324 HBR snowden leaders decision making.pdf
> [11] 27036324 HBR snowden leaders decision making.pdf
> [12] 27036324 HBR snowden leaders decision making.pdf
> [13] 044_ Making Sense of Human Systems an interview with Professor Dave Snowden.pdf
> [14] Cynefin Paper report.pdf
> [15] Snowden - Naturalising Knowledge Management.pdf
> [16] 27036324 HBR snowden leaders decision making.pdf
> [17] Snowden - Multi-ontology sense making.pdf
> [18] snowden multi-ontology sense making 578-1421-1-PB.pdf
> [19] 044_ Making Sense of Human Systems an interview with Professor Dave Snowden.pdf
> [20] systems-10-00007 Snowden - The Substrate-Independence Theory.pdf
> [21] Rettig.Snowden-ComplexityTheoryAndNarrativeResearch_notes.pdf
> [22] Cynefin Paper report.pdf
> [23] The-Cynefin-Mini-book-online.pdf
> [24] Snowden - Complex Acts of Knowing.pdf
> [25] snowden managing for serendipity.pdf
> [26] Dave-Snowden-IEA14.pdf
> [27] 27036324 HBR snowden leaders decision making.pdf
> [28] Rettig.Snowden-ComplexityTheoryAndNarrativeResearch_notes.pdf
> [29] EU Managing Complexity (and chaos) in Times of Crisis.pdf
> [30] Snowden - Complex Acts of Knowing.pdf
> [31] Snowden - Perspectives Around Emergent Connectivity Sensemakimg and Asymmetric Threat Managmenet 2006.pdf
> [32] Snowden - Multi ontology sense making v2-May05.pdf
> [33] Snowden - Naturalising Knowledge Management.pdf
> [34] EU Managing Complexity (and chaos) in Times of Crisis.pdf
> [35] EU Managing Complexity (and chaos) in Times of Crisis.pdf
> [36] Snowden & Boone HBR Leaders Framework.pdf


FILE: 'David L Abel.md'
---
exported: '2026-01-27T18:38:05.535Z'
source: NotebookLM
type: chat
title: David L. Abel
tags:
  - David-L-Abel
  - What-is-complexity
aliases:
  - Complexity is mathematically defined as randomness...
linter-yaml-title-alias: Complexity is mathematically defined as randomness...
---

# Complexity is mathematically defined as randomness...

**Complexity** is mathematically defined as **randomness** and the lack of order, pattern, or compressibility\[1\],\[2\]. In the context of life-origin models and information theory, the sources define complexity and advise on how to interpret it as follows:

### What is Complexity?

**1\. Maximum Complexity is Randomness**Scientific literature defines maximum complexity as randomness because a random sequence lacks patterns and order, meaning it **cannot be algorithmically compressed**\[1\],\[2\],\[3\]. A sequence that is maximally complex has no description shorter than the sequence itself\[4\].

**2\. Complexity is Antithetical to Order**Complexity and order lie at opposite ends of a spectrum\[5\],\[6\].

• **High Order:** Associated with high predictability, redundancy, and compressibility (e.g., a crystal or a polymer of repeating adenosine)\[4\],\[7\]. High order represents **Ordered Sequence Complexity (OSC)**\[8\].

• **High Complexity:** Associated with high uncertainty, low compressibility, and a lack of pattern\[2\],\[6\]. This represents **Random Sequence Complexity (RSC)**\[8\].

**3\. Complexity is Blind to Function**Crucially, **complexity has absolutely nothing to do with function**, meaning, or utility\[9\],\[10\]. A sequence can be maximally complex (random) yet possess no instruction or bio-function\[11\]. Therefore, complexity alone cannot explain the sophisticated utility found in living systems\[12\].

### Advice on How to Deal with Complexity

To accurately address the origins of life and biological systems, the sources advise rejecting the vague use of "complexity" in favor of precise distinctions regarding organization, control, and functional information:

**1\. Distinguish Complexity from Organization**Investigators are advised not to confuse **complexity** with **organization**\[13\].

• **Organization** is abstract, conceptual, and goal-oriented; it requires "choice contingency" (purposeful selection) at decision nodes to integrate circuits and functions\[13\],\[14\].

• **Complexity** (randomness) cannot organize anything; it cannot steer events toward utility or computational success\[15\],\[10\].

• Therefore, the term **"self-organization"** is often a misnomer applied to phenomena that are merely **"self-ordering"** (like crystals or vortices), which are low-informational and redundant rather than organized\[16\],\[17\],\[18\].

**2\. Utilize the Three Subsets of Sequence Complexity**To deal with the nuances of biological information, one should distinguish between three specific types of complexity:

• **Random Sequence Complexity (RSC):** High uncertainty, no pattern, no function (e.g., stochastic ensembles)\[19\],\[20\].

• **Ordered Sequence Complexity (OSC):** High pattern, low uncertainty, no function (e.g., crystals, polyadenosines)\[19\],\[20\].

• **Functional Sequence Complexity (FSC):** This is the specific type of complexity required for life. It appears close to the random end of the spectrum but is distinguished by **non-random selection for function** (e.g., genetic instructions)\[21\],\[8\],\[22\].

**3\. Move Beyond Shannon Uncertainty Measures**Researchers are advised that **Shannon entropy** (uncertainty) measures only probabilistic combinatorialism, not meaning or instructional function\[23\],\[24\]. Shannon theory quantifies the "surprise" of a signal but cannot distinguish between a meaningful message and nonsense\[25\]. To deal with biological complexity, one must measure **Prescriptive Information (PI)** or **"fits" (functional bits)**, which quantify the degree of functional selection rather than just combinatorial possibilities\[26\],\[27\],\[28\].

**4\. Acknowledge the Necessity of Choice and Control**To explain the "conceptual complexity" of life, science must acknowledge **Choice Contingency** (selection) as a fundamental category of reality alongside Chance and Necessity\[29\],\[30\].

• **Constraints vs. Controls:** Do not confuse constraints (physical limits like laws or initial conditions) with controls (formal choices made to achieve a goal)\[31\],\[32\]. Life is **controlled**, not merely constrained\[33\].

• **The "Edge of Chaos":** Avoid relying on poetic but scientifically empty concepts like "emergence at the edge of chaos," as neither chaos nor complexity can program the algorithmic decision nodes required for life\[34\],\[35\].

**5\. Recognize the Formal Nature of Life**The sources advise that life should be viewed as **formal computation** and **algorithmic programming** rather than mere physicodynamic interaction\[36\],\[37\]. Dealing with biological complexity requires recognizing that **Formalism > Physicality (The F > P Principle)**: formal instructions (like genetic code) prescribe and govern physical events to create utility, rather than arising from them\[38\],\[39\].

---
> [!info]- References
> [1] Abel - Complexity self-organization and emergence at the edge of chaos in life origin models.pdf
> [2] Abel - The Capabilities of Chaos and Complexity.pdf
> [3] Abel - The capabilities of chaos and complexity.pdf
> [4] Abel - Complexity self-organization and emergence at the edge of chaos in life origin models.pdf
> [5] Abel - What utility does order patter or complexity prescribe.pdf
> [6] Abel - The capabilities of chaos and complexity.pdf
> [7] Abel - What utility does order patter or complexity prescribe.pdf
> [8] Abel - Complexity self-organization and emergence at the edge of chaos in life origin models.pdf
> [9] Abel - Complexity self-organization and emergence at the edge of chaos in life origin models.pdf
> [10] Abel - What utility does order patter or complexity prescribe.pdf
> [11] Abel - The capabilities of chaos and complexity.pdf
> [12] Abel - What utility does order patter or complexity prescribe.pdf
> [13] Abel - What utility does order patter or complexity prescribe.pdf
> [14] Abel - The Capabilities of Chaos and Complexity.pdf
> [15] Abel - The Three Fundamental Categories of Reality.pdf
> [16] Abel - Assembly theory in life-origin models a critical review.pdf
> [17] Abel - Self organisation vs self ordering events in Life origin models.pdf
> [18] Abel - What utility does order patter or complexity prescribe.pdf
> [19] Abel - Constraints vs Controls.pdf
> [20] Abel - What utility does order patter or complexity prescribe.pdf
> [21] Abel - Complexity self-organization and emergence at the edge of chaos in life origin models.pdf
> [22] Abel - Constraints vs Controls.pdf
> [23] Abel - Assembly theory in life-origin models a critical review.pdf
> [24] Abel - Assembly theory in life-origin models a critical review.pdf
> [25] Abel_D_L_2009_The_biosemiosis_of_prescri.pdf
> [26] Abel - Constraints vs Controls.pdf
> [27] Abel - Constraints vs Controls.pdf
> [28] Abel - Is Life Reducible to Complexity.pdf
> [29] Abel - The Three Fundamental Categories of Reality.pdf
> [30] Abel - The Three Fundamental Categories of Reality.pdf
> [31] Abel - Constraints vs Controls.pdf
> [32] Abel - The Three Fundamental Categories of Reality.pdf
> [33] Abel - Assembly theory in life-origin models a critical review.pdf
> [34] Abel_D_L_2007_Complexity_self_organizati.pdf
> [35] Abel - What utility does order patter or complexity prescribe.pdf
> [36] Abel - Assembly theory in life-origin models a critical review.pdf
> [37] Abel - What is life.pdf
> [38] Abel - What is life.pdf
> [39] Abel - The Cybernetic Cut and Configurable Switch Bridge.pdf


FILE: 'Dee Hock.md'
---
exported: '2026-01-28T11:28:19.758Z'
source: NotebookLM
type: chat
title: Dee Hock on 💬What is Complexity
tags:
  - Dee-Hock
  - What-is-complexity
author: Dee Hock
---
### Understanding Complexity and the "Chaordic" Space

In the context of organizational design and leadership, complexity refers to environments characterized by high levels of uncertainty, rapid change, unpredictability, and emergent phenomena\[1\]. Unlike ordered or linear systems where outcomes can be controlled and predicted, complex systems—such as communities, organizations, and biological ecosystems—cannot be fully known or controlled\[1\]\[2\].

To describe this state, Dee Hock, founder of VISA, coined the term **"chaordic"** (a combination of **cha**os and **ord**er)\[3\]\[4\]. A "chaord" is any self-organizing, adaptive, non-linear complex system that exhibits characteristics of both chaos and order\[5\]. In this space, distinct from the linear and predictable, business and social organizations must blend "intellectual and experiential learning" harmoniously\[6\].

### Advice on Dealing with Complexity

Dealing with complexity requires a fundamental shift from "command and control" management to adaptive, participatory, and principle-based leadership. The sources offer specific advice through the **Chaordic Systems Thinking (CST)** framework and the **Chaordic Stepping Stones** planning tool.

1\. Shift Your Mindset: From Control to Emergence

Traditional management relies on "Open Systems Thinking," which seeks stability and equilibrium\[7\]\[8\]. However, in complex environments, organizations should embrace **Chaordic Systems Thinking**, which recognizes that systems thrive in "Far-From-Equilibrium" conditions\[9\].

Key mindset shifts include:

• **Abandon Control for "Controllability":** You cannot control specific outcomes in a complex system. Instead, aim for "controllability," defined as the capacity to maintain balance amid changing configurations\[10\]. Leaders should "disturb" the system to move it toward the edge of chaos, where innovation happens, rather than trying to force stability\[11\]\[12\].

• **Focus on the "Interior":** Unlike traditional approaches that focus on external structures, dealing with complexity requires changing the "organizational mind" or collective consciousness\[13\]. Deep change requires "learning from within" and shifting shared beliefs and assumptions\[14\]\[15\].

• **Accept Indeterminacy:** Because the future in a complex system is unknowable, do not waste time planning for a fixed future. Instead, invest resources in preparing for _any_ possibility\[16\].

2\. Use the Chaordic Stepping Stones for Planning

For designing meetings, initiatives, or organizations within complexity, the sources recommend a specific planning tool called the **Chaordic Stepping Stones**. This process encourages you to "slow down to speed up," investing time in groundwork to ensure effectiveness later\[17\]\[18\].

The steps should be approached sequentially but revisited iteratively:

• **1\. Identify the Need (Necessity):** Determine the compelling, present reason for doing the work. Ask: "What time is it for this work?" and "What is at stake?"\[19\]\[20\].

• **2\. Articulate the Purpose:** Create a clear, compelling statement of direction (not a destination) that guides the work. Purpose is the "invisible leader"\[21\]\[22\].

• **3\. Define Principles:** Agree on behavioral principles that guide how the group works together. These must be simple and co-owned (e.g., "everyone has a chance to speak") to sustain relationships when plans break down\[23\]\[24\].

• **4\. Map the People:** Identify who needs to be involved. Use a "levels of engagement" map to distinguish between the core team, essential stakeholders, those to be consulted, and those to be informed\[25\]\[26\].

• **5\. Develop a Concept:** Create a high-level framework or prototype of the initiative. This allows for experimentation before finalizing structure\[27\]\[28\].

• **6\. Confront Limiting Beliefs:** actively identify and question fears, assumptions, and historical patterns (e.g., "We've always done it this way") that might block innovation\[29\]\[30\]. Failure to do this often builds old fears into new structures\[31\].

• **7\. Design the Structure:** Only _after_ the previous steps, decide on the concrete logistics, roles, and resources. Structure should channel resources to enable the work, not control it\[32\]\[33\].

• **8\. Plan the Harvest:** Determine how to capture and make meaning of the results. Harvesting should be **PLUME**: Participatory, Learning-oriented, Useful, Multi-modal, and Emergent\[34\].

3\. Adopt Chaordic Leadership

Leadership in complexity is not about exercising authority over subordinates. It requires "educing" (drawing forth) latent potential and behavior rather than compelling it\[35\].

Dee Hock’s advice for managers in a chaordic environment is to reprioritize responsibilities:

1\. **Manage Self (50% of time):** Focus on your own integrity, ethics, and temperament. Without this, you are unfit for authority\[36\].

2\. **Manage Superiors (25% of time):** You cannot lead without the support and consent of those with authority over you\[37\].

3\. **Manage Peers (20% of time):** You need the respect and confidence of associates and competitors\[38\].

4\. **Manage Subordinates:** If you handle the first three well, you need only employ good people and free them to manage themselves\[39\].

4\. Structure for "Holonic" Capacity

Organizations should be viewed as **holons**—entities that are simultaneously independent wholes and dependent parts of a larger system\[40\]\[41\]. To deal with complexity:

• **Distribute Power:** No function should be performed by a central part if a peripheral part can do it. Governance should be distributed so no single individual or institution dominates\[42\]\[43\].

• **Maximize Connectivity:** Minimize boundaries and divisions. Change must affect the whole system\[44\].

• **Encourage Diversity:** The organization should embrace diversity and attract people comfortable with change\[43\].

In summary, dealing with complexity involves abandoning the illusion of mechanical control. Instead, you must anchor work in a clear shared purpose and ethical principles, distribute power to the edges of the system, and engage in continuous, participatory learning to navigate the unknown\[45\]\[46\].

---
> [!info]- References
> [1] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [2] Chaordic Stepping Stones w.Template Harvest 2025.pdf
> [3] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [4] Dee Hock - The Chaordic Organization Review.pdf
> [5] Dee Hock - The Chaordic Organization Review.pdf
> [6] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [7] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [8] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [9] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [10] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [11] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [12] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [13] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [14] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [15] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [16] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [17] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [18] Chaordic Stepping Stones w.Template Harvest 2025.pdf
> [19] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [20] Corrigan - The Chaordic Stepping Stones.pdf
> [21] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [22] Corrigan - The Chaordic Stepping Stones.pdf
> [23] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [24] Corrigan - The Chaordic Stepping Stones.pdf
> [25] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [26] Corrigan - The Chaordic Stepping Stones.pdf
> [27] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [28] Corrigan - The Chaordic Stepping Stones.pdf
> [29] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [30] Corrigan - The Chaordic Stepping Stones.pdf
> [31] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [32] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [33] Corrigan - The Chaordic Stepping Stones.pdf
> [34] Chaordic Stepping Stones w.Template Harvest 2025.pdf
> [35] [Book] Hock - One from Many VISA and the Rise of Chaordic Organization.pdf
> [36] the_art_of_chaordic_leadership_hock.pdf
> [37] the_art_of_chaordic_leadership_hock.pdf
> [38] the_art_of_chaordic_leadership_hock.pdf
> [39] the_art_of_chaordic_leadership_hock.pdf
> [40] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [41] Vaneijnatten 2004 chaordic systems thinking - learning organization.pdf
> [42] Dee Hock - The Chaordic Organization Review.pdf
> [43] Dee Hock - The Chaordic Organization Review.pdf
> [44] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [45] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [46] Dee Hock - The Chaordic Organization Review.pdf


FILE: 'Derek Cabrera.md'
---
exported: 2026-02-04T22:51:05.233Z
source: NotebookLM
type: chat
title: Derek Cabrera on 💬What is Complexity
tags:
  - Derek-Cabrera
  - What-is-complexity
author: Derek Cabrera
---

In the framework provided by the sources, **complexity** is not merely a synonym for "complicated"; it is a specific phenomenon defined by its origin, behaviour, and underlying structure.

### What is Complexity?

Complexity is an **emergent property** that arises from a **Complex Adaptive System (CAS)**\[1\]\[2\]. It is born of **autonomous agents following simple, local interaction rules**, the collective dynamics of which lead to macro-level outcomes—such as intelligence, self-organisation, or resilience—that are absent if the parts act in isolation\[3\].

The sources differentiate complexity from other system types:

• **Complex vs Complicated:** A system is **complicated** if its stimulus and response are consistent and predictable (like a rock or a machine); it is **complex and adaptive** if it can modify its rules to survive and anticipate threats (like a dog or an ant colony)\[6\].

• **Unpredictability:** In complex systems, **cause and effect are often visible only retrospectively**; outcomes cannot be known or predicted ahead of time\[9\]\[10\].

• **VUCA Context:** Complexity is a core component of the **VUCA** world (**Volatility, Uncertainty, Complexity, and Ambiguity**), which generates "wicked problems" that resist definitive solutions\[11\].

• **Causality:** Complexity involves **nonlinear webs of causality** rather than single, linear cause-and-effect chains\[14\]\[15\].

### Advice on How to Deal with Complexity

The authors suggest that because complexity is an outcome of simple rules, the most effective way to manage it is to **focus on the rules rather than the complex outcome itself**\[16\].

**1\. Master the DSRP Rule Set**Systems thinking is itself a Complex Adaptive System\[1\]\[19\]. To navigate complexity effectively, one must focus on the **four simple cognitive rules** that underlie all thought: making **D**istinctions, and recognising **S**ystems, **R**elationships, and **P**erspectives (**DSRP**)\[20\]\[21\]. By consciously executing these rules (metacognition), you can deconstruct and deeply understand any situation\[22\]\[23\].

**2\. Use the ST/DSRP Loop to Align with Reality**The primary advice for dealing with complexity is to increase **parallelism**—the probability that your **mental models** align with the **material complexity of the real world**\[24\]\[25\]. This is achieved through the **ST/DSRP Loop**:

• **Build** a mental model.

• **Test** it against real-world observables.

• Incorporate **informational feedback**.

• **Evolve** the model and repeat\[26\].

**3\. Move from "One-Cause" to "Webs of Causality"**Complexity should not be met with simplistic, "ready-made" solutions\[29\]\[30\]. Instead of searching for a single "root cause," map out the **Web of Causality (WoC)** to see how interdependent factors interact\[15\]\[31\]. For effective intervention, "flip" this into a **Web of Anti-Causes (WoAC)**, activating multiple solutions **simultaneously** rather than sequentially\[32\]\[33\].

**4\. Employ "Cognitive Jigs" for Agility**In a VUCA world, rigid, over-engineered frameworks can be debilitating\[34\]. The sources advise using **cognitive jigs**—bite-sized, modular molecular structures like the **Perspective Circle** or **RDS Barbell**—which are more agile, adaptive, and easier to deploy than traditional heavy-weight methodologies\[35\].

**5\. Practice Critical Systems Thinking**The inclusion of **perspectives** is the pivotal factor in reducing systems thinking bias\[38\]. Research shows that when even a single element of perspective is formulated, the complexity and richness of other DSRP patterns (Systems and Relationships) significantly increase\[38\]\[39\].

**6\. Adopt "System 3" Thinking**Standard "System 1" (fast/wrong) and "System 2" (slow/right) thinking are often sub-optimal for high-stakes complexity\[37\]. The authors advocate for **"System 3" thinking**, which combines speed and accuracy through the **rehearsal and practice** of DSRP moves, allowing these systemic habits to become hardwired\[37\]\[40\].

---
> [!info]- References
> [1] Balan - how to improve systems thinking in aid.pdf
> [2] Cabrera - Systems Thinking Flash Cards.pdf
> [3] 2020 A Literature Review of the Universal and Atomic Elements of Complex Cognition.pdf
> [6] Cabrera - Hard and Soft Methods in Complex Adaptive Systems.pdf
> [9] Balan - how to improve systems thinking in aid.pdf
> [10] Balan - how to improve systems thinking in aid.pdf
> [11] Cabrera - Systems Thinking Flash Cards.pdf
> [14] Cabrera Cabrera 2019 Reference Work Entry - What Is Systems Thinking.pdf
> [15] Cabrera - From One Cause to Webs of Causality.pdf
> [16] Balan - how to improve systems thinking in aid.pdf
> [19] Cabrera - Systems Thinking Flash Cards.pdf
> [20] Balan - how to improve systems thinking in aid.pdf
> [21] Cabrera - The Universal Cognitive Grammar of Systems Mapping - A Rubric to Evaluate the Various Tools and Techniques of Systems Mapping.pdf
> [22] 2020 A Literature Review of the Universal and Atomic Elements of Complex Cognition.pdf
> [23] Cabrera - Systems Thinking Flash Cards.pdf
> [24] Cabrera - DSRP Theory - A Primer.pdf
> [25] Cabrera - A Mathematical Theory of organizational DSRP as The Universal Reality Code.pdf
> [26] Cabrera - DSRP Theory - A Primer.pdf
> [29] Balan - how to improve systems thinking in aid.pdf
> [30] Balan - how to improve systems thinking in aid.pdf
> [31] Cabrera - From One Cause to Webs of Causality.pdf
> [32] Cabrera - From One Cause to Webs of Causality.pdf
> [33] Cabrera - From One Cause to Webs of Causality.pdf
> [34] Cabrera - Developing Personal Mastery in Systems Thinking.pdf
> [35] Cabrera - Developing Personal Mastery in Systems Thinking.pdf
> [37] Cabrera - A Mathematical Theory of organizational DSRP as The Universal Reality Code.pdf
> [38] Common Biases in Systems Thinking.pdf
> [39] Common Biases in Systems Thinking.pdf
> [40] Cabrera - Developing Personal Mastery in Systems Thinking.pdf


FILE: 'Donella Meadows.md'
---
exported: '2026-01-31T13:03:36.443Z'
source: NotebookLM
type: chat
title: Donella Meadows on 💬What is Complexity
tags:
  - Donella-Meadows
  - What-is-complexity
author: Donella Meadows
---

### The Nature of Complexity

**Complexity** describes systems that are **self-organizing, nonlinear, and governed by feedback loops**, making them **inherently unpredictable and uncontrollable**\[1\]\[2\]. These systems are **counterintuitive**; our natural instincts often lead us to push leverage points in the wrong direction, systematically worsening the problems we intend to solve\[3\]. In a complex system, the **structure**—the web of circular, interlocking, and often time-delayed relationships—is just as important in determining behavior as the individual components\[6\]. Complexity arises when simple stocks and flows are interconnected into massive, fluctuating networks, such as global trade or banking systems\[7\]. Furthermore, the universe of complex systems is naturally **messy, dynamic, and diverse**, spending its time in transient behavior rather than mathematically neat equilibria\[2\].

### Advice on Dealing with Complexity

Because complex systems cannot be fully understood or optimized, we must move away from the mindset of the **"omniscient conqueror"** and instead learn to **"dance" with them**\[1\]. The following advice is offered for navigating this complexity:

• **Get the beat:** Before disturbing a system, **watch how it behaves** and learn its history to focus on facts rather than your own theories or misconceptions\[10\]\[11\].

• **Stay humble and a learner:** Trust your intuition, use **trial and error**, and practice **"error-embracing"** by admitting mistakes and using small steps to monitor the results of your actions\[12\].

• **Expose your mental models:** Get your assumptions "out there where they can be shot at" and invite others to challenge them; this increases **mental flexibility** and helps you see evidence that might rule out a false assumption\[15\]\[16\].

• **Honor and protect information:** Most system malfunctions are caused by **faulty or missing information**; delivering timely, accurate information to the right places can make a system work better with surprising ease\[17\]\[18\].

• **Intervene at the right leverage points:** Do not spend all your effort "diddling" with numbers and parameters; instead, target high-leverage areas like **system goals** and the **paradigm/mindset** out of which the system arises\[19\].

• **Practice systemic responsiveness:** Shift from enforcing mandates to **enabling the conditions for responsive flow**, focusing on relational patterns, sense-making, and emotional rhythms\[22\].

• **Expand your horizons:** Think beyond the next election or investment payback period by **expanding time horizons** to consider future generations and **expanding the boundary of caring** to the entire interconnected global ecosystem\[25\].

• **Celebrate complexity:** Recognize that the messiness and diversity of the world are what make it **beautiful, interesting, and functional**\[2\]\[28\].

• **Transcend paradigms:** Realize that no single worldview is "true" and that staying unattached to any one paradigm provides a basis for **radical empowerment** and the ability to choose the worldview that best achieves your purpose\[29\]\[30\].

---
> [!info]- References
> [1] Meadows.pdf
> [2] Meadows.pdf
> [3] D Meadows Places To Intervene 1997.pdf
> [6] [Book] Meadows - The Limits to Growth.pdf
> [7] Leverage_Points.pdf
> [10] Meadows.pdf
> [11] Meadows.pdf
> [12] Meadows.pdf
> [15] Meadows.pdf
> [16] Meadows.pdf
> [17] Meadows.pdf
> [18] Meadows.pdf
> [19] D Meadows Places To Intervene 1997.pdf
> [22] Seeing Differently Insights from Donella Meadows.pdf
> [25] Meadows.pdf
> [28] Meadows.pdf
> [29] Leverage_Points.pdf
> [30] Leverage_Points.pdf


FILE: 'Fred Emery.md'
---
exported: 2026-02-07T20:35:37.687Z
source: NotebookLM
type: chat
title: Fred Emery on 💬What is Complexity
tags:
  - What-is-complexity
  - Fred-Emery
author: Fred Emery
---
Based on the provided sources, **complexity** is defined not just by the number of parts in a system, but by the "causal texture" of the environment in which the system operates—specifically the nature of the interdependencies between the system and the environment\[1\],\[2\].

The sources present a specific framework for understanding this complexity and provide rigorous advice on how to navigate it through **Active Adaptation**, **Ideal Seeking**, and specific **Organizational Design Principles**.

### 1\. What is Complexity? (The Causal Texture of Environments)

In this framework, complexity is understood through the evolution of environmental levels. Complexity increases as the environment becomes more "richly joined," meaning the parts of the environment are increasingly interconnected and dynamic\[3\].

The sources identify four distinct levels of environmental complexity, with the fourth being the current state of Western society:

• **Type I (Placid, Randomized):** Goals and dangers are randomly distributed. Complexity is low; there is no distinction between strategy and tactics\[4\],\[5\].

• **Type II (Placid, Clustered):** Elements cluster together. Strategy becomes possible and distinct from tactics\[6\],\[7\].

• **Type III (Disturbed-Reactive):** Competition dominates. Complexity arises from the presence of similar systems competing for the same resources. Systems must consider the actions of others (operations)\[8\],\[9\].

• **Type IV (Turbulent Fields):** This is the current dominant definition of complexity in Open Systems Theory (OST). Complexity here is defined by **"dynamic processes... which create significant variances... \[arising\] from the field itself"**\[10\]. The "ground" is in motion; changes are autochthonous (self-generating) and unpredictable\[11\].

**Key Characteristics of Type IV Complexity:**

• **Relevant Uncertainty:** The defining feature of turbulent environments is a gross increase in "relevant uncertainty." The consequences of actions become unpredictable because they are amplified or attenuated by the dynamic field\[12\],\[13\].

• **Interdependence:** There is a deepening interdependence between economic, political, and social sectors. Actions in one area trigger unexpected consequences in another\[11\].

• **Information Overload:** The revolution in communications has created a flood of information that can lead to maladaptive responses like superficiality and dissociation\[14\],\[15\].

If complexity is not managed, the environment may devolve into a **Type V (Vortical) Environment**, characterized by "frozen" or clinched connectedness, where adaptation becomes impossible and systems are sucked into whirlpools of destruction\[16\],\[17\].

### 2\. Advice on Dealing with Complexity

The sources explicitly reject "closed system" mechanical approaches (like bureaucracy or standard strategic planning) as incapable of dealing with Type IV complexity\[18\],\[19\]. Instead, the advice centers on **Active Adaptation** through specific structural and planning shifts.

A. Shift from "Redundancy of Parts" to "Redundancy of Functions"

The most critical practical advice is a structural shift in how organizations and social systems are designed.

• **The Problem (Design Principle 1):** Bureaucracies are built on "redundancy of parts" (replaceable people with simplified tasks). This structure is **error-amplifying**. In complex environments, errors "leak in like water from a sieve," and the system cannot cope with the variety of the environment\[20\].

• **The Solution (Design Principle 2):** To deal with complexity, systems must be built on "redundancy of functions" (multiskilled parts/people). This means building more skills into the individual than they need at any one moment\[21\],\[22\].

    ◦ **Error Attenuation:** This design is **error-attenuating**. Self-managing groups can catch and correct errors locally before they destabilize the whole system\[23\].    ◦ **Variety:** This design increases the system's "requisite variety," allowing it to match the complexity of the environment\[24\],\[18\].

B. Strategy: From "Objectives" to "Ideals"

In turbulent environments, aiming for specific, rigid objectives is maladaptive because the ground is moving; the objective may no longer be relevant by the time it is reached\[25\],\[26\].

• **Ideal Seeking:** The advice is to shift from pursuing specific goals to pursuing **Ideals**. Ideals (such as Homonomy, Nurturance, Humanity, and Beauty) act as guides to behavior in uncertain situations\[27\],\[28\],\[29\].

• **Simplification:** Ideals simplify the complex environment. They provide a "ready calculus" for decision-making when the causal strands of the environment are too complex to trace\[28\].

C. Planning: Active Adaptive Planning

Traditional "optimizing" planning fails in complexity because it assumes a stable world\[30\],\[31\]. The sources recommend **Active Adaptive Planning**:

• **Puzzle Learning:** Treat planning as puzzle-solving (learning the unique shape of the pieces) rather than problem-solving (applying known formulas)\[32\].

• **The Search Conference:** This is the primary methodological advice. It is a participatory planning process that scans the _entire_ extended social field (L22) to establish a "directive correlation" (shared path) between the system and the environment\[33\],\[34\]. It creates a "learning planning community" capable of constant adaptation\[34\].

D. Institutional Form: Matrix Organizations

For inter-organizational relationships, the advice is to move away from monopolies or competitive cartels toward **Matrix Organizations** (or "organizational ecology").

• These are relationships between _dissimilar_ organizations whose fates are positively correlated (e.g., a hospital, a school, and a local industry all relying on the same regional resources)\[35\],\[36\].

• These networks stabilize the environment by instituting shared values and regulating the "ground" on which they all operate\[37\].

### Summary of Advice

To deal with complexity, you must **democratize the workplace** (Design Principle 2) to increase the system's capacity to handle variety\[38\], abandon rigid objectives in favor of **shared ideals** to navigate uncertainty\[26\], and utilize **participative planning methods** (Search Conferences) that explicitly map the external environment to align the system with the changing social field\[33\].

---
> [!info]- References
> [1] Emery - The Causal Texture of Organizational Environments.pdf
> [2] Emery - The Causal Texture of Organizational Environments.pdf
> [3] Emery - The Causal Texture of Organizational Environments.pdf
> [4] Emery - The Causal Texture of Organizational Environments.pdf
> [5] Emery - The Causal Texture of Organizational Environments.pdf
> [6] Emery - The Causal Texture of Organizational Environments.pdf
> [7] Emery - The Causal Texture of Organizational Environments.pdf
> [8] Emery - The Causal Texture of Organizational Environments.pdf
> [9] Emery - The Causal Texture of Organizational Environments.pdf
> [10] Emery - The Causal Texture of Organizational Environments.pdf
> [11] Emery - The Causal Texture of Organizational Environments.pdf
> [12] Emery - The Causal Texture of Organizational Environments.pdf
> [13] [Book] Emery - Towards a Social Ecology Contextual Appreciation of the Future in the Present.pdf
> [14] [Book] Emery - Towards a Social Ecology Contextual Appreciation of the Future in the Present.pdf
> [15] [Book] Emery - A choice of futures.pdf
> [16] Baburoglu - The Vortical Environment  The fifth in the Emery-Trist Level of Organisational Environments.pdf
> [17] Baburoglu - The Vortical Environment  The fifth in the Emery-Trist Level of Organisational Environments.pdf
> [18] Fred Emery - The Second Design Principle Participation and the Democratization of Work.pdf
> [19] [Book] Emery - Towards a Social Ecology Contextual Appreciation of the Future in the Present.pdf
> [20] Fred Emery - The Second Design Principle Participation and the Democratization of Work.pdf
> [21] Fred Emery - The Second Design Principle Participation and the Democratization of Work.pdf
> [22] [Book] Emery - Towards a Social Ecology Contextual Appreciation of the Future in the Present.pdf
> [23] Fred Emery - The Second Design Principle Participation and the Democratization of Work.pdf
> [24] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [25] Emery - The Causal Texture of Organizational Environments.pdf
> [26] [Book] Emery - A choice of futures.pdf
> [27] Emery - The Causal Texture of Organizational Environments.pdf
> [28] Emery - The Causal Texture of Organizational Environments.pdf
> [29] [Book] Emery - Towards a Social Ecology Contextual Appreciation of the Future in the Present.pdf
> [30] Fred Emery - The Second Design Principle Participation and the Democratization of Work.pdf
> [31] Fred Emery - The Second Design Principle Participation and the Democratization of Work.pdf
> [32] Fred Emery - The Second Design Principle Participation and the Democratization of Work.pdf
> [33] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [34] The Search Conference - Rehm on Emery.pdf
> [35] Emery - The Causal Texture of Organizational Environments.pdf
> [36] [Book] Emery - Towards a Social Ecology Contextual Appreciation of the Future in the Present.pdf
> [37] [Book] Emery - Towards a Social Ecology Contextual Appreciation of the Future in the Present.pdf
> [38] [Book] Emery - A choice of futures.pdf


FILE: 'Geoffrey Vickers.md'
---
exported: '2026-01-26T21:28:24.100Z'
source: NotebookLM
type: chat
title: Geoffrey Vickers on 💬What is Complexity
tags:
  - Geoffrey-Vickers
  - What-is-complexity
aliases:
  - "In the context of human affairs, complexity is def..."
linter-yaml-title-alias: "In the context of human affairs, complexity is def..."
author: Geoffrey Vickers
---

# In the context of human affairs, complexity is def...

导出时间: 26/01/2026, 21:28:24

---

In the context of human affairs, **complexity is defined as a network of multiple interacting relationships** that exist through time\[1\]\[2\]. It is characterised by **emergent behaviour**, meaning the behaviour of a complex system as a whole cannot be simply inferred from its individual components\[3\]\[4\]. Furthermore, human complexity often manifests as **"messes,"** which are systems of strongly interacting and interrelated problems rather than isolated issues\[5\]. In these systems, **every part affects the whole** in a recursive manner, and human initiative often adds to this instability by magnifying the powers of technology without a corresponding increase in our understanding of its effects\[9\].

The sources offer the following advice on how to deal with complexity:

### 1\. Shift from Goal-Seeking to Relationship-Maintenance

While technical fields often focus on "goal-seeking," dealing with complex human systems requires a shift to **relationship-maintenance**\[12\]. Rather than seeking an endless succession of goals, regulation should focus on **maintaining satisfactory relationships** and eluding unsatisfactory ones over time\[12\]. Effective governance consists of regulating a system so that these conflicting relations are optimised without destroying the system itself\[17\].

### 2\. Employ Appreciative Systems

Dealing with complexity requires an **"appreciative system,"** which is a mental act that combines judgements of fact and value to determine what we notice and how we regard situations\[20\]. This involves three interrelated types of judgement:

• **Reality Judgments:** Determining "what is the case" by selecting relevant facts from the general confusion of events\[20\].

• **Value Judgments:** Evaluating the situation against standards of "what ought to be," defining whether things are acceptable or unacceptable\[20\].

• **Instrumental Judgments:** Choosing the best means available to reduce the mismatch between "is" and "ought"\[20\].

### 3\. Avoid Treating "Messes" as "Puzzles"

A major mistake in complex environments is **carving off a part of a "mess" and attempting to solve it as a simple "puzzle"** while ignoring its links to other problems\[29\]\[30\]. Solving puzzles may feel productive, but if the underlying complexity is ignored, interventions often have the effect of **"tightening the mess"** and causing unforeseen catastrophic outcomes\[31\]\[32\]. Instead, one should aim to **"dissolve" the problem** by redesigning the system to achieve ideal outcomes\[33\]\[34\].

### 4\. Adopt "Satisficing" Over Optimisation

In highly complex situations, the human brain cannot review every possible solution\[35\]\[36\]. Therefore, the criterion for decision-making should be **"satisficing"**—finding a solution that is **"good enough"** and acceptable within given constraints, rather than attempting a purely rational but impossible search for the "best" solution\[37\].

### 5\. Leverage Group Dialogue and Multi-Perspective Learning

Complexity is best navigated through **group dialogue and shared sense-making**, which makes a larger pool of meaning accessible and can increase the "IQ" of the group as a whole\[41\]. Advice for practitioners includes:

• Using the **Triple ‘E’ model**: Explore the situation, Experiment with strategies, and reflect on the Experience\[42\].

• Seeking **accommodations between conflicting interests** on which action can be based, rather than forced consensus\[46\].

• Developing **interdisciplinary learning** to broaden the "readiness of the mind" to see contextual significance rather than just linear cause-and-effect\[49\].

### 6\. Accept Uncertainty and Limits

Skill in **understanding and accepting uncertainty** is a basic requirement for human life\[52\]. Dealing with complexity requires acknowledging that **human systems both enable and constrain**, and the price of increasing human capabilities is the acceptance of increased human regulation and restraint\[53\]. Managers should move away from the "delusion of control" and focus instead on **"learning what to want,"** which allows the appreciative system to be constantly updated based on experience\[56\].


FILE: 'George Lakoff.md'
---
tags:
  - George-Lakoff
  - What-is-complexity
title: George Lakoff on 💬What is Complexity
author: George Lakoff
---
In the context of cognitive science and linguistics, **complexity** is often characterized by **systemic causation**, where outcomes result from the **interplay of whole systems** rather than just individual, direct actions 1\. Human conceptual systems are inherently complex because they rely on **multiple, often inconsistent metaphors** to comprehend different aspects of a single concept, as no single metaphor can capture every detail of a reality 2, 3\. Furthermore, complexity in social and political life is often obscured by **"hypocognition"**—a lack of the simple, fixed conceptual frames necessary to name or reason about multifaceted shifts in society 4, 5\.  
To deal with complexity, the sources provide the following advice:

* **Shift between metaphors:** Recognise that successful functioning in daily life requires a **constant shifting of metaphors** 2\. Because any single model or metaphor necessarily highlights some aspects of reality while hiding others, you must be willing to use **alternative conceptualisations** to gain a more comprehensive understanding 3, 6\.  
* **Move from "reflexive" to "reflective" thought:** Most thought is **unconscious and automatic** (reflexive), which can lead to making decisions without awareness of the underlying frames being used 7, 8\. To manage complex situations, you must **make the unconscious conscious** by reflecting on the frames and metaphors that structure your reasoning 9-11.  
* **Address systemic rather than direct causation:** Dealing with complex social issues like crime or global warming requires understanding **systemic causation**—the result of the structure of natural or cultural systems 1, 12\. Avoid the **"bad apple" frame**, which oversimplifies complexity by blaming individual actors instead of addressing **systemic, ideological, or institutional failures** 13, 14\.  
* **Adopt "Strategic Initiatives":** Instead of thinking issue-by-issue, use **strategic initiatives**—carefully chosen plans where a single change can have **automatic effects across many different areas** 15, 16\. This allows for a more effective impact on a complex system through a single, well-placed intervention 17\.  
* **Avoid "Stylized Facts":** Be wary of mathematical or rational actor models that "boil down" problems into **"stylized facts"**, as these often **oversimplify reality** by ignoring past history, future consequences, and externalised costs like environmental damage 18-20.  
* **Develop "Experiential Flexibility":** Cultivate the ability to view your life and challenges through **new, alternative metaphors** 6\. This flexibility allows you to adapt to a reality that is **not monolithic** and is constantly being reshaped by human action and conceptualisation 6, 21\.



FILE: 'Gregory Bateson.md'
---
exported: '2026-01-27T19:29:16.114Z'
source: NotebookLM
type: chat
title: Gregory Bateson on 💬What is Complexity
tags:
  - Gregory-Bateson
  - What-is-complexity
author: Gregory Bateson
---
Based on the provided sources, complexity is not merely a measure of complicated parts, but a fundamental characteristic of living systems, mental processes, and ecological organization. Dealing with complexity requires a radical shift in epistemology—how we know what we know—moving away from linear control toward systemic wisdom.

### What is Complexity?

**1\. Mind and Nature as Synonymous**Gregory Bateson redefined complexity by equating it with "mind" or mental process. He posited that the organizational complexity found in nature (ecology, evolution, embryology) is formally analogous to the organization of a mind\[1\],\[2\]. Complexity is found wherever a system meets specific criteria, including being an aggregate of interacting parts triggered by difference, requiring collateral energy, and operating through circular chains of determination (feedback loops)\[3\],\[4\],\[5\].

**2\. Creatura vs. Pleroma**Bateson distinguished between two worlds:

• **Pleroma:** The world of non-living matter, governed by forces, impacts, and energy exchanges.

• **Creatura:** The world of the living and mental, governed by difference, distinction, and information\[6\],\[7\].In the world of complexity (Creatura), effects are brought about not by force, but by "difference"—specifically, "a difference which makes a difference," which is Bateson's definition of information\[8\],\[9\].

**3\. Circularity and Recursiveness**Complex systems are characterized by non-linear, circular causal chains. Unlike linear systems where A causes B, complex systems involve feedback loops where A affects B, which affects C, which eventually feeds back to influence A\[10\],\[11\]. This recursiveness means that the system is self-correcting and that no part has unilateral control over the whole\[12\],\[13\].

**4\. Hierarchy and Heterarchy**Complexity is organized through levels of logical types. This includes a hierarchy of contexts where the context classifies the signal (e.g., a message and the meta-message classifying it)\[14\],\[15\]. However, in living systems, this often manifests as "heterarchy," where different levels of organization (genetic, epigenetic, environmental) coordinate in a non-transitive, network-like manner rather than a rigid top-down command structure\[16\],\[17\],\[18\].

### Advice on How to Deal with Complexity

Bateson and his interpreters argue that traditional linear thinking and the desire for control are dangerous when applied to complex systems. The advice for dealing with complexity includes:

**1\. Abandon the Myth of Control**The belief that humanity can have total control over an interactive system of which it is merely a part is a major source of pathology and ecological disaster\[19\],\[20\]. Attempting to control specific variables (like using pesticides to control insects) without understanding the larger feedback loops leads to "bag of tricks" solutions that often generate new, worse problems\[21\],\[19\]. We must recognize that we are not outside the ecology we plan for; we are part of it\[22\].

**2\. Adopt "Systemic Wisdom"**Wisdom is defined as the recognition of the larger interactive system. To deal with complexity, one must understand that disturbing a system is likely to generate exponential curves of change (runaway)\[19\]. This requires a shift from "conscious purpose"—which cuts through loops to maximize a single variable (like profit or speed)—to an appreciation of the total circuit\[23\],\[24\].

**3\. Maintain a "Budget of Flexibility"**A healthy complex system must maintain flexibility, defined as "uncommitted potentiality for change"\[25\],\[26\].

• **Avoid Maximization:** Pushing variables to their upper or lower limits (e.g., maximum population or energy use) eats up flexibility and makes the system brittle and prone to collapse\[27\],\[28\].

• **Optimal Ranges:** Variables should be kept in the middle of their tolerable limits to allow the system to adapt to future, unpredictable stresses\[29\].

**4\. Use "Double Description" (Binocular Vision)**Just as two eyes provide depth perception, combining multiple sources of information or perspectives provides a "bonus of understanding" that neither source possesses alone\[30\],\[31\].

• **Abduction:** Use abductive reasoning (looking for patterns and similarities across different fields) rather than just induction or deduction. This allows one to see the "pattern which connects" different realms, such as the anatomy of a crab and the structure of a society\[32\],\[33\].

• **Contextualization:** Never look at data in isolation. Information is always contextual, and without context, there is no communication\[14\].

**5\. Engage with Aesthetics and the Sacred**Because analytic logic and quantitative science are often inappropriate for describing the holistic nature of living systems, Bateson suggests turning to aesthetics and the "sacred"\[34\],\[35\].

• **Aesthetics:** Aesthetic perception allows for the recognition of the "pattern which connects" and the unity of the biosphere\[36\],\[37\]. It integrates the "reasons of the heart" with the "reasons of the reason"\[38\].

• **The Sacred:** This is not necessarily religious in a theistic sense but refers to the integrated fabric of mental processes. Recognizing the sacred means respecting the systemic unity that cannot be mocked or cheated\[39\],\[40\].

**6\. Humility and Participation**We must move from a stance of "objective" observation to "participative" relating\[41\]. We should recognize the limits of our conscious understanding and view ourselves not as isolated entities but as bundles of relationships\[42\],\[43\]. As Bateson advised, we must learn to think in a way where we do not see ourselves as concrete objects separate from the processes of the world\[44\].
---

## 引用来源

[1] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[2] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[3] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[4] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[5] Smith - Bateson - Consciousness Mind and Nature.pdf
[6] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[7] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[8] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[9] Bateson Information Revisited a new paradigm.pdf
[10] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[11] Bateson 1991 - Cybernetic Explanation.pdf
[12] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[13] Gregory Batesons Theory of Mind - Learning I-II-III.pdf
[14] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[15] Gregory Batesons Theory of Mind - Learning I-II-III.pdf
[16] Bioentropy aesthetics and meta-dualism the transdisciplinary ecology of Gregory Bateson.pdf
[17] Diminishing Dualism - Gregory Bateson and the case for Heterarchy.pdf
[18] Diminishing Dualism - Gregory Bateson and the case for Heterarchy.pdf
[19] Bateson_Gregory_Steps_to_an_Ecology_of_Mind.pdf
[20] Tognetti - Gregory Bateson and the origins of post-normal science.pdf
[21] Bateson_Gregory_Steps_to_an_Ecology_of_Mind.pdf
[22] Smith - Bateson - Consciousness Mind and Nature.pdf
[23] 676411.pdf
[24] [Book] Gregory Bateson - Steps to an Ecology of Mind.pdf
[25] Bateson_Gregory_Steps_to_an_Ecology_of_Mind.pdf
[26] [Book] Gregory Bateson - Steps to an Ecology of Mind.pdf
[27] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[28] Bateson_Gregory_Steps_to_an_Ecology_of_Mind.pdf
[29] Bateson_Gregory_Steps_to_an_Ecology_of_Mind.pdf
[30] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[31] [Book] Bateson Gregory - Mind and Nature.pdf
[32] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[33] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[34] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[35] A Legacy for Living Systems - Gregory Bateson as Precursor to Biosemiotics.pdf
[36] A Legacy for Living Systems - Gregory Bateson as Precursor to Biosemiotics.pdf
[37] A Legacy for Living Systems - Gregory Bateson as Precursor to Biosemiotics.pdf
[38] [Book] Bateson - Steps to an Ecology of Mind_ Collected Essays in Anthropology, Psychiatry, Evolution, and Epistemology.pdf
[39] Palmer - Think differently to avoid extinction.pdf
[40] [Book] Hoffmeyer - A Legacy for Living Systems Batesons Method Double Description.pdf
[41] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
[42] 1575000.pdf
[43] Hawkins A centennial tribute to Gregory Bateson.pdf
[44] [Book] Bateson - Steps to an Ecology of Mind_ Collected Essays in Anthropology, Psychiatry, Evolution, and Epistemology.pdf


FILE: 'Harish Jose.md'
---
exported: 2026-02-09T21:00:34.356Z
source: NotebookLM
type: chat
title: Complexity is defined as the domain where the rela...
tags:
  - Harish-Jose
  - What-is-complexity
---
**Complexity** is defined as the domain where the relationship between cause and effect is non-linear and can only be perceived in **retrospect**, never in advance\[1\]\[2\]. Unlike the "complicated" domain, which can be resolved by experts, complexity is fundamentally **observer-dependent**—it is a mental construct shaped by the distinctions an observer makes and the specific purpose they have for observing\[3\].

In a cybernetic sense, complexity is measured by **"variety,"** which refers to the number of possible states a system can occupy\[6\]\[7\].

### **Advice on How to Deal with Complexity**

Navigating complexity requires moving away from rigid, top-down control toward a more adaptive, experimental approach\[1\]\[8\].

• **Confirm the Domain:** Before acting, use a framework like Cynefin to determine if you are actually in a complex situation where order is absent\[9\]\[10\].

• **Probe-Sense-Respond:** Because the outcome is unpredictable, you must initiate **"safe-to-fail" experiments** (probes)\[1\]\[11\]. These are small, reversible actions designed to let patterns emerge so you can then sense and respond to them\[2\]\[12\].

• **Practice Variety Engineering:** Apply **Ashby’s Law of Requisite Variety**, which states that "only variety can absorb variety"\[6\]\[13\]. You must either **attenuate** (filter out) the overwhelming noise of the environment or **amplify** your internal variety—such as diverse skills and flexible responses—to match the complexity you face\[14\]\[15\].

• **Create Conditions, Don't Force Outcomes:** complexity is **dispositional**; you cannot force a specific result\[8\]\[16\]. Instead, leaders should take responsibility for creating the conditions where favorable patterns (attractor states) are likely to emerge while monitoring for undesirable ones\[17\]\[18\].

• **Specify "Only Somewhat":** Follow the "art of somewhat" by not specifying a system in full detail\[19\]\[20\]. This allows you to "ride the dynamics" of the system in the direction you want to go rather than being crushed by its weight\[21\]\[22\].

• **Cultivate Epistemic Humility:** Maintain an open mind and realize that your version of reality is inevitably incomplete\[23\]\[24\]. Welcome multiple perspectives, a principle called **Anekantvada**, to reveal cognitive blind spots that a single observer cannot see\[23\]\[25\].

• **Seek Simplicity, but Distrust It:** Use simple models as a starting point to coordinate action, but do not mistake the simplified "map" for the actual "territory" of the complex situation\[26\].

Does this shift from "fixing" a system to "creating conditions" for it to thrive match the challenges you see in your current environment?

---
> [!info]- References
> [1] Harish Jose.md
> [2] Harish Jose.md
> [3] Harish Jose.md
> [6] Harish Jose.md
> [7] Harish Jose.md
> [8] Harish Jose.md
> [9] Harish Jose.md
> [10] Harish Jose.md
> [11] Harish Jose.md
> [12] Harish Jose.md
> [13] Harish Jose.md
> [14] Harish Jose.md
> [15] Harish Jose.md
> [16] Harish Jose.md
> [17] Harish Jose.md
> [18] Harish Jose.md
> [19] Harish Jose.md
> [20] Harish Jose.md
> [21] Harish Jose.md
> [22] Harish Jose.md
> [23] Harish Jose.md
> [24] Harish Jose.md
> [25] Harish Jose.md
> [26] Harish Jose.md


FILE: 'Harold Nelson.md'
---
exported: 2026-02-07T20:36:11.232Z
source: NotebookLM
type: chat
title: Harold Nelson on 💬What is Complexity
tags:
  - What-is-complexity
  - Harold-Nelson
author: Harold Nelson
---
Based on the provided sources, particularly the works of Nelson, Stolterman, Rittel, and various systemic design scholars, complexity is defined not merely as a state of having many parts, but as a dynamic condition of interconnectedness, uncertainty, and "wickedness" that defies traditional linear problem-solving.

### What is Complexity?

**1\. Wicked Problems vs. Tame Problems**The sources distinguish between "tame problems" (which have clear definitions and solutions) and "wicked problems" (or "messes"). Complexity in the real world usually manifests as wicked problems, which are characterized by the following:

• **Indeterminacy:** They have no definitive formulation and no "stopping rule" (you don't know when you are done)\[1\],\[2\],\[3\].

• **No True/False:** There are no "right" or "wrong" solutions, only "better" or "worse" ones\[1\],\[4\].

• **Uniqueness:** Every wicked problem is essentially unique, meaning solutions cannot simply be copied from elsewhere\[1\],\[5\],\[6\].

• **Irreversibility:** Every solution is a "one-shot operation"; you cannot undo the consequences of an intervention\[7\],\[8\],\[9\].

**2\. Interconnectedness and Entanglement**Complexity arises because everything in the real world is connected to everything else. Nothing exists in isolation; every artifact or event is part of a system or a "causal entanglement"\[10\],\[11\],\[12\]. Because of this, it is difficult to identify clear cause-and-effect relationships\[13\].

**3\. Observer Dependence**Complexity is not just a property of the world; it is defined by the observer. It is described as "a state of mind, triggered into emergence by unsuccessful efforts to comprehend a system"\[13\]. A system is not given in nature but is "defined by intelligence"\[14\].

**4\. Figural Complexity**From the perspective of the design process, complexity is "figural." This means that design proposals are dynamic wholes; if you change one element (a part), you change the whole composition. Therefore, you cannot solve the problem in isolated pieces\[15\],\[16\].

\--------------------------------------------------------------------------------

### Advice on How to Deal with Complexity

The sources argue that scientific or "rational" decision-making models (which seek comprehensive data to predict outcomes) lead to "analysis paralysis" when applied to complexity\[17\],\[18\]. Instead, one must adopt a **Systemic Design** approach.

**1\. Shift from Problem-Solving to "Designing"**Do not treat complex issues as problems to be "solved" (which implies a return to a normal state). Instead, treat them as situations to be _designed_.

• **Intentional Change:** Move toward what is desired (_desiderata_) rather than just away from what is painful. Problem-solving is reactive; design is proactive\[19\],\[20\].

• **Inquiry for Action:** Accept that you cannot know everything before acting. Design is "inquiry for action," meaning you must act to understand\[21\],\[22\].

**2\. Use Design Judgment**Because you cannot have perfect information in a complex situation, you cannot rely solely on logic or calculation. You must rely on **Judgment**:

• **Navigational Judgment:** The ability to make choices in the moment within a dynamic environment, similar to sailing a ship in a storm\[23\],\[24\].

• **Framing Judgment:** You must set boundaries. Decide what is "foreground" (to be designed) and what is "background" (context). This is a choice, not a fact\[23\],\[25\],\[26\].

• **Appreciative Judgment:** Use values to determine what is important and what is not\[27\],\[28\].

**3\. Seek the "Adequate" (Satisficing)**Do not aim for the "perfect" or "optimal" solution, as this leads to paralysis in complex systems. Aim for the **Adequate**—a composition that is sufficient and works for the specific situation\[18\],\[29\],\[30\].

**4\. Employ Systemic Assessment (The Three Looks)**To avoid being overwhelmed, structure your inquiry into three directions:

• **Look Around (Apposition):** Understand the context and environment\[31\].

• **Look In (Analysis):** Understand the specific parts and elements\[31\].

• **Look Out (Synthesis):** Understand the larger whole and how the system fits into the wider world\[32\].

**5\. Visualize and Map**Use visual methods to cope with fragmented data.

• **GIGA-mapping / Synthesis Maps:** Create large, complex visual maps to represent relationships, boundaries, and connections. This helps the design team share a mental model of the complexity\[33\],\[34\],\[35\].

• **Rich Pictures:** Use diagrams to capture the "messiness" of the situation\[36\].

**6\. Use Multiple Perspectives**No single viewpoint can capture a complex system. You must view the situation from multiple distinct angles (e.g., Technical, Organizational, Personal, Ethical, Political) to understand the whole\[37\],\[38\],\[39\].

**7\. Differentiate the Systems**When dealing with a complex project (like the offshore ship example), divide the complexity into three intertwined systems to make it manageable\[40\],\[41\]:

• **The System We Design:** The specific artifact or organization.

• **The System We Design** **For****:** The context, users, and operations.

• **The System We Design** **Within****:** The regulations, culture, and resources that constrain the project.

---
> [!info]- References
> [1] Clarke - Thesis - Its not rocket science.pdf
> [2] Nelson - The Design Way Chapt 1.pdf
> [3] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [4] Clarke - Thesis - Its not rocket science.pdf
> [5] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [6] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [7] Clarke - Thesis - Its not rocket science.pdf
> [8] EAD_BeckStolterman_ScientificTheoriesOfDesign.pdf
> [9] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [10] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [11] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [12] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [13] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [14] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [15] EAD_BeckStolterman_ScientificTheoriesOfDesign.pdf
> [16] The Challenge of Improving Design.pdf
> [17] Design judgement.pdf
> [18] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [19] Nelson - The Design Way Chapt 1.pdf
> [20] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [21] Nelson - Systemic Design as Born from the Berkeley Bubble Matrix.pdf
> [22] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [23] Design judgement.pdf
> [24] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [25] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [26] [Book] Stolterman - Thoughtful Interaction Design.pdf
> [27] Luras - Systems Intertwined a systemic view of the design situation.pdf
> [28] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [29] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [30] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [31] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [32] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [33] Jones - Systemic Design Systems Handbook.pdf
> [34] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [35] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [36] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [37] Nelson - Systemic Design as Born from the Berkeley Bubble Matrix.pdf
> [38] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [39] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [40] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [41] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf


FILE: 'Herb Simon.md'
---
tags:
  - Herb-Simon
  - What-is-complexity
title: Herb Simon on 💬What is Complexity
author: Herb Simon
---
In the context of the sources, **complexity** refers to a system composed of a **large number of parts that interact** in a non-simple way 1\. These systems are characterised by the fact that the **whole is more than the sum of its parts**, in the sense that it is non-trivial to infer the properties of the entire system from the laws governing its individual components 2\. Complexity can be measured in several ways, including **cardinality** (the number of components), the **degree of interdependence** between those components, **undecidability**, or the system's **information content** 3, 4\.  
Furthermore, complexity can lie in the "eye of the beholder"; a system may appear "inherently" simple but be categorised as complex if the observer fails to discover a simple description or chooses inappropriate primitives for its description 5\. In many frameworks, **randomness is equated with complexity**, as a random sequence cannot be represented by a formula shorter than the sequence itself 6\.  
To deal with complexity, the sources offer the following advice and strategies:

### 1\. Avoidance and Simplification

The most direct advice is to **avoid complexity** whenever possible 7\. The theory of complex systems is heavily concerned with how a system can be designed to be **as simple as possible in its structure and process** for a given complexity of function 8\. This involves defeating complexity by **removing it from the mechanism** itself 8\.

### 2\. Hierarchic Decomposition

A central structural scheme for managing complexity is **hierarchy**, where a system is organised into a "boxes-within-boxes" arrangement of subsystems 9, 10\. The analysis of such a system can be simplified by **subdividing it into parts** and performing an aggregate analysis of their interactions rather than attempting to study all interacting parts at once 11\. This is possible because many complex systems are **nearly decomposable** 12, 13\. In a nearly decomposable system, the interactions within a subsystem are much more intense and rapid than the interactions between different subsystems 14, 15\. Consequently, one can:

* Study the **short-run behaviour** of a subsystem independently of others 16, 17\.  
* Study the **long-run dynamics** of the whole system by ignoring the internal detail of the subsystems and treating them as aggregate units 17-19.

### 3\. Satisficing and Heuristics

Because human **bounded rationality** prevents us from dealing with the world in its full complexity, we must use simplified models of reality 20\. Instead of attempting to find an "optimal" solution—which is often computationally impossible in complex environments—the advice is to **satisfice** 21, 22\. This means searching for a solution that is "good enough" by meeting specific **aspiration levels** 23-25. To make this search efficient, one should use **heuristics** (rules of thumb) to selectively explore the most promising paths 21, 26, 27\.

### 4\. Effective Representation

The way a problem is **represented** is critical to its solution 28, 29\. A good representation makes the solution to a complex problem transparent 30\. For example, **diagrammatic representations** can be superior to verbal descriptions because they group together information that is used together, thereby reducing the mental effort required for search and inference 31, 32\.

### 5\. Institutional and Market Mechanisms

Societies deal with complexity by using **markets and organizations** 33, 34\.

* **Markets** conserve information by allowing actors to make decisions based on local data, such as prices, without needing to know the full detail of others' problems 35, 36\.  
* **Organizations** deal with interrelatedness by using **vertical and horizontal specialization**, which allows decision-making duties to be divided among many individuals and units 37, 38\.  
* **Institutions** provide a stable environment that allows individuals to make reasonable calculations about the consequences of their behaviour in a complex world 39, 40\.

### 6\. Attention Management

In an information-rich world, the scarce resource is not information but **human attention** 41, 42\. Dealing with complexity requires **intelligent information-filtering systems** and the deliberate allocation of attention to the most relevant tasks and subproblems 43, 44\. **Emotions** can also play a role here by serving as a mechanism to focus attention on high-priority or urgent problems 45, 46\.  


FILE: 'Horst Rittel.md'
---
tags:
  - Horst-Rittel
  - What-is-complexity
title: Horst Rittel on 💬What is Complexity
author: Horst Rittel
---
Complexity is primarily defined by the existence of **“wicked problems”**, which lack a definitive formulation and defy the “tame” problem-solving methods used in the natural sciences 1, 2\. In complex systems, **almost everything is connected to everything else**, meaning that any intervention can have unanticipated and undesirable side effects 3, 4\. Such systems are often **“nontrivial”**, meaning they respond not only to external inputs but also to their own internal states, which are observationally inaccessible 5\. This leads to **analytically indeterminable** behaviour and **transcomputational** possibilities—meaning the number of potential outcomes is so large (e.g., $10^{77}$ or $10^{120}$) that they cannot be explored or predicted through systematic observation 6-8. Furthermore, complexity in modern society is characterised by the vastness of **cyberspace**, currently estimated to contain roughly $10^{38}$ bits of potential choices and interactions 9, 10\.  
The advice for dealing with complexity focuses on moving away from detached, linear methods toward participatory and argumentative ones:

* **Abandon the “First-Generation” Systems Approach:** Traditional methods that assume a project can be organised into distinct phases of “understand the problem” and then “work out a solution” are inadequate for wicked problems, as one cannot understand a complex problem without already having a solution in mind 11, 12\.  
* **Adopt an Argumentative “Second-Generation” Model:** Decision-making should be an **argumentative process** where an image of the problem and its potential resolutions emerge gradually through incessant counter-argument and critical debate 11, 13\.  
* **Acknowledge a “Symmetry of Ignorance”:** No single expert holds the knowledge required for a wicked problem; instead, knowledge is distributed among many stakeholders 14\.  
* **Maximise Stakeholder Involvement:** Because people “revolt against being planned at,” those affected by a design or solution should be turned into **active participants** in the planning process 15\.  
* **Practise “Objectification”:** Rather than seeking scientific objectivity, participants should **make the basis of their judgements explicit** to others; while this may not lead to agreement, it facilitates a deeper mutual understanding and identifies areas of greatest disagreement 16, 17\.  
* **Accept the Paradoxes of Rationality:** Tracing the consequences of every action in a complex system is an infinite task that can lead to **paralysis**, as every consequence has further consequences of its own 18, 19\.  
* **Utilise “Chunking” and Metaphors:** To handle information overload, individuals should group related bits of information into **meaningful units or “chunks”** and use **visual metaphors** (like the “desktop” on a computer) to hide irrelevant technical complexity behind understandable concepts 20, 21\.  
* **Settle for “Satisfying” Solutions:** There is no ultimate test for a solution to a wicked problem; one stops not because a “correct” answer is found, but because one has run out of time, money, or patience, settling for a result that is **“good enough”** 11, 22\.  
* **Follow the Social Imperative:** When communicating within complex systems, researchers and designers should strive to **open new possibilities for others** rather than trying to control them 23\.



FILE: 'Humberto Maturana.md'
---
exported: '2026-01-29T10:34:58.338Z'
source: NotebookLM
type: chat
title: Humberto Maturana on 💬What is Complexity
tags:
  - Humberto-Matruana
  - What-is-complexity
author: Humberto Maturana
---
In the context of systems thinking, **complexity is viewed as a socially constructed phenomenon** rather than an objective feature of the external world\[1\]\[2\]. It arises from the **ever-changing flux of events and ideas** that are negotiated and renegotiated through human interaction\[3\]\[4\]. Complexity is also fundamentally **dependent on the worldviews (Weltanschauungen) of the participants involved**, meaning every situation encountered is unique, confusing, and shaped by the diverse perspectives of those who experience it\[5\]\[6\]. Furthermore, complexity manifests in the **biological plasticity of living systems**, where the nervous system allows for an astronomical expansion of sensorimotor patterns and potential behaviours\[7\]\[8\].

The sources offer the following advice on how to effectively deal with complexity:

### 1\. Shift from Modelling Reality to Organising Enquiry

The sources suggest that the most effective way to tackle complex situations is to **shift "systemicity" from the real world to the process of enquiry itself**\[9\]\[10\]. Rather than trying to model a complex world objectively, one should **organise the exploration as a "learning system"**\[5\]\[6\]. This involves a never-ending cycle where participants **perceive the situation, evaluate it through various viewpoints, and take action**, which then creates a new situation to be learned from again\[3\].

### 2\. Practice Objectivity-in-Parenthesis and the Multiverse

Dealing with complexity requires an ontological shift known as **"objectivity-in-parenthesis"**\[11\]\[12\]. This means accepting that **reality is not independent of the observer** and that we live in a **"multiverse" of many equally legitimate explanatory realities**\[13\]. By acknowledging that no single perspective exhausts the richness of reality, practitioners can avoid the "temptation of certainty" and remain open to the cognitive acts of others\[1\].

### 3\. Cultivate the Emotion of Mutual Acceptance (Love)

A core piece of advice for managing complex social systems is to **operate from a domain of mutual acceptance, which Maturana defines as "love"**\[17\]. Complexity in social settings often leads to conflict; however, if participants interact in a manner where **the other arises as a "legitimate other,"** social responsibility arises spontaneously\[20\]\[21\]. Coherent intervention requires **thinking, feeling, and acting in the same direction**, driven by empathy\[22\]\[23\].

### 4\. Engage in Non-Confirmatory Dialogue

To bring about meaningful change in complex, "structure-determined" systems, one should seek **"orthogonal" or "non-confirmatory" encounters**\[24\]. Because systems only do what their internal structure allows, external pressure often only triggers the same old defensive reactions\[27\]\[28\]. A "non-confirmatory" dialogue aims to **trigger structural changes** that allow for new relational dynamics, rather than reinforcing existing non-social patterns\[24\]\[25\].

### 5\. Utilise Practical Devices to De-centre Perspectives

The sources recommend using tools like a **"cylinder of an infinite number of Weltanschauungen"** to facilitate debate\[29\]\[30\]. This device helps stakeholders **suspend their own judgements** and "thematise" their worldviews by plotting proposed changes on axes of "systemically desirable" versus "culturally feasible"\[31\]. By visualising how a change might move between quadrants when a different worldview is adopted, participants can **increase their capacity for holistic understanding**\[34\].

### 6\. Embrace Wisdom and Discomfort

Dealing with complexity requires **"systemic wisdom,"** defined as an acute capacity for reflection and a **willingness to abandon convictions** that prevent a holistic perception\[37\]\[38\]. Practitioners are advised to **"remain uncomfortable"** and stay openly critical of their own premises, rather than seeking a "cosy group-think" mentality\[39\]\[40\]. This discomfort is necessary to ensure that the intervention remains **emancipatory and ethically justified**\[41\].

---
> [!info]- References
> [1] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [2] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [3] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [4] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [5] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [6] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [7] [Book] Maturana - Tree of knowledge.pdf
> [8] cognitive theories of maturana.pdf
> [9] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [10] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [11] Maturana 1988 - The search for objectivity.pdf
> [12] Maturana 1988 - The search for objectivity.pdf
> [13] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [17] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [20] Bond Maturana Technology and Art Is a Biology of Technology Possible.pdf
> [21] Maturana 1988 - The search for objectivity.pdf
> [22] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [23] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [24] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [25] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [27] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [28] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [29] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [30] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [31] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [34] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [37] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [38] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [39] Retmolds - Churchman and Maturana enriching the notion of self organization for social design.pdf
> [40] Retmolds - Churchman and Maturana enriching the notion of self organization for social design.pdf
> [41] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf


FILE: 'Hylton Boothroyd.md'
---
exported: 2026-02-07T20:36:39.151Z
source: NotebookLM
type: chat
title: Hylton Boothroyd on 💬What is Complexity
tags:
  - What-is-complexity
  - Hylton-Boothroyd
author: Hylton Boothroyd
---

Based on the sources, complexity is defined by the breakdown of traditional scientific reductionism when applied to human and social systems, and dealing with it requires a shift from "optimizing" to "learning" and "articulating."
### What is Complexity?

**1\. Organized Complexity and "Wicked" Problems**Complexity refers to "ill-structured" or "wicked" problems characterized by being ill-defined, having many stakeholders with conflicting interests, and containing intangibles and uncertainties\[1\]. Unlike the problems of natural science ("Type 1" phenomena), complex real-world situations ("Type 3") are dominated by the meanings and perceptions attributed to them by observers\[2\]. In these situations, "problems" are not discrete entities like insects to be collected; rather, they are tightly interconnected, such that "in every problem is to be found all other problems"\[3\].

**2\. The Failure of Reductionism**Complexity arises where the "reductionist" method of science (dividing a problem into separate parts to solve one by one) becomes impotent\[4\]. In complex social systems, the "hard" parts (mathematical/technical) cannot be meaningfully isolated from the human and organizational elements\[5\]. Consequently, an "unbounded" systems approach is required because pursuing a simple question (like inventory levels) inevitably leads to more complicated issues (like capital management and marketing policies)\[6\],\[7\].

**3\. The "Mess"**Ackoff characterizes these complex situations not as simple problems, but as a "mess"\[8\]. This mess consists of multiple interacting action programmes—bundles of theories (beliefs about the world) and proposals (values and desires)—that are often in conflict\[9\],\[10\].

### Advice on Dealing with Complexity

To deal with complexity, the sources advise moving away from the search for a single "optimal" solution and toward methodologies of learning, negotiation, and articulation.

**1\. Shift from Optimization to Learning**In complex ("soft") systems, the paradigm must shift from _optimization_ (finding the best means to a defined end) to _learning_ (a systemic exploration of perceptions)\[11\].

• **Soft Systems Methodology (SSM):** Instead of building models of the world, build models of _perceptions_ or "ideal types" (e.g., viewing a prison as a "punishment system" vs. a "rehabilitation system")\[12\]. Use these models to structure a debate with stakeholders to find changes that are "systemically desirable" and "culturally feasible"\[13\].

• **Problem Structuring Methods (PSMs):** Use methods like Cognitive Mapping or the Strategic Choice Approach to manage uncertainty and agree on the nature of the problem before trying to solve it\[1\],\[14\].

**2\. Articulate Intervention (Theories vs. Proposals)**Effective intervention requires articulating the "action programmes" of the participants\[9\].

• **Distinguish "Is" from "Ought":** You must distinguish between _theories_ (pictures of how things are/will be) and _proposals_ (pictures of what we wish to happen)\[15\]. Theories do not imply action; proposals are required to bridge the gap\[16\].

• **Reflection Before Action:** Engage in "articulate reflection before action," abandoning the claim to certainty and accepting that all recommendations are necessarily impermanent and subject to review\[17\],\[18\].

**3\. Manage Assumptions and Stakeholders**

• **Stakeholder Identification:** Recognize that there are multiple "problem owners" with different objectives. The solution must be owned by the problem owner\[19\],\[20\].

• **Dialectical Approach:** Since complex problems are ill-structured, use adversarial or dialectical methods to surface and challenge the underlying assumptions of different groups\[21\],\[22\]. Establish conditions where different groups can negotiate their reality\[23\].

**4\. Addressing Risk and Uncertainty**

• **Environmental Consistency:** For operational risks, attempt to correlate activities with outcomes. If you cannot predict incidents, you are not consistent with your environment\[24\]. However, be aware of "fat-tailed" distributions (Black Swans) where statistical methods fail\[25\].

• **Debugging and Diagnostics:** In policy analysis, focus on "diagnostics" (estimating complex situations) and "debugging" (counteracting decision-error propensities in leaders), rather than just providing data\[26\],\[27\].

**5\. Experiential Redesign**Instead of trying to cut up "reality" into fixed parts to model, cut relative to "experience." Use the experience of individuals to design new procedures that improve their specific activities, recognizing that there is no single "dominant" problem to be solved\[28\],\[29\].

---
> [!info]- References
> [1] Rosenhead 2006 - The uses of observation combining problem syructuring methods and ethnography.pdf
> [2] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [3] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [4] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [5] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [6] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [7] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [8] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [9] 2010 Articulate Intervention Revisited.pdf
> [10] 2010 Articulate Intervention Revisited.pdf
> [11] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [12] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [13] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [14] Rosenhead 2006 - The uses of observation combining problem syructuring methods and ethnography.pdf
> [15] 2010 Articulate Intervention Revisited.pdf
> [16] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [17] 2010 Articulate Intervention Revisited.pdf
> [18] Boothroyd Scanned.pdf
> [19] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [20] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [21] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [22] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [23] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [24] Risk-case-study.md
> [25] Risk-case-study.md
> [26] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [27] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [28] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf
> [29] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf


FILE: 'Ian Mitroff.md'
---
tags:
  - Ian-Mitroff
  - What-is-complexity
title: Ian Mitroff on 💬What is Complexity
author: Ian Mitroff
---
In the context of the sources, **complexity** is defined not as a single, isolated problem, but as a **“mess”**—a system of highly interactive, strongly coupled problems that cannot be understood independently of one another 1-3. A defining characteristic of complexity is **nonlinearity**, where small changes can lead to large, unpredictable effects, and the whole is always more than the sum of its separate parts 4, 5\. In today’s **Systems Age**, complexity manifests as **“wicked problems”** that have no single correct solution, no clear stopping rules, and defy the boundaries of any single academic discipline 6-8. Furthermore, complex systems are often **unbounded**, meaning they are so interconnected that events occurring in one part of the globe can potentially disrupt unrelated systems elsewhere 9, 10\.  
The advice for dealing with complexity focuses on moving beyond outmoded Machine Age thinking toward **Unbounded Systems Thinking** 9, 11\. Key strategies include:

* **Adopting Multiple Perspectives:** One must look at a complex system simultaneously through **Technical (T), Organizational (O), and Personal (P)** lenses 12-14. Relying solely on a Technical perspective often leads to a **“Type Three Error”**, which is solving the wrong problem precisely 15-17.  
* **Practising Synthetic Thinking:** While traditional analysis breaks a system down into parts, **synthetic thinking** identifies the containing whole of which the system is a part and focuses on managing the **interactions** between parts rather than the parts themselves 18-20.  
* **Strategic Assumption Surfacing and Testing (SAST):** Because complex problems involve many stakeholders with different values, it is vital to **surface and challenge the underlying assumptions** that each party brings to the situation 21-23.  
* **Designing for “Safe-Fail” rather than “Fail-Safe”:** Complex sociotechnical systems cannot be made perfectly fail-safe; therefore, organizations should adopt a **safe-fail approach** that trades the absolute avoidance of failure for the ability to survive and recover when failure occurs 24-26.  
* **Managing Paradoxes:** Complexity is riddled with paradoxes, such as the fact that **“bigger is not always better”** and bigness can eventually lead to inefficiency or systemic collapse 27-29.  
* **Forming Interparadigmatic Teams:** Successfully managing messes requires teams composed of individuals from diverse backgrounds—such as lawyers, psychologists, and engineers—who operate under **different inquiring systems** 30, 31\.  
* **Embracing Critical Thinking and Wisdom:** Dealing with complexity demands the **wisdom to rise above biases** and the ability to define, and then redefine, problems as they evolve over time 32-34.  
* **Proactive Crisis Management:** Organisations must engage in proactive **crisis management** by “thinking the unthinkable” and preparing for families of interrelated crises rather than a single event 35-37.



FILE: 'James Ladyman.md'
---
exported: 2026-02-07T20:37:05.827Z
source: NotebookLM
type: chat
title: James Ladyman on 💬What is Complexity
tags:
  - What-is-complexity
  - James-Ladyman
author: James Ladyman
---
**Complexity** is not a single natural phenomenon, but rather a collection of features found in systems that exist in a specific regime between perfect order (like a crystal) and perfect randomness (like a gas)\[1\].

Based on the provided texts, here is a breakdown of what complexity is and advice on how to navigate it.

### **1\. What is Complexity?**

Complexity is best understood as a state of **"robust organisation and memory"** that emerges from the disordered interactions of many components\[4\]. It is distinct from being merely "complicated" (which implies difficult to understand but potentially predictable, like a machine) because complex systems exhibit **emergent behaviour** that cannot be derived solely from the properties of their individual parts\[5\]\[6\].

Ladyman and Wiesner categorize complexity into **Conditions** (what is required for it to arise) and **Products** (the features it exhibits):

**The Necessary Conditions:**

• **Numerosity:** The system must consist of an **ensemble of many elements** and many interactions. "More is different"; large numbers allow statistical regularities to emerge that small numbers do not\[7\]\[8\].

• **Disorder and Diversity:** The interactions are **not coordinated or controlled centrally**. The system is not rigid; it relies on disorder (such as thermal fluctuations or distributed agents) to generate order\[9\].

• **Feedback:** The system is recursive. Outputs loop back to become inputs, allowing the system to remember its past and modify its future behavior\[9\]\[12\].

• **Non-Equilibrium:** The system is **thermodynamically open**. It must exchange energy, matter, or information with its environment. If a system reaches equilibrium (death/stasis), complexity vanishes\[11\]\[13\].

**The Emerging Products:**

• **Spontaneous Order:** Structure (like a flock of birds or a market price) arises without a central controller or blueprint\[13\]\[14\].

• **Robustness:** The system remains stable despite perturbations (e.g., the internet rerouting traffic after a node fails, or a flock reforming after an attack)\[15\]\[16\].

• **History and Memory:** Complex systems are **historically dependent**. They store information about their past (e.g., in DNA or culture) and their current state is a result of a specific, non-trivial causal history\[13\].

• **Adaptive Behaviour:** In biological and social systems, the system modifies its behavior based on predictions about the environment\[13\]\[19\].

\--------------------------------------------------------------------------------

### **2\. Advice on How to Deal with Complexity**

Dealing with complexity requires shifting from a "mechanistic" worldview (viewing things as isolated machines) to a **relational and probabilistic** worldview.

**A. Abandon the Search for "Exact" Prediction**

You cannot predict the exact future of a complex system because it is **nonlinear** and often sensitive to initial conditions (chaos).

• **Advice:** Shift to **probabilistic thinking**. Look for robust patterns and statistical regularities (like the shape of a bell curve) rather than specific outcomes for individual components\[20\]\[21\]. Use **Statistical Complexity** as a guide: look for the minimum amount of information needed to predict the system's future distribution of states, rather than trying to describe the system verbatim\[22\]\[23\].

**B. Stop Looking for a "Central Controller"**

Complex systems are characterized by **distributed control**. The order you see (e.g., in an ant colony or a brain) is not directed by a "boss" or a single neuron but arises from local interactions.

• **Advice:** Do not try to control the system by seizing a single lever. Understand that order arises from the **bottom-up** through local interactions and feedback loops\[24\]. To influence the system, you must influence the _rules of interaction_ or the _environment_ rather than individual parts.

**C. Foster "Metastability" (The Middle Path)**

To maintain complexity (and life), a system must balance between too much order (rigidity/death) and too much disorder (chaos/dissolution).

• **Advice:** Foster **metastability**. This is a state of "quivering" sensitivity where the system is stable enough to maintain cohesion but unstable enough to adapt and change\[27\]\[28\].

    ◦ **Avoid Over-Stability:** Too much centralization or homogeneity makes a system brittle and unable to adapt\[29\].    ◦ **Avoid Over-Instability:** Too much disconnection or randomness leads to dissolution\[30\].

**D. Focus on Relations and History**

Reductionism (breaking things down to atoms) fails in complex systems because the "extra" information is stored in the **relations** and the **history**, not the parts themselves.

• **Advice:** Analyze the **network of interactions** (who connects to whom?) and the **causal history** (how did we get here?). A complex system carries "internal evidence of a non-trivial causal history" (Logical Depth); you cannot understand its current state without understanding the long process that created it\[17\]\[31\].

**E. Value "Liberatory Emergence"**

From an ethical and practical standpoint (based on Vitale's "Networkologies"), dealing with complexity means fostering systems that can continue to evolve and deepen.

• **Advice:** Support systems that are **distributed** and **relational**. Avoid "counter-emergence"—systems that turn against their own potential by becoming rigid, parasitic, or overly centralizing (like cancer or authoritarian control)\[32\]\[33\]. Your goal should be to foster environments where diverse elements can interact to produce novel, sustainable outcomes\[34\].

---
> [!info]- References
> [1] EU brain failed project d41586-020-03462-3.pdf
> [4] Ladyman - What is a Complex System.pdf
> [5] Ladyman - What is a Complex System.pdf
> [6] [Book] Ladyman - What Is a Complex System.pdf
> [7] Ladyman - What is a Complex System.pdf
> [8] Ladyman - What is a Complex System.pdf
> [9] Ladyman - On Complexity.pdf
> [11] [Book] Ladyman - What Is a Complex System.pdf
> [12] Ladyman - What is a Complex System.pdf
> [13] Ladyman - On Complexity.pdf
> [14] Ladyman - What is a Complex System.pdf
> [15] Ladyman - What is a Complex System.pdf
> [16] Ladyman - What is a Complex System.pdf
> [17] Ladyman - What is a Complex System.pdf
> [19] [Book] Ladyman - What Is a Complex System.pdf
> [20] Ladyman - What is a Complex System.pdf
> [21] Ladyman - What is a Complex System.pdf
> [22] Ladyman - What is a Complex System.pdf
> [23] wiesner - measuring complexity.pdf
> [24] Ladyman - What is a Complex System.pdf
> [27] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [28] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [29] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [30] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [31] [Book] Ladyman - What Is a Complex System.pdf
> [32] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [33] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [34] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf


FILE: 'James Wilk.md'
---
tags:
  - James-Wilk
  - What-is-complexity
title: James Wilk on 💬What is Complexity
author: James Wilk
---
According to the sources, **complexity is not a feature of the world itself**, but rather a function of our lack of understanding or the way we choose to map reality 1, 2\. To understand something is to find it simple; if a situation appears complex, it indicates that the observer is using a lens—often a set of **mid-level abstractions**—that confers no genuine insight 1-3.

### What is Complexity?

Complexity is described in the sources as a **perceptual "bug"** rather than an objective "feature" of the territory 2, 4\.

* **The Illusion of Abstraction:** Complexity arises when we view the world through "thin descriptions" and "blurry yet concrete-sounding abstractions" (such as "staff attitudes" or "market penetration") 1, 5, 6\. These metaphors limit our thinking to a few rigid possibilities and mask the **latent possibilities** found at the concrete level 5, 7, 8\.  
* **A Failure of Mapping:** It is a "fault in our maps," resulting from the attempt to use generic, standardized tools to address **singular, idiosyncratic** real-world situations 9, 10\.  
* **Surrogate Worlds:** Traditional management often constructs an impoverished, abstract **surrogate world** in place of the "rich, granular detail" of the real world, which makes simple matters seem unnecessarily unfathomable 9, 11, 12\.

### Advice on How to Deal with Complexity

The sources provide a rigorous, scientific alternative to traditional "systems thinking" for managing complex situations:  
**1\. Filter Complexity Instead of Modelling It**Traditional approaches attempt to **model complexity** using *ad hoc* maps, charts, or computer simulations with boxes and arrows 13, 14\. These models are merely simplified re-descriptions that retain some features while omitting the very details where optimal solutions are found 14-16.

* **Divide the Universe of Possibilities:** You should deal with complexity by using iterative, **"rule-out" questioning** 17, 18\. By asking if a factor is in "one half of the universe of possibilities or the other" (e.g., "is it bigger than a breadbox?"), you can rule out vast subsets of irrelevant data 17, 19\.  
* **Efficiency of Filtering:** Because filtering is logarithmic, even a problem 100,000 times more complex than another may only require about 17 additional well-selected questions to resolve 17, 18\.

**2\. Get Down to "Video Descriptions"**To disperse the "conceptual smokescreen" of abstractions, you must **climb down the ladder of abstraction** to reach the uninterpreted, concrete physical realities 20-22.

* **Direct Observables:** Translate the situation into **video descriptions**—empirical terms restricted to what could be verified by a video recording with a soundtrack 23-25.  
* **Non-negotiable Facts:** This process separates "non-negotiable" facts from "negotiable" attributed meanings, providing a firm ground for intervention 26-28.

**3\. Search for the Idiosyncratic Lynch-pin**Complexity dissolves when you stop seeking general solutions for general classes of problems and instead treat every situation as **utterly unique** 29-31.

* **Sample Size of One:** Focus on the **singular and idiosyncratic** detail, as real-world mechanisms are often "one-off" and situation-specific 32-34.  
* **Reverse Butterfly Effect:** In a complex, "kaleidoscopic" system, a tiny, trivial-sounding action (the "butterfly wing-flap") can flip the entire pattern to a desired state if the right **lynch-pin mechanism** is identified 35-37.

**4\. Adopt a "Negative Explanation" Framework**Instead of asking "what caused this?", which leads to a search for elusive "root causes," adopt an epistemology of **flux-and-constraint** 32, 38, 39\.

* **Expect Flux:** Assume that continuous, random flux is the norm; it is the **persistence of a pattern** that requires explanation 38, 40, 41\.  
* **Identify Constraints:** Ask negative questions such as **"What stops this happening?"** or "How is it that the current state-of-affairs is the only one not currently prevented?" 32, 42, 43\.  
* **Release Change:** Once the specific, local constraints keeping a problematic pattern in place are pinpointed, they can be lifted or inserted to **release** the desired change instantaneously 39, 42, 44\.

**5\. Recover a Sense of Wonder**The sources advise looking at familiar, "obvious" features with **astonishment** 45, 46\. Complexity often results from over-rationalizing things that are fundamentally simple; a "realist" should "plan for a miracle" by recognizing that what seems impossible is often merely a function of a faulty understanding of nature 46-48.  


FILE: 'John Flach.md'
---
exported: 2026-02-07T20:37:53.258Z
source: NotebookLM
type: chat
title: John Flach on 💬What is Complexity
tags:
  - What-is-complexity
  - John-Flach
author: John Flach
---
**Complexity** is defined not merely as difficulty, but as a property of the **space of possibilities** within a system or environment. It is fundamentally tied to uncertainty—the greater the number of possibilities, the greater the uncertainty about the future\[1\]\[2\].

### What is Complexity?

The sources conceptualize complexity through several interacting dimensions:

• **Dimensionality and Interdependence:** Complexity is determined by the number of variables (dimensionality) and the nature of the relationships between them (interdependence).

    ◦ **Tractable systems** have low interdependence (linear/additive) or low dimensionality. They function like clockwork mechanisms where the whole is equal to the sum of the parts\[3\]\[4\].    ◦ **Intractable (Complex) systems** have high dimensionality and high interdependence (nonlinear). In these systems, a small change in one component can cascade to cause massive, unanticipated changes elsewhere (the Butterfly Effect)\[5\].
• **Wicked Problems:** Many natural and sociotechnical situations are "wicked problems"—ill-formulated issues with confusing information and conflicting values, where proposed solutions often create new problems\[8\].

• **The "Iceberg" of Hidden Variables:** In complex systems, what is observable is often just the tip of the iceberg. The critical variables and causal loops are hidden below the surface\[11\].

• **Open Systems:** Unlike closed laboratory experiments, complex systems are **open** to the flow of energy and information from the environment. The number of environmental variables that can impact the system approaches infinity (e.g., the "unknown unknowns")\[12\]\[13\].

### The Core Challenge: Ashby’s Law

The central challenge of complexity is defined by **Ashby’s Law of Requisite Variety**: "Only variety can destroy variety"\[14\]. To control a system effectively, the controller must have a repertoire of responses (variety) at least as nuanced and complex as the problems presented by the system\[15\]\[16\]. Because modern complex systems (like healthcare or military operations) often exceed the variety a single human or algorithm can handle, rigid control inevitably fails\[17\].

\--------------------------------------------------------------------------------

### Advice on How to Deal with Complexity

The sources reject the idea of "solving" complexity through rigid top-down control or perfect optimization. Instead, they advocate for **coping** through adaptation, resilience, and distributed intelligence.

1\. Adopt a Strategy of "Muddling Through" (Incrementalism)

Instead of trying to make the _right decision_ (which requires perfect knowledge of the future), focus on **making the decision right** through adaptation\[18\]\[19\].

• **Incremental Steps:** Make small, reversible changes rather than massive, all-at-once transformations. Small steps reduce the risk of catastrophic unintended consequences\[20\]\[21\].

• **Monitor and Adapt:** Treat every action as an experiment. Monitor the feedback carefully to detect errors or surprises, and adjust the course immediately. This is an **adaptive control** loop\[22\]\[23\].

• **Satisficing:** Do not aim for the "optimal" solution, which is impossible to calculate in complex dynamic systems. Aim for a solution that "satisfices" (suffices and satisfies) the immediate constraints to maintain stability\[24\]\[25\].

2\. Distribute Authority (Subsidiarity)

Centralized control fails in complex systems because of the **Local Knowledge Problem**: central commanders cannot access local information fast enough to respond to rapid changes\[26\]\[27\].

• **Push Decisions Down:** Follow the principle of **subsidiarity**: authority belongs to the lowest level in the hierarchy that has the information to decide (the "sharp end" or the "man on the spot")\[28\]\[29\].

• **Command Intent:** Leaders should specify the _what_ and _why_ (intent/goals) but leave the _how_ to the local actors who can adapt to the specific situation\[30\]\[31\].

• **Networked Coordination:** Move from hierarchical structures to **heterarchical** or federalist structures where control shifts to whoever has the relevant information at the moment\[32\]\[33\].

3\. Design for "Essential Friction"

Do not remove all barriers in the name of efficiency. **Friction** (resistance, checks, and balances) is essential for stability\[34\]\[35\].

• **Damping Errors:** Friction provides time to detect errors and prevents bad decisions from propagating too quickly through the system. It keeps the system in contact with reality\[36\]\[37\].

• **The Power to Say "No":** Ensure that diverse voices have the power to negate or stop an action if they detect a threat (e.g., a junior officer waving off a carrier landing)\[38\].

4\. Leverage Self-Organization

Recognize that order often emerges from the bottom up, not just from a top-down plan (like termites building a complex nest through simple local interactions)\[39\]\[40\].

• **Enable, Don't Dictate:** Leaders should act as "gardeners," creating the conditions (resources, shared values, communication channels) that allow the organization to self-organize and adapt\[41\].

• **Support Mutual Adjustment:** Facilitate **horizontal communication** so that parts of the system can coordinate directly with each other (mutual adjustment) rather than routing everything through a central planner\[42\]\[43\].

5\. Change Your Perspective (Triadic Thinking)

• **Be Humble:** Accept that any single model is biased and incomplete. You must use multiple perspectives ("move around the elephant") to understand the whole\[44\]\[45\].

• **Look for Deep Structure:** Use **Work Domain Analysis** to map the abstract functional constraints (values, physical laws) rather than just listing surface-level tasks. Understanding the "deep structure" allows for better adaptation to novel events\[46\]\[47\].

• **See the Triad:** Do not look at the human or the technology in isolation. Look at the **coupling** between the agent, the interface, and the ecology. Meaning and success emerge from this interaction\[48\]\[49\].

---
> [!info]- References
> [1] Flach 2011 - Complexity learning to muddle through.pdf
> [2] Flach 2011 - Complexity learning to muddle through.pdf
> [3] Flach 2011 - Complexity learning to muddle through.pdf
> [4] Flach 2011 - Complexity learning to muddle through.pdf
> [5] Flach 2011 - Complexity learning to muddle through.pdf
> [8] Do Conversations Exist.pdf
> [11] Norman 2015 - DesignX Complex sociotechnical systems.pdf
> [12] Flach 2011 - Complexity learning to muddle through.pdf
> [13] [Book] Flach - Control theory for humans quantitative approaches to modeling performance.pdf
> [14] Flach 2011 - Complexity learning to muddle through.pdf
> [15] Do systems exist A conversation - Adam Walls John Flach.pdf
> [16] Flach 2011 - Complexity learning to muddle through.pdf
> [17] Norman 2015 - DesignX Complex sociotechnical systems.pdf
> [18] [Book] Flach - A Meaning Processing Approach to Cognition What Matters.pdf
> [19] [Book] Flach - What Matters 2017.pdf
> [20] Do Conversations Exist.pdf
> [21] Do systems exist A conversation - Adam Walls John Flach.pdf
> [22] Do Conversations Exist.pdf
> [23] Norman 2015 - DesignX Complex sociotechnical systems.pdf
> [24] Norman 2015 - DesignX Complex sociotechnical systems.pdf
> [25] Norman 2015 - DesignX Complex sociotechnical systems.pdf
> [26] Do Conversations Exist.pdf
> [27] Flach 2011 - Complexity learning to muddle through.pdf
> [28] Do Conversations Exist.pdf
> [29] [Book] Walls - Do systems exist - A conversation Adam Walls John Flach.pdf
> [30] Do Conversations Exist.pdf
> [31] [Book] Walls - Do systems exist - A conversation Adam Walls John Flach.pdf
> [32] Flach 2011 - Complexity learning to muddle through.pdf
> [33] [Book] Flach - A Meaning Processing Approach to Cognition What Matters.pdf
> [34] Do Conversations Exist.pdf
> [35] [Book] Walls - Do systems exist - A conversation Adam Walls John Flach.pdf
> [36] Do Conversations Exist.pdf
> [37] [Book] Flach - What Matters 2017.pdf
> [38] [Book] Flach - What Matters 2017.pdf
> [39] Do Conversations Exist.pdf
> [40] Do systems exist A conversation - Adam Walls John Flach.pdf
> [41] Do Conversations Exist.pdf
> [42] Do Conversations Exist.pdf
> [43] Do systems exist A conversation - Adam Walls John Flach.pdf
> [44] Do Conversations Exist.pdf
> [45] Do systems exist A conversation - Adam Walls John Flach.pdf
> [46] [Book] Flach - A Meaning Processing Approach to Cognition What Matters.pdf
> [47] [Book] Flach - A Meaning Processing Approach to Cognition What Matters.pdf
> [48] Norman 2015 - DesignX Complex sociotechnical systems.pdf
> [49] [Book] Flach - What Matters 2017.pdf


FILE: 'John Warfield.md'
---
tags:
  - John-Warfield
  - What-is-complexity
title: John Warfield on 💬What is Complexity
author: John Warfield
---
**Complexity** is not a property of a system itself, but rather a **sensation of frustration** experienced in the human mind when comprehension fails while observing a multi-variable situation 1-3. It is defined as a measure of the **difficulty, effort, or resources** required for one system to effectively observe, communicate, or interoperate with another 4-6. In systems science, complexity arises when no single individual understands a problematic situation that is of concern to many, often involving hundreds of interrelated variables that exceed the **cognitive limits** of the human brain 7-9.  
The sources provide the following advice on how to deal with complexity effectively:

### 1\. Adopt the Work Program of Complexity (WPOC)

The primary recommendation is to move away from intuitive, individual efforts toward a **disciplined collective work program** consisting of four components: **Description, Diagnosis, Design, and Implementation** 10-12. This program is divided into two phases:

* **Discovery:** Involves pooling the beliefs of an informed group to describe the situation through **problematization** and then diagnosing the resulting structural patterns 10, 13, 14\.  
* **Resolution:** Focuses on generating design options that match the dimensionality of the problem and implementing a plan that maintains **vertical coherence** across the organisation 15-17.

### 2\. Implement Linguistic Adjustments

To ensure coherent dialogue and precise reasoning, practitioners must purge "linguistic pollution" and adjust their terminology:

* **Replace "The Problem" with "The Problem Set":** Complexity always involves dozens or hundreds of interrelated problems; starting with a single definition is a "linguistic nightmare" 18-20.  
* **Use "Problematique":** Instead of vague "complex problems", construct a **problematique**—a graphic logic structure showing how a set of problems significantly aggravates one another 21-23.  
* **Replace "Solutions" with "Options":** Naming a "solution" prematurely is presumptive; instead, generate an **Options Field** consisting of mutually reinforcing choices 24-27.

### 3\. Account for Behavioral Pathologies

Effective management of complexity requires processes that nullify human fallibility:

* **Respect Cognitive Limits:** Follow the **Law of Triadic Compatibility**, which notes that the mind can only effectively process the interactions between **three elements at a time** (roughly seven concepts) 28-30.  
* **Overcome Spreadthink:** Recognise that members of an informed group will always have **diverse beliefs** about what is important 31, 32\.  
* **Prevent Groupthink:** Use neutral, facilitated processes like the **Nominal Group Technique (NGT)** and **Interpretive Structural Modelling (ISM)** to ensure that the final model represents a collective learning outcome rather than social pressure 33-36.

### 4\. Establish Necessary Infrastructure

Resolution cannot occur in standard, cramped environments. It requires:

* **The Situation Room:** A dedicated space with **large magnetic walls** and wide-scanning displays to cater to human visual requirements and allow groups to focus on one relational question at a time 37-40.  
* **The Corporate Observatorium:** A physical or virtual space to house the products of the work (graphics, problematiques, and design profiles) to **educate implementers** and ensure continuity as the situation evolves 41-44.

### 5\. Transition the Executive Role

Top management should shift from trying to be individual "complexity solvers" to becoming **strategic enablers** who provide the resources and infrastructure for subordinates to carry out the WPOC 45-47. Success requires that high-level executives accept results developed from a sound base in systems science, even when those results challenge their prior agendas 48, 49\.  


FILE: 'MC Jackson.md'
---
tags:
  - MC-Jackson
  - What-is-complexity
title: MC Jackson on 💬What is Complexity
author: MC Jackson
---
Complexity is defined in the sources as a state of **"messes"** or **"wicked problems"**—sets of interacting, richly interconnected problems that are difficult to formulate and lack simple, true-or-false solutions 1-6. Its core characteristics include a **large number of dynamically interacting elements**, **non-linearity** (where small changes lead to disproportionate effects), **feedback loops**, and the fact that the **system evolves over time** 7-10. A crucial distinction exists between **"restricted complexity"**, which assumes hidden laws can be uncovered through computational modelling, and **"general complexity"**, which is considered irreducible and unknowable as a whole 11-15. Furthermore, **ontological complexity** refers to the inexhaustible variety inherent in the real world, while **cognitive complexity** arises from the multiple ways in which individuals view that world 9, 16, 17\. In cybernetic terms, complexity is measured as **"variety"**, or the number of distinguishable states a system can exhibit 18-20.  
The sources provide the following advice on how to deal with complexity:

* **Adopt Holism over Reductionism:** Instead of breaking a situation down into its independent parts, focus on the **interconnectedness of the whole** and the **emergent properties** that arise from how those parts are organized 21-27.  
* **Employ the EPIC Framework:** Use **Critical Systems Practice (CSP)**, which follows a four-stage iterative process: **Explore** the situation using multiple perspectives, **Produce** an intervention strategy, **Intervene** flexibly as the situation evolves, and **Check** the results to obtain learning 28-32.  
* **Utilize Systemic Metaphors:** View organizations through di¡erent "filters"—such as **machines, organisms, brains, cultures, coalitions, or prisons**—to highlight di¡erent aspects of a "mess" and avoid the danger of a single, restricted worldview 33-41.  
* **Practice Variety Engineering:** In line with the **Law of Requisite Variety**, the **variety of the controller must be equal to or greater than the variety of the system** being controlled; this is achieved by either reducing the system's variety or amplifying the controller's variety 18, 42-46.  
* **Identify High-Leverage Points:** Rather than making obvious or large-scale changes, look for **small, well-focused actions** (sometimes called "trojanmice") that can produce significant improvements because cause and e¡ect are often distant in space and time 47-50.  
* **Manage Pluralism through Learning:** When complexity arises from di¡ering stakeholder values, use **soft systems approaches** (such as SSM or Interactive Planning) to facilitate a systemic learning process and reach **accommodations** for action rather than forcing a false consensus 51-56.  
* **Address Power and Coercion:** Use **emancipatory systems thinking** (like CSH or Team Syntegrity) to reveal the "normative content" of systems designs and ensure that disadvantaged or marginalized stakeholders have a voice in decision-making 57-64.  
* **Operate at the "Edge of Chaos":** Seek a state of **bounded instability** between total order and complete disorder, as this is where complex adaptive systems are most capable of **self-organization and creative innovation** 65-71.  
* **Adopt a Multimethodological Approach:** Because modern problem situations are **multidimensional**, use a variety of systems methodologies and methods in combination to address di¡erent facets of the complexity simultaneously 72-76.  
* **Embrace Systemic Pragmatism:** Recognize that knowledge is local and contextual; focus on **"what works"** in practice and be willing to switch methodologies as the problem situation changes 17, 77-82.



FILE: 'MOM.md'
---
tags:
  - MOM
  - What-is-complexity
title: MOM on 💬What is Complexity
author: MOM
---
In the sources, complexity is not described as an objective, independent property of the world. Instead, it is understood as a **mental construct** used by an observer to make sense of a messy reality.

### What is Complexity?

The proponents in the sources define complexity through the following lenses:

* **Subjectivity:** Complexity is described as being **"in the eye of the beholder"** 1-5. It is a state of perception dependent on an observer’s cognitive limits, experiential knowledge, and bounded rationality 4, 6-8.  
* **Complicated vs Complex:** A critical distinction is made between **"complicated"** (deterministic) systems, which are solvable with enough parameters or computing power, and **"complex"** (stochastic) systems, which are unpredictable even if the underlying rules are known 9-11.  
* **Path Dependency:** Complexity is often **path-dependent**, meaning the outcome of a system is influenced by its starting conditions 11, 12\.  
* **Organised Complexity:** Systems thinking is presented as the only appropriate response to **"organised complexity"**, a domain where traditional science and "decisionism" fail to provide certainty 13-15.  
* **Ontological vs Cognitive:** Complexity is divided into **ontological complexity** (the inherent nature of the world) and **cognitive complexity** (the complexity of our mental models and descriptions) 15-18.

### Advice on How to Deal with Complexity

The sources provide several strategic recommendations for navigating complex problem situations:

* **Adopt a Multi-perspectival Approach:** Because all "truths" in a complex situation are partial, practitioners must employ **multiple viewpoints** to handle the most pressing and significant issues 15, 17, 19, 20\.  
* **Employ Multi-methodology:** No single systems approach can grasp the "whole system" 15, 19\. Dealing with complexity requires making an informed choice of systems methodologies, models, and methods to use **in combination** 15, 19, 21-23.  
* **Practise Epistemic Humility:** Observers should recognise that their "variety" is always limited compared to the infinite complexity of the world (Ashby’s Law) 24-26. This includes acknowledging that **"all models are wrong, but some are useful"** 27-29.  
* **Establish Requisite Boundaries:** A "requisite boundary" should be drawn to match the needs of specific situational circumstances rather than assuming absolute physical limits 8, 30-32.  
* **Design for Resilience, Not Just Efficiency:** Proponents argue that **"excessive efficiency kills processes"** in complex environments 33, 34\. Systems must have **"slack" or "redundancy"** to remain viable and absorb unexpected shocks 35-37.  
* **Focus on Problem Structuring:** Before leaping to "solutions", practitioners should focus on **"mess management"** and problem structuring 38-41. They should "muddle through" by asking intelligent questions rather than applying rigid "toolkits" 38, 42, 43\.  
* **Engagement and Second-Order Thinking:** Dealing with complexity requires **"reflection on a reflection"**—the observer must be aware of their own frameworks of understanding and how they interact with the system 44-48.  
* **Mode 2 Learning:** Complexity should be handled through **experiential learning** (learning by doing) rather than rote theory 41, 49-53. The practitioner should act as a guide, exploring the situation with stakeholders rather than imposing a pre-planned process 19, 54-56.



FILE: 'Max Boisot.md'
---
tags:
  - Max-Boisot
  - What-is-complexity
title: Max Boisot on 💬What is Complexity
author: Max Boisot
---
In the provided sources, **complexity** is defined as an emergent property of the interacting elements and connectivities within a system 1, 2\. It is considered the phenomenological manifestation of **variety** at work 3\. Murray Gell-Mann, whose work is central to these theories, distinguishes between **crude complexity**, which is often indistinguishable from random noise, and **effective complexity**, which resides in the regularities underpinning a system's structure 4-6.  
Within the **I-Space** framework, complexity is further categorised into three dimensions:

* **Descriptive complexity**: The data-processing effort required to distinguish between categories or assign events to them 7\.  
* **Computational complexity**: A function of the number of variables in a system (dimensionality) and the nonlinearity of their interactions 8\.  
* **Relational complexity**: The number of agents participating in an interaction or social computational process 9\.

### Advice on Dealing with Complexity

The primary advice for dealing with complexity is rooted in **Ashby’s Law of Requisite Variety**, which the sources update to the **Law of Requisite Complexity**: to be efficaciously adaptive, the internal complexity of a system must match the external complexity it confronts 10, 11\.  
To achieve this "requisite complexity", the sources suggest two main strategies:  
**1\. Complexity Reduction (The Cognitive Strategy)**This strategy aims to simplify the complexity of incoming stimuli to economise on the resources expended in responding 12, 13\. It involves using **codification and abstraction** to filter out "crude complexity" (noise) and focus exclusively on "effective complexity" (regularities) 14-16. This "cognitive route" focuses on representations of stimuli rather than the stimuli themselves, reducing the distance a system must move in the **Ashby Space** to achieve an adaptive response 17-19.  
**2\. Complexity Absorption (The Organisational Strategy)**This approach argues that complexity should be absorbed and lived with rather than merely reduced 12, 20\. It is particularly appropriate in the **complex regime**—the "melting zone" between order and chaos—where uncertainty is irreducible 16, 21, 22\. Absorption is achieved through:

* **Social Capital**: Building trust and shared values within **clans** or **adhocracies** to absorb uncertainty through mutual adjustment 23-25.  
* **Options Thinking**: Maintaining flexibility by creating and deferring the exercise of options until more information is available 26-28.  
* **Distributed Intelligence**: Harnessing the pattern-recognition skills of many agents to create a distributed processing capacity 29, 30\.

**3\. Implementing Scalable Abduction**The sources advise moving away from traditional deductive or inductive logic when dealing with **extreme outcomes** (represented by power-law distributions) 31, 32\. Instead, agents should use **scalable abduction**—an inferential engine that tracks "butterfly events" (tiny initiating events) to see how they might get amplified into extreme macroscopic outcomes 32-35. This allows for **anticipation**, which is more fluid and adaptive than precise prediction in complex environments 36-38.  
**4\. Hybrid Socio-Computational Approaches**In highly dangerous or fast-moving environments, such as counter-terrorism, the advice is to combine human agents with high-speed **parallel computing** 39-41. This "socio-computational" method uses human "neurons" to scan for weak signals and parallel processing to reduce trillions of possible patterns into an actionable few 42-44.  
**5\. Avoiding Premature Closure**A critical warning in the sources is to avoid **premature codification** or exercising options too early 45, 46\. In highly innovative or uncertain processes (like those at CERN), managers must tolerate higher levels of epistemic variety and avoid forcing "ordered" bureaucratic structures on to tasks that require exploratory "complex" regimes 21, 45, 47\. Tightening boundaries too early can stifle innovation and lead to **maladaptation or fossilisation** 48-50.  


FILE: 'Mike McMaster.md'
---
exported: '2026-01-28T11:39:22.260Z'
source: NotebookLM
type: chat
title: Mike McMaster on 💬What is Complexity
tags:
  - MC-Jackson
  - Mike-McMaster
  - What-is-complexity
author: Mike McMaster
---
### Defining Complexity

In the sources, **complexity** is distinguished from merely being "complicated." While a complicated system may have many parts, it can still be understood through reductionism (breaking it down) and linear logic\[1\],\[2\]. In contrast, complexity arises when there are too many connections and interactions to track linearly, making detailed prediction impossible\[3\].

Key characteristics of complexity include:

• **A Matter of Mind:** Complexity is described not just as a physical state, but as a "matter of mind"—a way of understanding the world. It refers to the amount of information that must be compressed to make sense of a situation\[4\],\[5\].

• **Emergence:** This is the phenomenon where interactions between elements produce new properties or results that cannot be explained by the individual parts alone\[6\],\[7\].

• **Non-Linearity and Independent Agents:** Complex systems are composed of independent agents (like people in a corporation) who make their own choices. Their interactions are non-linear, meaning small inputs can produce disproportionately large or unexpected results\[8\],\[9\].

• **The Warfield Metric:** John Warfield proposes that complexity can be measured by multiplying the number of elements by the number of interactions, and then multiplying that by the number of people involved (and their differing interpretations)\[10\].

### Advice on Dealing with Complexity

To deal with complexity effectively, the sources advise shifting from an "engineering" or "machine" model of organization to a "living systems" model\[11\],\[12\]. The goal is not to remove complexity, but to reduce it to "effective complexity"—a level where action can be taken without oversimplifying the reality\[13\],\[14\].

1\. Shift Your Thinking and Leadership Style

• **Abandon Linear Control:** You must give up the illusion of absolute control and predictability. Instead, exercise "appropriate control," similar to steering a raft down a turbulent river: you cannot control the river, but you can steer and use the flow to your advantage\[15\].

• **Manage Context, Not People:** Shift from trying to manage individuals to managing the flow of information and knowledge. If provided with the right information and conditions, intelligent agents (employees) will self-organize\[16\].

• **Use Metaphors:** Replace mechanistic metaphors (which imply parts and friction) with living system metaphors (which imply growth, adaptation, and flow) to better understand organizational dynamics\[17\].

2\. Design for Intelligence and Emergence

• **Distribute Intelligence:** Do not centralize intelligence at the top. Design the organization so that information, accountability, and knowledge are distributed throughout the system, much like a nervous system\[18\].

• **Use Simple Rules (Attractors):** Instead of rigid detailed instructions, use a few simple guiding principles or values (attractors). These allow for rich, varied, and adaptive behaviors that remain consistent with the organization's identity\[19\],\[20\].

• **Enable the Periphery:** The "core" should not control the "periphery" (where the organization meets the market). Instead, the core should support the periphery, listening to the "chaos" there as a source of vital information and innovation\[21\],\[22\].

3\. Operational Techniques for Solving Complex Problems

• **Chunking and Compression:** The human mind can typically handle only three to nine items at once. To deal with complex problems, you must "chunk" information—grouping smaller elements into larger, meaningful patterns or concepts\[23\],\[24\].

• **Use Technology for Display:** When a problem exceeds human cognitive limits (more than five elements), use computer-assisted processes to calculate and display relationships. This allows groups to see the implications of their logic without getting lost in the details\[25\],\[26\].

• **Iterative Processes:** Do not expect to solve complex problems in one go. Use an iterative process of dialogue, display, and reflection to allow a shared understanding to emerge over time\[27\],\[28\].

4\. Foster Innovation and Adaptability

• **Experimentation:** Since you cannot predict the future in a complex system, you must explore the "space of possibility" through experimentation. Take small risks to generate information and learning\[29\],\[30\].

• **Recombination:** Innovation in complex systems often comes from recombining existing "building blocks" (ideas, people, technologies) in new ways, rather than inventing something entirely from scratch\[31\],\[32\].

• **Strategic Co-operation:** In a complex, interconnected world, survival often depends on integrating with the environment. Strategies of co-operation and alliance are generally more robust than pure competition\[33\],\[34\].

---
> [!info]-
> [1] OtherWise Michael McMaster ..pdf
> [2] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
> [3] Resolving-Complex-Problems.pdf
> [4] Resolving-Complex-Problems.pdf
> [5] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
> [6] [Book] McMaster - 1996 - The intelligence advantage - Butterworth-Heinemann.pdf
> [7] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
> [8] OtherWise Michael McMaster ..pdf
> [9] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
> [10] Resolving-Complex-Problems.pdf
> [11] OtherWise Michael McMaster ..pdf
> [12] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
> [13] Resolving-Complex-Problems.pdf
> [14] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
> [15] OtherWise Michael McMaster ..pdf
> [16] McMaster - Managing in the face of uncertainty.pdf
> [17] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[18] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[19] [Book] McMaster - 1996 - The intelligence advantage - Butterworth-Heinemann.pdf
[20] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[21] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[22] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[23] Resolving-Complex-Problems.pdf
[24] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[25] Resolving-Complex-Problems.pdf
[26] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[27] Resolving-Complex-Problems.pdf
[28] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[29] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[30] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[31] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[32] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[33] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf
[34] [Book] McMaster,Knowledge Based Development Co - 1997 - The praxis equation - Knowledge Based Development Co. Ltd.pdf


FILE: 'Nassim Nicholas Taleb.md'
---
exported: 2026-02-07T20:38:27.549Z
source: NotebookLM
type: chat
title: Nassim Nicholas Taleb on 💬What is Complexity
tags:
  - What-is-complexity
  - Nicholas-Taleb
author: Nassim Nicholas Taleb
---
Based on the sources, **complexity** is fundamentally defined by the presence of **interdependencies** and **non-linear responses**, distinguishing it sharply from the merely "complicated." The sources advise dealing with complexity not through prediction or top-down control, but through **antifragility**, **subtraction (via negativa)**, and **decentralized tinkering**.

### **What is Complexity?**

Complexity is not about the number of parts in a system, but how those parts interact.

• **The Cat vs. The Washing Machine:** A washing machine is "complicated" (mechanical); it has many parts, but if you push a button, you get an exact, predictable response. A cat is "complex" (organic); it has interdependencies among its parts. If you remove a specific element from a complex system, it creates cascading side effects that are difficult to predict\[1\],\[2\].

• **Interdependence and Opacity:** In complex systems, causal links are often invisible or "opaque." You cannot understand the whole simply by analyzing the single parts\[3\],\[4\]. Because behavior in one place is coupled with behavior in another, small variations can propagate through the system (cascades), causing extreme events ("fat tails") that render standard statistical models useless\[5\].

• **Non-linearity:** Complex systems react non-linearly to stressors. This means that doubling a dose or a stressor does not yield twice the effect; it may yield significantly more (or less)\[3\]. This is often summarized by the phrase "More is different"—a city does not behave like a large village; it has entirely different dynamics\[6\].

### **Advice on Dealing with Complexity**

Because complex systems are opaque and unpredictable, the sources argue that we should abandon the attempt to predict the future and instead focus on managing **fragility** and **exposure**.

**1\. Do Not Try to Predict; Detect Fragility Instead**In the complex domain (socioeconomic life), prediction is impossible because of "Black Swans" (rare, high-impact events). However, while you cannot predict an event, you can measure how **fragile** a system is to that event\[7\],\[8\].

• **The Heuristic:** If a system suffers more than linear harm from a stressor (e.g., a 10lb stone causes more than twice the damage of a 5lb stone), it is fragile. If it benefits from volatility (up to a point), it is **antifragile**\[9\],\[10\].

**2\. Use "Via Negativa" (Subtraction over Addition)**In complex environments, intervening to "fix" things often causes unintended iatrogenics (harm done by the healer). Knowledge grows by subtraction—knowing what is wrong is more robust than knowing what is right\[11\],\[12\].

• **Action:** improving a system is best achieved by removing fragile parts or unnatural stressors (e.g., removing debt, removing regulations, stopping a medication) rather than adding new complications\[13\],\[14\]. "The simpler, the better"\[15\].

**3\. Apply the Barbell Strategy**To manage the unpredictability of complex systems, use a dual strategy that avoids the "middle."

• **The Structure:** Be hyper-conservative on one side to avoid ruin (extreme safety) and hyper-aggressive on the other to capture upside (small, limited-loss risks). For example, keeping 90% of assets in boring cash (robust) and 10% in high-risk ventures (antifragile) is safer than having 100% in "medium" risk assets, which can be wiped out by a single complex market error\[16\],\[17\],\[18\].

**4\. Respect Tinkering and Decentralization**Top-down management of complex systems (like the economy) fragilizes them by suppressing the volatility they need to remain healthy\[19\].

• **Evolutionary Approach:** Progress in complex domains comes from "tinkering" (trial and error) and bottom-up selection, not from top-down academic design\[20\]. We should allow systems to experience small, local failures (which serve as information) to prevent large, systemic collapses\[21\],\[22\].

**5\. The Non-Naive Precautionary Principle**For specific types of complex risks—those that are **systemic** (spreading globally) and **irreversible** (potential for total ruin)—you cannot use standard cost-benefit analysis.

• **The Rule:** If an action (like GMOs or releasing a virus) carries a risk of global ruin, even if the probability seems low, it must be avoided entirely. The burden of proof lies with the proponent to demonstrate safety, not the opponent to demonstrate harm\[23\],\[24\]. We must treat the risk of ruin as inevitable over time\[25\].

---
> [!info]- References
> [1] [Book] Taleb - Antifragile.pdf
> [2] [Book] Taleb - Antifragile.pdf
> [3] [Book] Taleb - Antifragile.pdf
> [4] [Book] Taleb - Antifragile.pdf
> [5] taleb - pp2.pdf
> [6] [Book] Taleb - Antifragile.pdf
> [7] [Book] Taleb - Antifragile.pdf
> [8] [Book] Taleb - Antifragile.pdf
> [9] [Book] Taleb - Antifragile.pdf
> [10] [Book] Taleb - Antifragile.pdf
> [11] [Book] Taleb - Antifragile.pdf
> [12] [Book] Taleb - Antifragile.pdf
> [13] [Book] Taleb - Antifragile.pdf
> [14] [Book] Taleb - Antifragile.pdf
> [15] [Book] Taleb - Antifragile.pdf
> [16] [Book] Taleb - Antifragile.pdf
> [17] [Book] Taleb - Antifragile.pdf
> [18] [Book] Taleb - Antifragile.pdf
> [19] [Book] Taleb - Antifragile.pdf
> [20] [Book] Taleb - Antifragile.pdf
> [21] [Book] Taleb - Antifragile.pdf
> [22] [Book] Taleb - Antifragile.pdf
> [23] taleb - pp2.pdf
> [24] taleb - pp2.pdf
> [25] taleb - pp2.pdf


FILE: 'Neil Postman.md'
---
exported: '2026-01-31T13:04:46.923Z'
source: NotebookLM
type: chat
title: Neil Postman on 💬What is Complexity
tags:
  - Neil-Postman
  - What-is-complexity
author: Neil Postman
---

In the work of Neil Postman, complexity is defined as the inherent, multifaceted, and often contradictory nature of human interactions, purposes, and the world at large\[1\]. Postman argues that while the world is naturally complex, modern communication systems—particularly television and Technopoly—strive to eliminate this complexity in favor of efficiency, entertainment, and simple-minded "either-or" certainties\[4\].

### What is Complexity?

• **A Multifaceted Social Reality:** Every "semantic environment" (a social situation governed by rules of talk) is a multifaceted situation where people have diverse roles and purposes\[2\]\[7\].

• **Layered Human Purposes:** Human motives are "exceedingly complex—multileveled and multilayered," meaning individuals rarely have a single "honest" feeling, but rather a complex of conflicting ones\[3\].

• **The Nature of Knowledge:** Knowledge is not a fixed "thing" but a stage in human development with a past and a future; it is a "battleground" of fierce intellectual struggle\[8\]\[9\].

• **Technopoly's Enemy:** In a Technopoly (a culture that deifies technology), complexity is viewed as an obstacle to be overcome by technical calculation and "scientific" management\[5\]\[6\].

### Advice on How to Deal with Complexity

Postman and his commentators offer several principles for navigating a world that tries to simplify complexity into "bits" of information or entertainment:

**1\. Adopt the Stance of a Participant-Observer**The most vital strategy is **"meta-semantics,"** which involves psychologically positioning yourself outside a situation to see it in its entirety\[10\]. Rather than just reacting to content, you should observe the **whys and hows** of the communication, focusing on the relationship between what is said and the rules of the environment\[11\].

**2\. Practice the Art of Inquiry**Postman believes that **"asking critical questions"** is the most effective way to open minds and navigate complexity\[12\]. To avoid being overwhelmed by fragmented information, one must constantly ask:

• What is the purpose of this environment?\[13\]

• Whose interest is being served by this information?\[14\]\[15\]

• What are the underlying assumptions of the questions being asked?\[16\]

**3\. Operationalize and Qualify Your Language**To deal with vague or overwhelming problems, you should restate them in **concrete, reality-oriented forms**\[17\]. Instead of asking "either-or" questions that simplify the world into two polarities (like "Is America a racist society?"), ask **"To what extent"** or **"In what manner"**\[18\]. This allows for a qualified, detailed look at a problem rather than a dogmatic one\[18\].

**4\. Acknowledge the Value of "I Don't Know"**Postman highlights that "I don't know" is perhaps the most feared sentence in the English language, but it is often the **beginning of intelligent discussion** rather than the end\[19\]\[20\]. Acknowledging ignorance is a necessary step in addressing true complexity\[20\].

**5\. Maintain "Psychic Distance" from Technology**To survive as a "loving resistance fighter," you must maintain a **psychic distance from technology** so that it always appears "strange" and never "natural" or "inevitable"\[21\]. This prevents you from blindly accepting the simplified, machine-like worldview that technology imposes on human affairs\[21\]\[22\].

**6\. Use History and Semantics as Correctives**Studying the **history of subjects** helps students understand that knowledge is a continuous human story, not a fragmented consumer product\[9\]\[23\]. Similarly, the study of **semantics** (the relationship between language and reality) helps individuals detect when language is being used to distort or oversimplify the world's complexity\[24\].

---
> [!info]- References
> [1] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [2] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [3] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [4] [Book] Postman - Amusing Ourselves to Death.pdf
> [5] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [6] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [7] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [8] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [9] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [10] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [11] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [12] Hobbs 2022 Postman's Legacy  ETC.pdf
> [13] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [14] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [15] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [16] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [17] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [18] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [19] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [20] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [21] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [22] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [23] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [24] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf


FILE: 'Niklas Luhmann.md'
---
tags:
  - Niklas-Luhmann
  - What-is-complexity
title: Niklas Luhmann on 💬What is Complexity
author: Niklas Luhmann
---
In the systems theory of Niklas Luhmann, **complexity** is defined by a specific threshold: it occurs when an interconnected collection of elements becomes so large that it is **no longer possible for every element to relate to every other element** 1-4. This structural constraint forces the system into **selectivity**, which directly implies **contingency** (the reality that things could always be otherwise) and **risk** 5-8.  
The sources provide the following insights into the nature of complexity and advice on how systems can effectively deal with it:

### The Nature of Complexity

* **The Complexity Differential:** A system is fundamentally a **difference between system and environment**; the environment is always significantly more complex than the system itself 9-12.  
* **Organised vs Unorganised Complexity:** While the world is filled with unorganised complexity (chaos), systems represent **organised complexity** because they employ selective rules to relate their elements 13-17.  
* **Temporalisation:** In social and psychic systems, elements are **events** (like communications or thoughts) that vanish as soon as they emerge 18-21. This leads to **temporalised complexity**, where the system must constantly produce new elements to avoid immediate dissolution 22-25.  
* **Lack of Information:** Complexity can be viewed as a measure of **indeterminacy** or a lack of the information required for a system to fully grasp its environment or itself 26-30.

### Advice on Dealing with Complexity

The sources suggest several strategies for managing the "overwhelming complexity" of the environment and the system’s own internal processes:

* **Complexity Reduction:** Systems must not attempt to match environmental complexity point-for-point; instead, they must **reduce complexity** by selecting only what is relevant to their own autopoiesis 9-12, 26\. Only complexity can reduce complexity; a system uses its own internal complexity to build a simplified model of its environment 31-34.  
* **Embracing Loose Coupling:** To ensure stability, systems should prefer **loose coupling** (where elements are not all strictly dependent on one another) over tight, technical couplings 35-38. Loose coupling prevents local disturbances from cascading through the entire system, providing a "safety fence" against collapse 38-40.  
* **Utilising Step Functions (Ultrastability):** Systems should handle environmental disturbances **locally** rather than globally 41-44. By interrupting internal interdependencies, a system can achieve **ultrastability**, allowing most of the system to remain stable while specific parts adapt to change 41, 43-45.  
* **Uncertainty Absorption:** In organisations, complexity is handled by communicating **results (inferences)** rather than the raw evidence or alternatives used to reach them 46, 47\. This process, termed **uncertainty absorption**, provides a secure foundation for follow-up decisions without the need to repeat every previous calculation 48-50.  
* **Binary Schematisation (Yes/No):** To maintain the speed of communication, complex meaning should be reduced to **binary choices**, such as acceptance or rejection 51-53. This simplification provides a "shortcut" that allows the autopoietic process to continue despite the "inscrutable complexity" of the world 52, 54\.  
* **Re-entry as Rationality:** **System rationality** is achieved when the system **re-enters** the distinction between system and environment into itself 55-57. By reflecting on its own "blind spot" and its difference from the world, a system can improve its **irritability and sensitivity**, transforming environmental noise into useful internal information 55, 58, 59\.  
* **Managing Size and Differentiation:** Growth in system size exponentially increases the number of internal relations 60-63. Dealing with this requires **functional differentiation**, where subsystems take on specific parts of the overall complexity, thereby relieving the pressure on the whole 64-68.



FILE: 'OU Course.md'
---
exported: 2026-02-07T20:38:57.324Z
source: NotebookLM
type: chat
title: OU Course on 💬What is Complexity
tags:
  - What-is-complexity
  - OU-Course
author: OU Course
---
### What is Complexity?

In the context of the provided materials, complexity is not merely a synonym for "complicated." It is defined both as a characteristic of a situation and as a relationship between an observer and that situation.

**1\. "Messes" vs. "Difficulties"**The most prominent definition distinguishes between **"messes"** (complex situations) and **"difficulties"** (simple or complicated problems).

• **Difficulties** are bounded, well-defined problems where the timescale is limited, priorities are clear, and a solution can be recognized (e.g., a car breakdown)\[1\],\[2\],\[3\].

• **Messes** are unbounded systems of interacting problems. They have longer, uncertain timescales, and there is often no agreement on what the problem actually is, let alone the solution\[4\],\[2\],\[5\]. Messes cannot be "solved" in the traditional sense; they must be managed\[6\],\[7\].

**2\. Perceived Complexity**Complexity is often not an intrinsic property of a thing, but **perceived complexity**—a property of the interaction between an observer and a situation\[8\],\[9\]. Complexity arises when an observer’s cognitive capacity or "mental models" are insufficient to match the variety of the situation\[8\],\[10\]. Therefore, what is complex to one person may be simple to another who has different local knowledge or experience\[11\].

**3\. "Wicked" Problems**Complex situations often exhibit the characteristics of "wicked problems," where:

• There is no definitive formulation of the problem\[12\].

• There is no "stopping rule"—you don't know when you are finished\[13\].

• Every problem is a symptom of another problem\[13\].

• There is no immediate or ultimate test of a solution\[13\].

**4\. Emergence and Interconnectedness**Complexity involves **emergence**, where the behavior of the whole cannot be predicted by analyzing the parts (e.g., the wetness of water cannot be found in hydrogen or oxygen atoms)\[14\],\[15\]. It involves non-linear relationships where small changes (like the "butterfly effect") can lead to massive, unpredictable outcomes\[16\],\[17\].

\--------------------------------------------------------------------------------

### Advice on How to Deal with Complexity

The sources advise against trying to "solve" complexity using linear, reductionist methods. Instead, you should adopt **systemic thinking** and manage the situation through learning and iteration.

**1\. Shift from "Systematic" to "Systemic" Thinking**

• **Avoid Reductionism:** Do not break the problem down into component parts to solve individually; this destroys the connections and "emergent properties" that define the complexity\[18\],\[19\].

• **Think Systemically:** Focus on relationships, context, and patterns of connection\[14\]. View the situation as a whole (holism) rather than a collection of parts\[20\].

**2\. Manage, Don't Solve**

• **Coping vs. Solving:** Accept that messes do not have clean solutions. The goal is to improve the situation or find acceptable ways of coping\[21\].

• **The Juggler Metaphor:** Effective practice requires juggling four elements simultaneously: **Being** (awareness of your own biases and ethics), **Engaging** (interacting with the real world), **Contextualizing** (choosing the right approach), and **Managing** (handling the overall performance)\[22\],\[23\],\[24\].

**3\. Use the "Soft Systems" Approach**For situations involving human behavior and conflicting worldviews (which are inherently complex), use **Soft Systems Methodology (SSM)**:

• **Rich Pictures:** Start by drawing a "Rich Picture"—a cartoon-like summary of the situation that captures structures, processes, conflict, and emotion without imposing a rigid frame too early\[25\],\[26\],\[27\].

• **Multiple Perspectives:** Acknowledge that different stakeholders have different valid perceptions of reality\[15\],\[28\].

• **Learning Cycle:** View the intervention as a never-ending cycle of learning rather than a linear path to a fixed goal\[29\],\[30\].

**4\. Iteration and "looseness"**

• **Cycle Often:** The best route is not a straight line. You must iterate—go back and refine your understanding as you learn more\[31\],\[32\].

• **Live with Looseness:** Develop the ability to "surf-board" on confusion and ambiguity. Do not rush to define the problem; staying with the uncertainty allows the real issues to emerge\[33\].

**5\. Framing and Reframing**

• **Problem Construction:** Realize that problems are not "out there" waiting to be found; they are constructed by your mind. You can often resolve a difficulty by "reframing" it—changing the label or the perspective from which you view it\[34\],\[35\],\[36\].

• **Look for Systems of Interest:** Instead of trying to model the whole world, formulate a "system of interest"—an intellectual construct used to explore the situation from a specific angle (e.g., viewing a hospital as a "healing system" vs. a "fiscal system")\[37\],\[38\].

**6\. Avoid "Hard" Tools for "Soft" Problems**Do not use "Hard Systems" approaches (mathematical modeling, optimization) or "Failures" approaches (looking for a broken part) on messy, complex situations involving human conflict. This is described as remaining on the "high ground" of technical rigour while ignoring the "swamp" of real human concerns\[39\],\[40\].

---
> [!info]- References
> [1] IERC - systems thinking for managing change.pdf
> [2] IERC - systems thinking for managing change.pdf
> [3] Managing complexity - A systems approach - Introduction.pdf
> [4] IERC - from technology push to organisational pull.pdf
> [5] Managing complexity - A systems approach - Introduction.pdf
> [6] IERC - systems thinking for managing change.pdf
> [7] Managing complexity - A systems approach - Introduction.pdf
> [8] Managing complexity - A systems approach - Introduction.pdf
> [9] Managing complexity_ a systems approach – introduction_ View as single page.pdf
> [10] OU Appendix C - Some Perspectives on Complexity.pdf
> [11] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [12] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [13] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [14] Managing complexity - A systems approach - Introduction.pdf
> [15] Managing complexity_ a systems approach – introduction_ View as single page.pdf
> [16] Managing complexity - A systems approach - Introduction.pdf
> [17] [Book] B822 - Book 1 Creativity and Perception in Management.pdf
> [18] Managing complexity - A systems approach - Introduction.pdf
> [19] Managing complexity - A systems approach - Introduction.pdf
> [20] T301 Block II - Systems Paradigms Systems Failures.pdf
> [21] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [22] Managing complexity - A systems approach - Introduction.pdf
> [23] Managing complexity_ a systems approach – introduction_ View as single page.pdf
> [24] Managing complexity_ a systems approach – introduction_ View as single page.pdf
> [25] Managing complexity - A systems approach - Introduction.pdf
> [26] Managing complexity_ a systems approach – introduction_ View as single page.pdf
> [27] T301 Block IV - Soft Systems Analysis.pdf
> [28] T301 Block IV - Soft Systems Analysis.pdf
> [29] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [30] block_4_full.pdf
> [31] IERC - systems thinking for managing change.pdf
> [32] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [33] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [34] Managing complexity - A systems approach - Introduction.pdf
> [35] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [36] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [37] Managing complexity - A systems approach - Introduction.pdf
> [38] Managing complexity_ a systems approach – introduction_ View as single page.pdf
> [39] Managing complexity - A systems approach - Introduction.pdf
> [40] OU T306 Managing Complexity Block 1.pdf


FILE: 'Patrick Hoverstadt.md'
---
tags:
  - Patrick-Hoverstadt
  - What-is-complexity
title: Patrick Hoverstadt on 💬What is Complexity
author: Patrick Hoverstadt
---
**Complexity** is defined in the sources as **variety**, specifically the **number of possible states a system can exhibit** 1, 2\. It arises from two primary factors: **structural complexity**, which is the exponential increase in interconnections as more elements are added to a network, and **dynamic complexity**, which relates to the varying rates of change and feedback loops within a system 3-5. Crucially, complexity is **purely relative to the observer**; it is the observer who decides which differences are significant enough to be distinguished as separate "states" 6, 7\.  
The sources offer several pieces of advice on how to handle complexity effectively:

### 1\. The Requirement for Explicit Models

A manager’s ability to manage any situation is in **direct proportion to the accuracy and relevance of the models** they use to understand it 8, 9\. While individuals rely on tacit models built from experience, these are often **too simple to cope with the complexity of large organisations** and can hide significant differences in perception between team members 10\. As complexity increases, organisations must adopt **explicit formal models** to facilitate shared understanding and communication 11\.

### 2\. Ashby’s Law of Requisite Variety

The fundamental principle for managing complexity is **Ashby’s Law**, which states that **"only variety can destroy variety"** 12, 13\. To maintain control, the regulatory system must be able to match the number of states (variety) the system being regulated can exhibit 14\. To achieve this balance, managers should use:

* **Attenuators:** These reduce the complexity of the environment that the organisation chooses to perceive, such as by **grouping individual customers into market segments** 15\.  
* **Amplifiers:** These boost management's response capacity, most notably by **increasing the autonomy of operational units** so they can solve their own problems locally 15, 16\.

### 3\. Structural Solutions: The Fractal Approach

The sources advise dealing with inherent complexity by **unfolding it into a fractal structure** known as the Viable System Model (VSM) 17\.

* **Self-Similarity:** Complexity is handled by designing sub-systems that have the same generic organisational characteristics as the whole, allowing **viable systems to be nested within other viable systems** 17\.  
* **The Root Structuration Theorem:** To prevent a system from becoming unstable, managers should organise it into sub-systems to **reduce the number of active interdependencies** 18, 19\. The optimal number of sub-systems is generally the **square root of the total number of elements** 19\.  
* **Process Integrity:** Switching from functional departments to **cellular structures** can reduce the number of decision permutations from billions to dozens by making the organisational structure fit the process 20, 21\.

### 4\. Navigating the "Gyre" of Thought

Dealing with complexity requires a pattern of thinking called **holism**, which involves navigating the "vertical dimension of thought" 22, 23\. Managers must be able to:

* **Climb upwards** to see the "meta-system" (the wider context) to understand a system's meaning 23, 24\.  
* **Drop downwards** into the detail to ground their thinking in reality 25\.  
* **Avoid "mental freefalling"** (uncontrolled descending into detail) by maintainting a controlled ratio of ascent to descent 25, 26\.

### 5\. Addressing "Wicked" or Cluster Problems

For complex problems involving many interdependent elements (such as nuclear waste management or climate change), the sources advise against "brute force" sequential fixes 27, 28\. Instead:

* **Parallel Processing:** Interdependent problem elements must be **tackled in parallel** by integrating different stakeholders into the decision process 28, 29\.  
* **Matching Complexity:** The structure of the decision process must be **mapped onto the structure of the problem**; if the problem is complex, the solution mechanism must be equally complex 28, 30\.

### 6\. Managing Uncertainty

In complex environments, managers should **think in ranges rather than fixed points**, as precision is often an illusion that masks risk 31\. They should also adopt a **Bayesian approach**, actively looking for evidence that their current model is **wrong** rather than just seeking confirmation that they are right 32-34.  


FILE: 'Paul Cilliers.md'
---
exported: '2026-01-27T21:26:39.759Z'
source: NotebookLM
type: chat
title: Paul Cilliers on 💬What is Complexity
tags:
  - Paul-Cilliers
  - What-is-complexity
author: Paul Cilliers
---
**Complexity** is defined not merely as a state of having many parts, but as a condition arising from the rich, non-linear interaction between components where the relationships are often more important than the components themselves. **Dealing with complexity** requires a shift away from the desire for perfect control and prediction toward an attitude of "modesty," the cultivation of diversity, the utilization of distributed control, and the acceptance of unavoidable ethical responsibility.

### Understanding Complexity versus Complicatedness

To understand complexity, one must distinguish it from the "complicated." A system like a jumbo jet is complicated: it has millions of parts, but it can be analyzed, taken apart, and described completely in terms of its components\[1\]. A complex system (such as the brain, language, or a social organization), however, is constituted by intricate, dynamic relationships. If you take it apart to analyze it, you destroy the very interactions that define it\[2\]\[3\].

Complexity is characterized by several key features:

• **Non-linearity:** Interactions are non-linear, meaning small causes can have large effects (and vice versa), and the system cannot be simplified or "compressed" into a rule-based model without losing essential information\[4\]\[5\].

• **Openness:** Complex systems interact with their environment, making it difficult to define their boundaries objectively\[6\]\[7\].

• **History and Memory:** Systems have a history that co-determines their present behavior. They are not merely reactive to the present moment but carry the past with them in a distributed memory\[8\]\[9\].

• **Emergence:** The behavior of the system emerges from local interactions between components that are often ignorant of the whole system's behavior\[10\].

### Advice on Dealing with Complexity

Because complex systems are non-linear and historically contingent, we cannot find a "master key" or a single general theory to predict or control them perfectly\[11\]\[12\]. Instead, dealing with complexity requires specific strategies and attitudes:

1\. Acknowledge the Limits of Knowledge (Modesty)

We cannot know complex things completely\[13\]\[14\]. To understand a system, we must model it, which essentially means "framing" it. This framing inevitably leaves things out (reducing complexity), and because the system is non-linear, we cannot predict the impact of what we have excluded\[4\]\[15\]. Therefore, we must adopt a "modest" position. This is not a weak position, but a responsible one that acknowledges that our models are always provisional and limited\[16\]\[17\]. We should avoid the arrogance of claiming we have the "total picture"\[18\].

2\. Embrace Diversity and Difference

Diversity is not a problem to be solved; it is a precondition for a system's survival and meaning\[19\]\[20\].

• **Law of Excess Diversity:** For a system to survive and adapt, it needs not just "requisite variety" (enough internal variety to match the environment), but "excess diversity." This excess allows the system to experiment internally and cope with novel, unforeseen features in the environment\[21\].

• **Meaning through Difference:** Identity and meaning in complex systems are generated through relationships of difference. Attempting to eradicate difference or enforce homogeneity destroys the system's ability to generate meaning and remain resilient\[20\]\[22\].

3\. Distribute Control

Complex organizations cannot thrive under rigid central control. Because single elements (like a CEO or a central processor) cannot contain the complexity of the whole system, control must be distributed throughout the system\[23\]\[24\]. However, this does not mean the organization should be structureless or chaotic. It implies that structure and control should emerge from the bottom up through local interactions rather than being imposed entirely from the top down\[25\]\[26\].

4\. Cultivate "Slowness"

Dealing with complexity requires a certain "slowness"\[27\].

• **Speed vs. Reflection:** Unreflective speed and the demand for instant efficiency can destroy a system's memory. A system must be able to resist some environmental fluctuations to distinguish between significant information and mere noise\[28\]\[29\].

• **Memory and Anticipation:** A system's ability to anticipate the future depends on the quality of its memory. Developing a rich, integrated memory takes time. Therefore, a system must change at a slower rate than its environment to maintain its identity and avoid simply mirroring the chaos around it\[22\].

5\. Accept Ethical Responsibility

Perhaps the most critical advice is that dealing with complexity is inherently ethical. Because we cannot calculate the perfect outcome of our actions (due to non-linearity and incompressibility), we are forced to make choices based on limited information\[32\]\[33\].

• **The Provisional Imperative:** We cannot hide behind rules or calculations to justify our decisions. We must take responsibility for the "cut" or the boundary we draw when we model a system or make a decision\[34\]\[35\].

• **Vigilance:** We must act, but we must remain critically aware that our actions are provisional and exclusionary. We should follow a "provisional imperative": to act while remaining cognizant of other ways of acting\[36\]. This requires irony, imagination, and a willingness to revise our judgments\[37\].

In summary, dealing with complexity means abandoning the hope for a perfect, predictive model. Instead, we should engage with the world through distributed networks, foster diversity, allow time for reflection, and accept the ethical burden of making choices amidst uncertainty\[11\]\[38\].
---

## 引用来源

[1] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
[2] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
[3] [Book] Cilliers - Critical Complexity (Categories).pdf
[4] Cilliers - boundaries hierarchies and networks in complex systems.pdf
[5] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
[6] Cilliers - boundaries hierarchies and networks in complex systems.pdf
[7] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
[8] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
[9] [Book] Cilliers - Critical Complexity (Categories).pdf
[10] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
[11] Cilliers - boundaries hierarchies and networks in complex systems.pdf
[12] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
[13] Cilliers - why we cannot know complex things completely.pdf
[14] Cilliers - why we cannot know complex things completely.pdf
[15] [Book] Cilliers - Critical Complexity (Categories).pdf
[16] Cilliers 2010 - Difference Identity and Complexity.pdf
[17] [Book] Cilliers - Critical Complexity (Categories).pdf
[18] [Book] Cilliers - Critical Complexity (Categories).pdf
[19] Cilliers 2010 - Difference Identity and Complexity.pdf
[20] Cilliers 2010 - Difference Identity and Complexity.pdf
[21] Cilliers 2010 - Difference Identity and Complexity.pdf
[22] Cilliers 2010 - Difference Identity and Complexity.pdf
[23] [Book] Cilliers - Critical Complexity (Categories).pdf
[24] [Book] Cilliers - Critical Complexity (Categories).pdf
[25] Cilliers - boundaries hierarchies and networks in complex systems.pdf
[26] Cilliers - boundaries hierarchies and networks in complex systems.pdf
[27] [Book] Cilliers - Critical Complexity (Categories).pdf
[28] [Book] Cilliers - Critical Complexity (Categories).pdf
[29] [Book] Cilliers - Critical Complexity (Categories).pdf
[32] [Book] Cilliers - Critical Complexity (Categories).pdf
[33] [Book] Cilliers - Critical Complexity (Categories).pdf
[34] [Book] Cilliers - Critical Complexity (Categories).pdf
[35] [Book] Cilliers - Critical Complexity (Categories).pdf
[36] [Book] Cilliers - Critical Complexity (Categories).pdf
[37] [Book] Cilliers - Critical Complexity (Categories).pdf
[38] [Book] Cilliers - Critical Complexity (Categories).pdf


FILE: 'Peter Checkland.md'
---
tags:
  - Peter-Checkland
  - What-is-complexity
title: Peter Checkland on 💬What is Complexity
author: Peter Checkland
---
**Complexity** in human affairs is defined as a **flux of interacting events and ideas** that unrolls through time 1, 2\. It is often described as a **"proble/matique" or a "mess,"** meaning a dynamic situation consisting of complex systems of changing, interacting problems 3-5. The sources distinguish between **situational complexity** (the number and types of elements and relations within a situation) and **cognitive complexity** (the difficulty an observer faces in understanding and interpreting those aspects) 6, 7\. In social contexts, complexity is further heightened by **multiple interacting perceptions of 'reality'** and conflicting worldviews (Weltanschauungen), as different individuals attribute different meanings to the same situation 8, 9\.  
Advice on how to deal with complexity includes the following strategies:

* **Adopt a Systems Thinking Stance:** Rather than assuming the world is a set of systems that can be "engineered", deal with complexity by treating the **process of inquiry itself as a system** 10, 11\. This shift in "systemicity" from the world to the inquiry process is the core of Soft Systems Methodology (SSM) 10, 12\.  
* **Use Visual Tools like Rich Pictures:** Because complexity involves a nexus of interacting relationships, **diagrammatic representations** are superior to linear prose for capturing the "big picture" and encouraging holistic thinking 13-15. These pictures should record elements of slow-to-change structure and continuously changing processes 16, 17\.  
* **Acknowledge Multiple Worldviews:** Effective intervention requires surfacing and explicitly declaring the **worldview** that makes a particular interpretation meaningful 18, 19\. Dealing with complexity necessitates finding **accommodations**—versions of a situation that people with conflicting views can live with—rather than seeking a single "optimum" solution 20, 21\.  
* **Move from Optimising to Learning:** In "soft," ill-structured situations, the language of "problems" and "solutions" is often too simplistic 22, 23\. Instead, complexity should be managed through a **never-ending learning cycle** where models are used to structure a debate about desirable and feasible change 24-26.  
* **Practice Conscious Reductionism:** Human beings are inherently limited in their ability to process complexity and must reduce the "abundance and richness" of reality into simpler models 27, 28\. The key is to make these **modelling choices consciously**, using them as intellectual devices to interrogate the real world rather than mistaking them for accurate descriptions of reality 27, 29\.  
* **Engage the "Tortoise Mind":** Real-world complexity cannot be grasped instantly 30\. Practitioners should allow for **sedimentation of ideas** and reflection, avoiding the "hare brained" rush for quick fixes 31, 32\.  
* **Apply Multi-level Thinking:** Systems ideas are based on **layered structures** (hierarchy) 33, 34\. Dealing with a problem at one level requires understanding the "wider system" that serves it and the "sub-systems" that constitute it 35, 36\.  
* **Adopt Incrementalism:** In turbulent environments where cause-and-effect links are obscure, it is best to proceed **experimentally and incrementally**, proceed by "trial and error," and remain "light on your feet" to adapt to changing circumstances 37-39.

Ultimately, the sources suggest that the best way to learn how to handle complexity is to **actively use a methodology like SSM**, as its principles are resilient and the necessary "craft skills" are developed through repeated practice in real-world situations 40-42.  


FILE: 'Peter Senge.md'
---
exported: 2026-02-07T20:39:18.902Z
source: NotebookLM
type: chat
title: Peter Senge on 💬What is Complexity
tags:
  - What-is-complexity
  - Peter-Senge
author: Peter Senge
---
Based on the provided texts, specifically the work of Peter Senge and his colleagues, complexity is not a single concept but must be understood by distinguishing between two distinct types: **detail complexity** and **dynamic complexity**.

**1\. The Two Types of Complexity**

• **Detail Complexity:** This exists when there are many variables to manage. It involves organizing many distinct parts, such as mixing ingredients for a stew, following complex instructions to assemble a machine, or taking inventory in a retail store\[1\]\[2\]. Conventional forecasting, planning, and analysis methods are generally designed to handle detail complexity\[2\].

• **Dynamic Complexity:** This is the far more challenging type found in management and social systems. It arises when "cause and effect are subtle, and where the effects over time of interventions are not obvious"\[2\]. In situations of dynamic complexity, the same action can have dramatically different effects in the short run versus the long run, or different consequences in one part of the system versus another\[3\].

The texts argue that the fundamental "information problem" managers face is not too little information, but too much; we are overwhelmed by detail complexity and fail to see the dynamic complexity where the real leverage lies\[4\]\[5\].

**2\. The Advice on How to Deal with Complexity**To navigate dynamic complexity effectively, the authors advise moving away from linear, "snapshot" thinking toward systems thinking.

• **Shift of Mind (Metanoia):** You must shift from seeing parts to seeing wholes, and from seeing people as helpless reactors to seeing them as active participants in shaping their reality\[6\]. This requires abandoning the linear view (A causes B) in favor of seeing **circles of causality** (feedback loops), where every influence is both a cause and an effect\[7\].

• **Identify the Underlying Structure:** Behavior in complex systems is controlled by structure. To change the behavior, you must identify the systemic structure—the key interrelationships influencing behavior over time—rather than just reacting to isolated events\[8\]\[9\].

• **Use Systems Archetypes:** Senge suggests using "Systems Archetypes" (generic structures that recur in personal and organizational life) to organize complexity into a coherent story\[10\]. By matching a situation to an archetype (such as "Shifting the Burden" or "Limits to Growth"), you can quickly identify where the high leverage for change lies\[11\].

• **Retrain the Subconscious:** The conscious mind has cognitive limitations and can only deal with a small number of variables at once (the "magic number seven plus or minus two")\[12\]. However, the subconscious mind is capable of dealing with enormous detail and dynamic complexity (e.g., driving a car in traffic or playing a Mozart sonata)\[13\]\[14\]. By mastering the language of systems thinking (loops and archetypes), you can "reprogram" the subconscious to spontaneously recognize circular patterns and feedback processes, allowing you to handle complexity more intuitively\[15\].

• **Tap into Collective Intelligence:** Because complex problems are beyond the reach of any single authority figure, you must foster **Team Learning** and **Dialogue**. This allows a group to access a "larger pool of meaning" and collective intelligence that exceeds the individual intelligence of team members\[16\]\[17\].

• **Use Microworlds for Practice:** Because the consequences of decisions in complex systems are often distant in time and space (delays), it is impossible to learn solely from direct experience\[18\]. Organizations should create "microworlds" (simulations or practice fields) that compress time and space, allowing managers to experiment with strategies and see the long-term consequences of their actions without risk\[19\]\[20\].

• **Look for Leverage:** Avoid symptomatic solutions ("quick fixes") that only address the immediate pressure. In complex systems, the highest leverage often comes from small, focused actions applied to the right place—usually involving a shift in mental models or the removal of a limiting factor rather than pushing harder on a growth factor\[21\]\[22\].

---
> [!info]- References
> [1] 2022_11_28_15_32_00.pdf
> [2] peter_senge_the_fifth_discipline1.pdf
> [3] peter_senge_the_fifth_discipline1.pdf
> [4] peter_senge_the_fifth_discipline1.pdf
> [5] peter_senge_the_fifth_discipline1.pdf
> [6] peter_senge_the_fifth_discipline1.pdf
> [7] peter_senge_the_fifth_discipline1.pdf
> [8] peter_senge_the_fifth_discipline1.pdf
> [9] peter_senge_the_fifth_discipline1.pdf
> [10] peter_senge_the_fifth_discipline1.pdf
> [11] peter_senge_the_fifth_discipline1.pdf
> [12] peter_senge_the_fifth_discipline1.pdf
> [13] peter_senge_the_fifth_discipline1.pdf
> [14] peter_senge_the_fifth_discipline1.pdf
> [15] peter_senge_the_fifth_discipline1.pdf
> [16] peter_senge_the_fifth_discipline1.pdf
> [17] peter_senge_the_fifth_discipline1.pdf
> [18] peter_senge_the_fifth_discipline1.pdf
> [19] peter_senge_the_fifth_discipline1.pdf
> [20] peter_senge_the_fifth_discipline1.pdf
> [21] 2022_11_28_15_32_00.pdf
> [22] peter_senge_the_fifth_discipline1.pdf


FILE: 'Reg Revans.md'
---
exported: 2026-02-07T20:43:43.524Z
source: NotebookLM
type: chat
title: Reg Revans on 💬What is Complexity
tags:
  - What-is-complexity
  - Reg-Revans
author: Reg Revans
---
### What is Complexity?

In the context of the provided sources, complexity is characterized by rapid change, uncertainty, and the presence of "wicked" or "intractable" problems rather than solvable puzzles.

• **Wicked Problems vs. Puzzles:** Complexity generates "wicked problems," a term originally proposed by Rittel and Webber to describe issues like drug abuse or homelessness\[1\]. These problems are difficult to describe due to "complex interdependencies" and defy rational analysis\[1\]\[2\]. They are distinct from "tame problems" or "puzzles" (such as building a hospital or solving a geometry exercise), which may be complicated but have known solutions or algorithms that experts can resolve\[2\].

• **The Precipice of Change:** Complexity is described as living on a "vertical precipice" of change, where the environment transforms so rapidly that traditional skills and past knowledge are insufficient for survival\[5\]. This state is characterized by "ignorance, risk and confusion," where the future is unpredictable\[6\].

• **Systemic Messes:** In business contexts, complex problems are sometimes referred to as "messes," which are systemic and inter-related conditions that cannot simply be solved but must be dissolved or designed out of existence\[10\].

• **Subjectivity and Values:** Complex problems do not have a single "right" course of action; different reasonable and experienced managers may advocate different approaches based on their differing value systems and past experiences\[3\].

### Advice on Dealing with Complexity

The sources unanimously point to **Action Learning** as the primary method for navigating complexity. The advice focuses on shifting from reliance on experts and past knowledge to a process of inquiry and action shared among peers.

**1\. Prioritize Questioning Insight (Q) over Programmed Knowledge (P)**While "programmed knowledge" (P)—expert advice, books, and past solutions—is sufficient for puzzles, it is inadequate for complex problems\[6\]. To deal with complexity, one must develop "questioning insight" (Q), which involves posing fresh questions into the "microcosm of uncertainty"\[6\]\[14\]. The learning equation provided is L\=P+Q, where learning (L) requires Q to be the senior partner in turbulent conditions\[12\]\[15\].

**2\. Treat the Situation as a Problem, Not a Puzzle**Leaders are advised to distinguish between puzzles (which experts can solve) and problems (which require leadership and risk-taking)\[2\]\[3\]. Attempting to solve a complex problem with expert advice alone (treating it as a puzzle) is dangerous because experts often rely on past knowledge that may no longer be relevant\[3\]\[6\]. Instead, leaders must accept personal responsibility for navigating unanswerable questions\[4\].

**3\. Engage in "Comradeship in Adversity"**Complexity should be tackled in small groups, or "sets," of peers who are also facing difficult challenges\[16\]\[17\]. This social aspect is crucial because:

• **Shared Ignorance:** Learning begins by admitting ignorance and sharing the understanding that no one knows the answer\[18\]\[19\].

• **Support and Challenge:** Peers provide the necessary support and criticism to help individuals re-interpret their past experiences and value systems, which is more effective than instruction from non-involved teachers\[20\]\[21\].

• **Fresh Questions:** Colleagues can help identify questions that a single individual might miss due to their own fixation on past experiences\[22\]\[23\].

**4\. Take Action to Learn (Adaption)**There can be no learning without action\[24\]\[25\]. In turbulent conditions, one cannot purely think their way out of a problem; one must act to generate feedback and new information\[26\]\[27\].

• **Adaption:** In rapidly changing contexts, the goal shifts from static "learning" to dynamic "adaption," where knowledge is acquired through the act of changing the environment\[28\]\[29\].

• **Action as a Catalyst:** Even acting on a superficial plan is better than inaction, as it stimulates movement and reduces the paralyzing effect of uncertainty\[30\]\[31\].

**5\. Ask Specific Diagnostic Questions**To start dealing with a complex issue, the advice is to ask three simple but profound questions to diagnose the situation:

• What are we trying to do?

• What is stopping us from doing it?

• What can we do about it?\[32\].

Additionally, when mobilizing resources, one should ask:

• Who knows about this problem?

• Who cares about it?

• Who can do something about it?\[32\]\[35\].

---
> [!info]- References
> [1] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [2] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [3] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [4] Revans 1981 Management productivity and risk - the way ahead.pdf
> [5] Revans 1981 Management productivity and risk - the way ahead.pdf
> [6] Revans 1981 Management productivity and risk - the way ahead.pdf
> [10] smith 1997 - revans action learning explained.pdf
> [12] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [14] [Book] Revans - ABC of Action Learning.pdf
> [15] smith 1997 - revans action learning explained.pdf
> [16] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [17] [Book] Revans - ABC of Action Learning.pdf
> [18] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [19] smith 1997 - revans action learning explained.pdf
> [20] [Book] Revans - ABC of Action Learning.pdf
> [21] [Book] Revans - ABC of Action Learning.pdf
> [22] [Book] Revans - ABC of Action Learning.pdf
> [23] revans 1984 - on the learning equation.pdf
> [24] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [25] [Book] Revans - ABC of Action Learning.pdf
> [26] [Book] Revans - ABC of Action Learning.pdf
> [27] [Book] Revans - ABC of Action Learning.pdf
> [28] smith 1997 - revans action learning explained.pdf
> [29] smith 1997 - revans action learning explained.pdf
> [30] smith 1997 - revans action learning explained.pdf
> [31] smith 1997 - revans action learning explained.pdf
> [32] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [35] Revans 1981 Management productivity and risk - the way ahead.pdf


FILE: 'Relational Biologists.md'
---
tags:
  - Relational-Biologists
  - What-is-complexity
title: Relational Biologists on 💬What is Complexity
author: Relational Biologists
---
In the provided sources, **complexity** is not merely a measure of how complicated a system is in terms of parts or interactions; rather, it is defined as an **intrinsic system property characterized by the necessity for multiple, non-equivalent, and irreducible descriptions** 1-3. A system is considered **complex** if it possesses **noncomputable or non-formalisable models**, meaning it cannot be fully captured by a single syntactic algorithm or simulated entirely by a Turing machine 4-7. At its core, complexity is identified by the presence of **impredicative loops or closed cycles of efficient causation**, where a system’s components participate in their own definition and production 8-11. This differs from **simple systems**, or mechanisms, which are weak in entailment and can be entirely reduced to a unique maximal description consisting of states and dynamical laws 12-15.  
The advice for dealing with complexity focuses on moving beyond traditional reductionist paradigms and adopting **complementary modes of description** 1, 16, 17\.

### Avoid Sole Reliance on Reductionism

The sources argue that reductionism—breaking a system into context-independent parts—is **generic for simple systems but fails for complex ones** because it breaks the internal causal loops that define them 18-20. Dissecting a living organism or a mind results in "rubble" that may explain how parts work individually but loses the **organisational "something more"** that constitutes life or sentience 19, 21-23. Instead of only looking downward at subsystems, researchers should look upward and outward to the **larger system context** 24, 25\.

### Adopt the Principle of Complementarity

Dealing with complexity requires accepting the **simultaneous use of formally incompatible descriptions** 1, 26, 27\. No single model can capture the global behavior of a complex system; therefore, one must use **multiple partial models** that are specific to certain levels of organization, such as the **structure-function duality** 28-31. In physics, this is seen in the need for both reversible laws and irreversible measurements 32\. In biology, this requires reconciling **rate-dependent dynamics** (material laws) with **rate-independent information** (symbolic rules) 33-36.

### Recognise Biological Relativity

The **Principle of Biological Relativity** suggests there is **no privileged level of causality** in complex systems 37-39. Advice for dealing with such systems includes:

* **Middle-out analysis:** Start at any level of interest and reach out to other levels, rather than always starting from the "bottom" (genes) or "top" (entire organism) 40, 41\.  
* **Simultaneity:** Recognise that upward and downward causation occur **simultaneously rather than sequentially** 42, 43\.  
* **A-mergence:** View high-level organization as "attractors" that take over the system rather than simply emerging from lower-level activities 43, 44\.

### Understand the Epistemic Cut and Semantic Closure

To model complexity effectively, one must identify the **epistemic cut**—the boundary that separates the "knower" (or the symbolic model) from the "known" (the material reality) 45-48. **Semantic closure** is the necessary loop where symbolic instructions (like genes) construct the very devices that must then read and interpret those same symbols 49-51. Dealing with complexity involves managing this **self-referent relation** where symbols control matter, yet matter embodies the symbols 52-54.

### Utilise Functional Simplicity

Rather than getting lost in infinite dynamical details, deal with complexity by seeking **functional simplicity** 55, 56\. This is achieved through a **selective loss of detail** or "selective neglect," allowing the system to focus on significant interactions that contribute to a collective function or goal 57-60.

### Think Ahead via Anticipatory Systems

Because living systems are **anticipatory**, their present state is guided by **internal predictive models** of the future 61-63. Advice in this context is to **"measure twice, cut once,"** acknowledging that these internal models must be vigilantly updated as the system's environment changes to avoid global failure or senescence 64-67.  


FILE: 'Robert Flood.md'
---
exported: '2026-01-27T19:51:52.071Z'
source: NotebookLM
type: chat
title: Robert Flood on 💬What is Complexity
tags:
  - Robert-Flood
  - What-is-complexity
author: Robert Flood
---

**Complexity** is broadly defined as anything found difficult to understand, arising from both the nature of "things" (objects) and "people"\[1\]\[2\]. It is not merely an intrinsic property of objects but stems from the abstractions and models humans construct of the world\[3\].

**Attributes of Complexity**Complexity is characterized by the following specific attributes:

• **Interrelatedness and Parts:** It involves systems with a high number of parts or degrees of freedom and significant interactions between them\[4\].

• **Non-linearity:** Relationships where output is not directly proportional to input, often leading to counter-intuitive behavior and instability\[5\]\[6\].

• **Asymmetry:** Systems displaying broken symmetry or differential growth, making them harder to chunk into understandable information than symmetrical systems\[7\].

• **Non-holonomic Constraints:** A state of "localized transient anarchy" where parts of a system temporarily act outside of central control or the laws of the whole\[8\].

• **Emergence:** The phenomenon where "the whole is greater than the sum of its parts," meaning a system exhibits properties (like life or consciousness) that cannot be found in its constituent components\[9\]\[10\].

• **Unknowability:** Due to the vastness of interrelationships, the totality of a complex system is inherently unknowable to the human mind; we can only have partial, local knowledge\[11\]\[12\].

Complexity can be categorized into three ranges: **organized simplicity** (few variables), **disorganized complexity** (many random variables), and **organized complexity** (rich systems like biological or social systems that are neither simple nor random)\[13\]\[14\].

\--------------------------------------------------------------------------------

**Advice on Dealing with Complexity**The sources advise moving away from reductionism (breaking things down) toward **systems thinking** (building up whole pictures)\[15\]. The advice for managing complexity is structured around matching specific methodologies to the specific type of complexity encountered.

**1\. Use Systemic Metaphors for Creative Understanding**Do not treat systems models as descriptions of reality, but as "filters" or metaphors to organize thinking\[16\].

• **Machine Metaphor:** Useful for simple, controlled tasks but ignores environment\[17\].

• **Organic Metaphor:** Focuses on survival, adaptability, and open systems\[18\].

• **Neurocybernetic (Brain) Metaphor:** Focuses on active learning, information processing, and viability\[19\].

• **Cultural and Political Metaphors:** Highlight shared beliefs or conflict and power dynamics\[20\].

**2\. Match the Methodology to the Problem Context**Using the "System of Systems Methodologies" (SOSM), one should classify the problem context based on the complexity of the _system_ (Simple vs. Complex) and the relationship between _participants_ (Unitary, Pluralist, or Coercive)\[21\]\[22\].

• **Simple-Unitary (Agreed goals, transparent systems):** Use "hard" approaches like **Systems Engineering** or **Operations Research** to optimize efficiency\[23\].

• **Complex-Unitary (Agreed goals, complex systems):** Use **System Dynamics** (to model feedback loops and structure)\[24\] or the **Viable System Model** (to diagnose organizational faults and ensure adaptability)\[25\].

• **Pluralist (Differing goals, compromise possible):** Use "soft" approaches. **Soft Systems Methodology (SSM)** facilitates debate to achieve accommodation among different worldviews\[26\]. **Strategic Assumption Surfacing and Testing (SAST)** exposes and challenges the assumptions underlying different policies\[27\]. **Interactive Planning** involves designing an idealized future to dissolve problems\[28\].

• **Coercive (Conflict, power imbalances):** Use **Critical Systems Heuristics (CSH)** to expose who benefits, who is excluded, and the sources of power/guarantees in a design\[29\]\[30\].

**3\. Employ Total Systems Intervention (TSI)**To manage the diversity of methods, use **Total Systems Intervention (TSI)**, a meta-methodology with three phases:

1\. **Creativity:** Use metaphors to highlight different aspects of the organization and its issues\[31\].

2\. **Choice:** Select the most appropriate systems methodology (e.g., SSM, VSM) based on the problem context (e.g., coercive, complex)\[32\].

3\. **Implementation:** Use the chosen methodology to generate specific proposals for change\[33\].

**4\. Adopt Critical Systems Thinking and Triple Loop Learning**Dealing with complexity requires more than just technical fixes; it requires **Critical Systems Thinking (CST)**, which emphasizes:

• **Complementarism:** Using different methodologies together rather than relying on just one\[34\].

• **Triple Loop Learning:** Asking three questions to ensure responsible management:

    1. _Are we doing things right?_ (Efficiency/Design)    2. _Are we doing the right things?_ (Purpose/Debate)    3. _Is rightness buttressed by mightiness?_ (Power/Fairness)\[35\].
**5\. Utilize Metadecisions and Abstraction**When lower-level conflicts or contradictions arise, one should use the process of **abstraction** to move to a higher **logic level** (the metalevel). A "metacontroller" can resolve conflicts, dissolve constraints, and eliminate contradictions that are unsolvable at the lower object level\[38\]\[39\]. This involves converting decisions into **metadecisions** to address the epistemological foundations of the problem\[40\].

---
> [!info]- References
> [1] Flood 1987 - Complexity a definition by construction of a conceptual framework.pdf
> [2] [Book] Flood - Dealing with Complexity An Introduction to the Theory and Application of Systems Science.pdf
> [3] Flood 1987 - Complexity a definition by construction of a conceptual framework.pdf
> [4] Flood 1987 - Complexity a definition by construction of a conceptual framework.pdf
> [5] Flood 1987 - Complexity a definition by construction of a conceptual framework.pdf
> [6] Flood 1987 - Complexity a definition by construction of a conceptual framework.pdf
> [7] Flood 1987 - Complexity a definition by construction of a conceptual framework.pdf
> [8] Flood 1987 - Complexity a definition by construction of a conceptual framework.pdf
> [9] Flood 1987 - Complexity a definition by construction of a conceptual framework.pdf
> [10] [Book] Flood - Dealing with Complexity An Introduction to the Theory and Application of Systems Science.pdf
> [11] A Maturing of Systems Thinking Evidence from Three Perspectives - Barton Emery Flood.pdf
> [12] Flood - System Thinking - Action Research.pdf
> [13] Flood 1987 - Complexity a definition by construction of a conceptual framework.pdf
> [14] [Book] Flood - Dealing with Complexity An Introduction to the Theory and Application of Systems Science.pdf
> [15] Flood - System Thinking - Action Research.pdf
> [16] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [17] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [18] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [19] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [20] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [21] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [22] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [23] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [24] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [25] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [26] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [27] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [28] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [29] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [30] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [31] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [32] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [33] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [34] I keep six honest serving men - flood.pdf
> [35] Flood 1996 - Contours of diversity managmeent and triple loop learning.pdf
> [38] [Book] Gigch - Metadecisions Rehabilitating Epistemology.pdf
> [39] [Book] Gigch - Metadecisions Rehabilitating Epistemology.pdf
> [40] [Book] Gigch - Metadecisions Rehabilitating Epistemology.pdf


FILE: 'Robert Pirsig.md'
---
tags:
  - Robert-Pirsig
  - What-is-complexity
title: Robert Pirsig on 💬What is Complexity
author: Robert Pirsig
---
Within the sources, complexity is described as **interrelated structures** in patterns and paths so enormous that no single person can understand more than a small part of them in a lifetime 1\. It can manifest intellectually as **labyrinthine fortifications** of abstract categories and sentences where the relevance of a subject is buried under excessive detail 2, 3\. In evolutionary terms, complexity represents a movement toward **greater versatility and freedom**, though in human systems, increasing complexity in a "series" rather than in parallel can lead to a higher probability of failure 4, 5\.  
Robert Pirsig provides several strategies for dealing with complexity, ranging from data management to psychological and theoretical frameworks:

### Practical Data Management

* **The Slip System:** To manage an "avalanche" of information, Pirsig recommends a **system of random access** using four-by-six index cards, or "slips" 6, 7\. Information is organised into **small chunks** that can be resequenced at will, which is more effective than rigid sequential formats that stifle growth 6, 8\.  
* **Emptying the "Tea Cup":** The purpose of these slips is to help the mind **forget ideas** rather than remember them 6\. By placing thoughts on paper, the mind remains "empty" and ready to receive new data without the interference of old thoughts 6\.  
* **Bottom-Up Organisation:** Rather than imposing a master plan, Pirsig suggests taking two slips and asking, **"Which comes first?"** 7, 9\. By repeating this process, categories and hierarchies emerge "democratically" from the data itself 7, 9\.  
* **Functional Categories:** He manages incoming complexity by sorting slips into specialized piles: **UNASSIMILATED** (for interruptions), **PROGRAM** (instructions for the work), **TOUGH** (items that do not fit yet), and **JUNK** (seemingly worthless ideas that may later "reincarnate") 10, 11\.

### Analytical and Scientific Tools

* **The Analytical Knife:** Pirsig employs an **"intellectual scalpel"** to divide a complex system into its component assemblies and its functions 12-14. This reveals the **underlying form** and allows one to build a structure of concepts known as a hierarchy or system 12, 15\.  
* **The Formal Scientific Method:** For "really tough" problems where common sense fails, he recommends the **"invincible juggernaut"** of the formal scientific method 16\. This involves keeping a **lab notebook** and breaking the problem into six exact categories: statement of the problem, hypotheses, experiments, predicted results, observed results, and conclusions 16, 17\.

### Psychological and Internal Strategies

* **Scaling Down:** When a task feels overwhelming, Pirsig advises **scaling down the scope** of the work 18\. For instance, if a whole project is frustrating, one should focus purely on a tiny immediate goal, such as cleaning a single bolt or organizing tools 18, 19\.  
* **Peace of Mind:** He asserts that **serenity is a prerequisite** for perceiving "Quality" in a complex situation; it produces right values, which in turn lead to right thoughts and actions 20, 21\.  
* **Embracing "Stuckness":** Rather than avoiding a "zero moment of consciousness" where no solution is apparent, one should cultivate it as a **"beginner's mind"** 22, 23\. Staying "stuck" allows the mind to eventually see the reality or "Quality" that will provide the solution 23, 24\.

### The Metaphysics of Quality (MOQ)

* **Discrete Levels of Value:** Pirsig resolves the complexity of many philosophical contradictions by "carving up" the world into **four discrete levels of static value**: inorganic, biological, social, and intellectual 25-27.  
* **Independence of Levels:** He notes that while higher levels are supported by lower ones, they are **discrete and often in opposition** to those below them 27, 28\. Understanding this independence helps solve puzzles like the mind-matter or free will-determinism conflicts 29-32.  
* **Replacing "Cause" with "Value":** To handle the complexity of subatomic behavior, he suggests replacing the word "cause" (implying absolute certainty) with **"value"** (implying preference) 33-35.  
* **Parallelism:** In complex organisations, he recommends **parallel structures** over serial ones, as diversity and parallelism increase the probability of success when responding to Dynamic Quality 5, 36\.



FILE: 'Roger James.md'
---
exported: '2026-02-01T00:45:46.333Z'
source: NotebookLM
type: chat
title: Roger James on 💬What is Complexity
tags:
  - Roger-James
  - What-is-complexity
author: Roger James
---

Based on the comprehensive collection of notes and writings provided in the sources, complexity is presented not merely as a "difficult" state, but as a specific zone of behavior with distinct properties, often defined by the relationship between the observer and the system. Dealing with it requires a shift from analytical "puzzle-solving" to a "craft skill" of navigation and constraint management.

Here is a synthesis of what complexity is and the advice on how to deal with it, according to the sources.

### Part 1: What is Complexity?

The sources define complexity through three primary lenses: structural positioning, observer dependence, and the role of architecture.

**1\. The "Goldilocks Zone" (The Middle Numbers)**The most consistent definition found in the texts draws on Warren Weaver and Gerald Weinberg. Complexity resides in the **"Middle Region"** or the "Goldilocks Zone" of **Organized Complexity**\[1\],\[2\],\[3\].

• **Small Numbers (Simplicity):** Systems with few variables (e.g., a pendulum). These are deterministic and handled by mechanics and analytics\[4\].

• **Large Numbers (Disorganized Complexity):** Systems with billions of variables (e.g., gas molecules). These are handled by statistics and averages; the individual doesn't matter, only the aggregate does\[4\],\[5\].

• **Middle Numbers (Organized Complexity):** Systems with too many parts to be deterministic but too interconnected to be statistical. This is the domain of systems thinking, where parts interact in non-linear ways to produce emergent behavior\[6\],\[7\].

**2\. Complexity as an Observer Phenomenon (Second-Order)**Complexity is arguably not an intrinsic property of the world, but a measure of the observer's lack of understanding\[1\].

• **The "Epistemic Cut":** A crucial distinction is made between the world as it _is_ (Ontology) and how we _think_ about it (Epistemology)\[8\],\[9\].

• **Subjectivity:** John Warfield is quoted defining complexity as "that sensation experienced in the human mind when... frustration arises from lack of comprehension of what is being explored"\[10\],\[11\].

• **The Ant on the Beach:** Citing Herbert Simon, the text notes that an ant's path looks complex to an observer, but the ant is actually following simple rules within a complex environment. The complexity is in the environment, not the ant\[12\],\[13\].

**3\. Structure and Architecture**Complexity is defined by **relationships** (verbs) rather than **things** (nouns)\[14\].

• **Architecture Dominates Material:** As systems scale, their "architecture" (the structure of relationships) becomes more important than the material they are made of. You can build a doghouse from scraps, but a cathedral requires architecture\[15\],\[16\].

• **Emergence:** This is the property where the whole exhibits behaviors that are meaningless at the level of the parts (e.g., the shape of an apple has no meaning at the level of a cell)\[17\],\[18\].

\--------------------------------------------------------------------------------

### Part 2: Advice on How to Deal with Complexity

The sources reject the idea of a single "silver bullet" method. Instead, they advocate for a "craft skill" involving specific mental shifts and practical heuristics.

1\. Change Your Question (Negative Explanation)

Instead of asking "What caused this?", you should ask: **"Why is the system doing this, rather than something else?"**\[14\],\[19\].

• **Focus on Constraints:** Following Ross Ashby and Geoffrey Vickers, the advice is to look for **constraints**—what prevents the system from doing other things\[20\],\[21\].

• **The Stone Bridge:** Understand that stability often comes from geometry and structure (the arch), not just the strength of the individual stones\[22\],\[23\].

2\. Navigate the "Ladder of Abstraction"

You cannot solve complex problems by staying solely in the "messy" real world; you must retreat to the abstract world to build models, then "land" back in reality\[24\],\[25\].

• **Use Triz:** This methodology is highlighted as a way to move from a specific problem to a general abstract problem, find a general solution, and then translate it back to a specific solution\[24\],\[26\].

• **Beware of "Splendid Nonsense":** Be careful not to confuse your abstract model with reality. Computer simulations can create "splendid nonsense" because they are not bound by physical laws unless explicitly programmed to be\[27\].

3\. Manage "Requisite Variety" (Ashby's Law)

To control a complex system, you must have enough "variety" (options/states) to match the variety of the system you are managing\[28\],\[29\].

• **Transduction:** You must filter or compress the complexity of the environment so your system can handle it. For example, a company uses "transduction" to turn complex market signals into simple internal commands\[30\],\[29\].

• **Shrink Possibilities:** Decision-making in complexity is about using knowledge to "shrink the range of possibilities to their minimum; after that, do as you please"\[31\],\[32\].

4\. Adopt a "Second-Order" Stance

Recognize that you are part of the system you are observing.

• **Appreciative Systems:** Acknowledge that your view is filtered through your values and norms (Vickers' concept)\[33\].

• **Multiple Perspectives:** Use frameworks like **SSM (Soft Systems Methodology)** to explicitly map different worldviews (CATWOE) and create a "rich picture" of the situation\[34\],\[35\]. The goal is not to find the "truth," but to facilitate a debate about change\[36\].

5\. Practical Heuristics for Intervention

• **Muddling Through:** Accept that in "Wicked Problems" (where there is no stopping rule and no right/wrong), you are often just "muddling through" or seeking "clumsy solutions" rather than perfection\[37\],\[38\].

• **Late Binding:** Delay decisions as long as possible ("late binding") to keep options open as you learn more\[39\].

• **Look for the "Strong Verbs":** Focus on the processes and relationships (verbs) rather than the static entities (nouns) to understand how the system behaves\[14\],\[30\].

• **Avoid "Analysis Paralysis":** Don't try to define the system in full detail. Specify it "only somewhat," and then "ride the dynamics of the system in the direction you want to go" (Stafford Beer)\[40\].

### Summary Guide

To deal with complexity, the author suggests you must stop trying to force the system into a "machine" metaphor (organized simplicity) or a "statistics" metaphor (disorganized complexity). Instead, you must **enter the Goldilocks zone**\[41\],\[42\] by:

1\. **Diagnosing** the structure and constraints.

2\. **Abstracting** to finding patterns (using tools like Triz or SSM).

3\. **Intervening** by managing constraints and "nudging" the system's dynamics rather than trying to rigidly control every part.

---
> [!info]- References
> [1] Perlite.pdf
> [2] Perlite.pdf
> [3] Perlite.pdf
> [4] Perlite.pdf
> [5] Perlite.pdf
> [6] Perlite.pdf
> [7] Recent.pdf
> [8] Perlite.pdf
> [9] Perlite.pdf
> [10] Perlite.pdf
> [11] Recent.pdf
> [12] Perlite.pdf
> [13] Recent.pdf
> [14] Perlite.pdf
> [15] Perlite.pdf
> [16] Recent.pdf
> [17] Perlite.pdf
> [18] Recent.pdf
> [19] Recent.pdf
> [20] Perlite.pdf
> [21] Perlite.pdf
> [22] Perlite.pdf
> [23] Recent.pdf
> [24] Perlite.pdf
> [25] Recent.pdf
> [26] Recent.pdf
> [27] Perlite.pdf
> [28] Perlite.pdf
> [29] Perlite.pdf
> [30] Perlite.pdf
> [31] Perlite.pdf
> [32] Recent.pdf
> [33] Perlite.pdf
> [34] Perlite.pdf
> [35] Recent.pdf
> [36] Recent.pdf
> [37] Perlite.pdf
> [38] Recent.pdf
> [39] Recent.pdf
> [40] Recent.pdf
> [41] Perlite.pdf
> [42] Recent.pdf


FILE: 'Ross Ashby.md'
---
exported: 2026-02-07T20:39:43.438Z
source: NotebookLM
type: chat
title: Ross Ashby on 💬What is Complexity
tags:
  - What-is-complexity
  - Ross-Ashby
author: Ross Ashby
---
Based on the provided sources, particularly the works of W. Ross Ashby, **complexity** is defined not as an intrinsic property of an object, but as a quantity of information required to describe a system relative to an observer. Dealing with complexity requires specific strategies grounded in cybernetics, primarily the management of "variety" (the number of possible states) and the exploitation of constraints.

### **What is Complexity?**

**1\. Observer-Dependence**Ashby argues that complexity is not absolute. An object (like a bicycle or a brain) contains an infinity of variables. A "system" is defined only when an observer selects a specific set of variables to study\[1\],\[2\]. Therefore, complexity is a measure of the relationship between the observer and the system.

• **Example:** To a neurophysiologist, a sheep's brain is incredibly complex (requiring vast information to describe). To a butcher, the same object is simple (distinguished from only ~30 other meats), requiring only about 5 bits of information\[3\],\[4\].

**2\. Complexity as Variety**Complexity is measured by **variety**: the number of distinct elements or states that can be distinguished\[5\],\[6\]. High complexity means high variety.

• **Interaction:** Complexity arises when parts of a system are not independent. If parts do not interact, the system is "reducible" and simple. Complexity (derived from the Latin _plexus_, meaning interwoven) exists when elements are difficult to separate because they co-determine each other's futures\[7\].

• **Bremermann’s Limit:** There is a physical limit to the amount of information any matter can process (1047 bits/gram/sec). Problems involving combinatorial complexity (like examining all possibilities in a chess game) often exceed this limit, becoming "transcomputable"\[8\],\[9\],\[10\].

**3\. Balance of Order and Chaos**From a broader cybernetic perspective, complexity can be defined as the multiplication of emergence (creation of novel information) and self-organization (increase in order). Complexity is highest when there is a balance between extreme order (predictability) and extreme chaos (unpredictability)\[11\].

\--------------------------------------------------------------------------------

### **Advice on How to Deal with Complexity**

Ashby and his commentators provide rigorous strategies for managing systems that exceed our capacity to analyze in full detail.

**1\. Apply the Law of Requisite Variety**

This is the central theorem for dealing with complexity. It states: **"Only variety can destroy variety"**\[12\],\[13\].

• **The Principle:** To successfully regulate or control a complex system (keep essential variables stable), the regulator must possess a variety of actions at least equal to the variety of disturbances generated by the system/environment\[14\],\[15\],\[16\].

• **The Advice:** If you are losing control, you must either:

    1. **Increase your Variety:** Amplify your regulatory power (e.g., hire more staff, use computers, build better sensors)\[17\],\[18\].    2. **Decrease the System's Variety:** Filter the disturbances or reduce the goal's ambition so fewer outcomes are considered "errors"\[19\],\[20\].

**2\. Abandon "Understanding" for "Control"**

When a system exceeds the information-processing capacity of the observer (transcending Bremermann's limit), it is impossible to have a complete model of it in one's head\[21\],\[22\].

• **Operational Research Strategy:** Do not attempt to understand the internal mechanism of the "Black Box." Instead, focus purely on the practical aim of control (e.g., "Did the profits go up?"). Collect only the information necessary for the job, not knowledge for truth's sake\[23\],\[24\].

**3\. Simplify through "System" Definition**

Because the "real" object is infinitely complex, you must simplify it to deal with it.

• **Select Variables Carefully:** Do not try to study "the dog"; study a specific list of variables (e.g., tail position, ear position) relevant to your specific question\[1\],\[25\].

• **Homomorphism:** Group distinguishable states together if the distinction doesn't matter for your goal. This reduces the variety you must handle while retaining the determinate nature of the machine\[26\],\[27\].

**4\. Search for Constraints**

Complex systems are rarely fully chaotic; they exhibit **constraints** (patterns where variables do not move independently). Finding a constraint reduces the variety one must deal with\[28\],\[29\].

• **Constraint Analysis:** Use methods to detect if a complex whole is actually composed of simpler, independent sub-systems (reducibility). If variables A and B do not affect C, you can ignore them when regulating C\[30\],\[31\].

• **Design Strategy:** When designing a complex system, do not leave connections to chance. Use constraints (design rules) to limit the search space for solutions\[32\],\[33\].

**5\. Use Goal-Directed Selection**

When searching for a solution in a complex space, do not use blind trial-and-error (which is too slow for complex systems).

• **The Postulate:** Use all available knowledge to narrow the field of possibilities _before_ trial-and-error begins. Then, within the remaining "field of ignorance," random selection is as good as any other method\[34\],\[35\].

• **Design as Selection:** View design and intelligence as processes of selecting the appropriate response from a set of possibilities. Intelligence is the power of "appropriate selection"\[36\],\[37\].

**6\. Model-Making is Compulsory**

The **Conant-Ashby Theorem** proves that "Every good regulator of a system must be a model of that system"\[38\],\[39\],\[40\]. To control a complex environment efficiently, you must internalize its structure. If you are successful, you have (implicitly or explicitly) built a model of it.

### **Summary Checklist for the Investigator**

• **Don't panic over size;** look for the constraints (the hidden simplicities)\[41\].

• **Define your "system"** by picking only relevant variables; ignore the rest\[1\].

• **Match variety with variety;** you cannot control a complex system with a simple regulator unless you filter the complexity\[12\],\[13\].

• **Treat unknown systems as "Black Boxes";** manipulate inputs and observe outputs to deduce behavior without opening the box\[42\].

---
> [!info]- References
> [1] Ashby Mechanisms.pdf
> [2] [Book] Ashby - An Introduction to Cybernetics.pdf
> [3] Ashby Mechanisms.pdf
> [4] Klir - Ashby Foreword.pdf
> [5] Ashby - Requisite Variety and its implications for the Control of Complex Systems.pdf
> [6] the great ashby - casti.pdf
> [7] 1409.7475 complexity Ashby autopiosis.pdf
> [8] Ashby Mechanisms.pdf
> [9] Transcomputability - ashby and epistemic processes.pdf
> [10] ashby ross .pdf
> [11] 1409.7475 complexity Ashby autopiosis.pdf
> [12] Ashby - Regulation in Biological Systems.pdf
> [13] the great ashby - casti.pdf
> [14] Ashby - Regulation in Biological Systems.pdf
> [15] Ashby Mechanisms.pdf
> [16] ashby ross .pdf
> [17] 2004 Umpleby - Ashby general theory of adaptive systems.pdf
> [18] Ashby - Regulation in Biological Systems.pdf
> [19] 2004 Umpleby - Ashby general theory of adaptive systems.pdf
> [20] Ashby - Requisite Variety and its implications for the Control of Complex Systems.pdf
> [21] Ashby - Requisite Variety and its implications for the Control of Complex Systems.pdf
> [22] Ashby 1991 - Requisite Variety and Its Implications for the Control of Complex Systems.pdf
> [23] Ashby - Requisite Variety and its implications for the Control of Complex Systems.pdf
> [24] Ashby Mechanisms.pdf
> [25] [Book] Ashby - An Introduction to Cybernetics.pdf
> [26] [Book] Ashby - An Introduction to Cybernetics.pdf
> [27] [Book] Ashby - Introduction to Cybernetics.pdf
> [28] Ashby Mechanisms.pdf
> [29] [Book] Ashby - An Introduction to Cybernetics.pdf
> [30] Ashby Mechanisms.pdf
> [31] conant1991.pdf
> [32] Ashby Mechanisms.pdf
> [33] Ashby-Mechanisms_of_intelligence_ocr.pdf
> [34] Ashby Mechanisms.pdf
> [35] Ashby-Mechanisms_of_intelligence_ocr.pdf
> [36] 2004 Umpleby - Ashby general theory of adaptive systems.pdf
> [37] Ashby Mechanisms.pdf
> [38] A_Primer_For_Conant_And_Ashby_s_Good-Regulator_Theorem.pdf
> [39] Ashby Mechanisms.pdf
> [40] Ashby-Mechanisms_of_intelligence_ocr.pdf
> [41] A_Primer_For_Conant_And_Ashby_s_Good-Regulator_Theorem.pdf
> [42] Ashby 1991 - Facets of Systems Science.pdf


FILE: 'Russ Ackoff.md'
---
tags:
  - Russ-Ackoff
  - What-is-complexity
title: Russ Ackoff on 💬What is Complexity
author: Russ Ackoff
---
**Complexity** is frequently described not as an inherent property of problems, but as a property of the **individuals facing them**; as **familiarity** with a situation increases, the perceived complexity tends to decrease 1-3. A central characteristic of complexity is its relationship to **change**; as the rate of technological and social change accelerates, the problems we face become increasingly complex, often outlasting the relevance of their solutions 4-6. In a technical sense, complexity is also indicated by the **number of variables** required for an explanation; the less we understand a system, the more variables we need to explain its behaviour 7-9.  
In the sources, complexity is often manifested as a **"mess"**, defined as a system of **interrelated threats and opportunities** 10-13. Because these problems are part of a system, they cannot be effectively treated in isolation 14-16.  
The sources offer the following advice on **how to deal with complexity**:

* **Adopt a Systemic, Holistic View:** Avoid the traditional analytical impulse to **"cut problems down to size"** by breaking them into independent parts 17-19. This "simple-minded" simplification often misses the **interactions between parts**, which are more critical to a system's performance than the actions of the parts taken separately 20-23.  
* **Dissolve Rather Than Solve:** While "solving" a problem involves finding the best possible outcome within a given model, **"dissolving"** a problem involves **redesigning the system** or its environment so that the problem is removed entirely 24-27. Dissolution is considered the highest-value method for treating a "mess" 21, 28\.  
* **Utilise Interdisciplinary Teams:** Complexity is best managed by bringing together people with a **variety of backgrounds and perspectives** 17, 29-31. This prevents the situation from being pigeonholed into a single **disciplinary domain** (like "marketing" or "production") and reveals a wider range of **controllable variables** 32-35.  
* **Engage in Idealized Design:** This involves designing the system one would have right now if it were free of all constraints except **technological feasibility** and **operational viability** 36-39. By assuming the current system was "destroyed last night," designers can focus on what they **ideally want** rather than just what they want to get rid of 40-43.  
* **Plan Backward from the Ideal:** Complexity is significantly reduced by **working backward** from a desired ideal destination to the present state 40, 44-46. This approach simplifies the planning process by limiting the number of alternatives considered and preventing the erection of **imaginary obstacles** 42, 44, 47\.  
* **Foster Flexibility and Adaptability:** Because complex environments are turbulent, organizations must be **flexible** enough to change and bend rules when necessary 48-51. This requires a **management system** capable of continuous **learning and adaptation**, which monitors decisions to detect and correct mistakes 52-55.  
* **Focus on Understanding and Wisdom:** Information and knowledge contribute to efficiency (doing things right), but dealing with complexity requires **understanding** (knowing why things happen) and **wisdom** (the ability to perceive long-run consequences and do the right thing) 56-59.



FILE: 'Stafford Beer.md'
---
tags:
  - Stafford-Beer
  - What-is-complexity
title: Stafford Beer on 💬What is Complexity
author: Stafford Beer
---
In the work of Stafford Beer, complexity is defined as **variety**, which is the technical measure of the **number of possible states** a system can exhibit 1-5. Complexity is considered the "very stuff" of the modern world, arising from the relentless pace of change and the massive interconnectedness of social and technological systems 6-8. Beer argues that "exceedingly complex systems," such as the human brain or the national economy, are effectively **unknowable in detail** and can never be fully dominated by traditional reductionist knowledge 9-11.  
Beer’s advice on how to deal with complexity centers on several cybernetic principles:

### 1\. The Law of Requisite Variety

The fundamental rule for managing complexity is **Ashby’s Law**, which states that **"only variety can absorb variety"** 12-15. To successfully regulate or control a complex system, the controller must be able to generate at least as much variety as the system it is attempting to manage 16-18. If the regulator lacks this "requisite variety," the system will inevitably become unregulated or fall into chaos 18, 19\.

### 2\. Variety Engineering

Beer suggests dealing with complexity through **variety engineering**, the deliberate design of **amplifiers and attenuators** to balance the variety equation 12, 18, 20, 21\.

* **Variety Attenuation:** This involves **filtering out** or reducing the variety of the environment or operation so it matches the capacity of the manager 22-24. Examples include management by exception, rules, and classifications that ignore irrelevant data 25-28.  
* **Variety Amplification:** This involves **enhancing the variety** of the regulator 29-31. This can be achieved through technology, such as using computers as variety generators, or by delegating tasks to autonomous teams 32-35.

Beer’s **First Principle of Organisation** states that these varieties—managerial, operational, and environmental—will naturally tend to equate, and they should be designed to do so with minimal damage to people 21, 36\.

### 3\. The Viable System Model (VSM) and Recursion

Beer advises using the **Viable System Model** as a scientific blueprint for designing **learning, adaptive, and evolving** organisations 37-39. A core concept of the VSM is **recursion**, which posits that any viable system is nested within another viable system, like a set of **Russian dolls** 40-44. This allows complexity to be managed at the appropriate level, preserving local **autonomy** while ensuring the cohesion of the whole system 45-47.

### 4\. The Black Box Approach

When faced with systems that are too complex to fathom in detail, Beer suggests treating them as **"black boxes"** 11, 37, 48\. His primary advice is that it is **not necessary to enter the box** to understand its function; instead, a manager should define the system by its **behaviour and output** ("the purpose of a system is what it does") 37, 49-51. Control is achieved by **manipulating inputs** and observing outputs to Establish a stable balance 50, 52, 53\.

### 5\. Heuristics over Algorithms

Beer advocates for the use of **heuristics**—general sets of instructions for reaching an unknown goal through exploration—rather than rigid algorithms 54-56. Dealing with "unthinkable" systems requires riding the **dynamics of the system** in a general direction rather than attempting to specify every possible state or rule in advance 54, 57\.

### 6\. Team Syntegrity

For handling the complexity of human interaction and decision-making, Beer developed **Team Syntegrity** 58, 59\. This is a **non-hierarchical process** based on the geometry of the icosahedron, designed to allow information to "reverberate" through a group, creating a **group consciousness** that can resolve highly complex issues synergetically 60-62.  


FILE: 'TOC.md'
---
tags:
  - TOC
  - What-is-complexity
title: TOC on 💬What is Complexity
author: TOC
---
> [!question] What is complexity and what is the advice in how to deal with complexity

```dataview
LIST
WHERE file.folder = this.file.folder
AND file.name != this.file.name
SORT file.name ASC
```


- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Alicia Juarrero]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Barry Richmond]]
- [[Mastering_The_Muddle/Debug/extras-What_Is_Complexity/Bob Wiliams]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/C. West Churchman]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Claude Shannon]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Colin Eden]]
- [[Conflict - Colin Eden]]
- [[Conflict - Dave Snowden]]
- [[Conflict - Gregory Bateson]]
- [[Conflict - James Wilk]]
- [[Conflict - Max Boisot]]
- [[Conflict - MC Jackson]]
- [[Conflict - Niklas Luhmann]]
- [[Conflict - Peter Checkland]]
- [[Conflict - James Ladyman]]
- [[Conflict - Robert Pirsig]]
- [[Conflict - Tim Allen]]
- [[Conflict - TOG]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Dave Snowden]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/David L Abel]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Dee Hock]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Donella Meadows]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Geoffrey Vickers]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/George Lakoff]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Gregory Bateson]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Herb Simon]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Horst Rittel]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Humberto Maturana]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Ian Mitroff]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/James Wilk]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/John Warfield]]
- [[Master Index]]
- [[Mastering_The_Muddle/Debug/extras-What_Is_Complexity/Mastering the Muddle - Systemic Perspectives on Complexity Management]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Max Boisot]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/MC Jackson]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Mike McMaster]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/MOM]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Neil Postman]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Niklas Luhmann]]
- [[Mastering_The_Muddle/Debug/extras-What_Is_Complexity/OU Course Old]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Patrick Hoverstadt]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Paul Cilliers]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Peter Checkland]]
- [[Mastering_The_Muddle/Debug/extras-What_Is_Complexity/James Ladyman and Ross Ashby]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Relational Biologists]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Robert Flood]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Robert Pirsig]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Russ Ackoff]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Stafford Beer]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Theory of Constraints]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/Tim Allen]]
- [[../💬People Dynamics/TOC]]
- [[Mastering_The_Muddle/💬QSets/💬What is Complexity/TOG]]
- [[Trizold]]

FILE: 'TOG.md'
---
tags:
  - TOG
  - What-is-complexity
title: TOG on 💬What is Complexity
author: TOG
---
### Understanding Complexity

Complexity is primarily defined as an **observer phenomenon**; it is a designation given by an observer based on their framing of a situation and their ability to recognise patterns 1, 2\. It often manifests as a "muddle" that requires significant structure and clarity before it can be thought about usefully 3\. In terms of systems science, **organised complexity** is viewed as the "white space" of uncertainty existing between **organised simplicity** (individual mechanics) and **disorganised complexity** (aggregate statistical mechanics) 4\.  
Furthermore, complexity is rooted in the reality that **"history matters,"** meaning that organisations are often constrained by historic assets, infrastructure, and geography that serve as the unavoidable starting position 5\. From a logical perspective, complexity implies that **"truth outruns provability"**—complex socio-technical systems routinely exceed the representational capacity of any single method or formal model 6, 7\.

### Advice on How to Deal with Complexity

The sources provide several strategic principles for practitioners navigating complex environments:

* **Avoid "boiling the ocean"**: Do not attempt to understand or control the total complexity of a system 8, 9\. Instead, focus on **minimalist interventions** or **"strategic nudges"**—identifying the minimal changes necessary to achieve a maximum intended impact 8, 10, 11\.  
* **Prioritise orientation over analysis**: Before attempting diagnosis or analysis, practitioners must determine "which way is up" 12, 13\. This requires establishing the **scale and boundaries** of the intervention and engaging in a mental process to decide what to use and **what to discard** 13\.  
* **Master the art of ignoring variables**: A hallmark of mastery is the **"essential selection step"**—knowing what to leave out of a model 14, 15\. By removing variability from specific levels, practitioners can coalesce many complex variables into the **few they can actually deal with** 16, 17\.  
* **Use the "Italian Flag" model to navigate uncertainty**: Categorise information into **Green** (settled positive evidence), **Red** (known negative or counter-purposeful factors), and **White** (the intermediate region of uncertainty) 4, 18-20. The goal is to **"manage the journey to green"** by doing the work required to move elements out of the white space and into verified utility 18, 21\.  
* **Reject "silver bullet" methodologies**: Avoid letting any single methodology determine how you think or define a solution 17, 20\. Practitioners should recognise that **stasis is an illusion** and maintain a **"forever contingent" stance**, perpetually adapting their approach as emergent dynamics unfold 6, 19, 22, 23\.  
* **Adopt an "ambidextrous" epistemic stance**: Be prepared to switch between different "epistemic stacks," such as viewing a system through its **individual parts** (Left-to-Right thinking) and its **aggregate behaviours** or statistical mechanics (Right-to-Left thinking) 24, 25\.  
* **Focus on interactions rather than relationships**: Shift the perspective from static relationships to fluid **interactions and recursion** to avoid the destructive dichotomies found in traditional linear thinking 26, 27\.  
* **Start with "constitutive rules"**: Instead of relying on pre-existing regulative rules, use **constitutive rules** (X counts as Y in context C) to create the activity and functions necessary to address the specific problem context 28\.



FILE: 'Theory of Constraints.md'
---
tags:
  - Theory-of-Constraints
  - What-is-complexity
title: Theory of Constraints on 💬What is Complexity
author: Theory of Constraints
---
In the context of organisational and management theory, **complexity** is defined not by the number of components within a system, but by its **"degrees of freedom"**—the number of independent variables that must be managed to control the whole 1\. A system with many independent, non-interacting parts is highly complex because each part must be controlled individually 2\. Conversely, a system where parts are highly interdependent and synchronised has fewer degrees of freedom and is, therefore, less complex to manage 1, 2\. Complexity grows daily as communication and technology make world elements more interactive and dynamic 3, 4\.  
The following advice is provided to help organisations and individuals deal with complexity:

### 1\. Shift from Analysis to Synthesis

Traditional **analysis** attempts to deal with complexity by breaking a situation into manageable "bites" and addressing them in isolation 5\. This often fails in human or organic systems because the **whole is not equal to the sum of its parts**; if every part is maximised individually, the system as a whole will not be at its best 6, 7\. Instead, you should use **synthesis**—an integrated perspective that studies the **functional interactions** and linkages between components to understand how the system functions as a unitary whole 8-10.

### 2\. Identify and Focus on the System Constraint

Complexity is simplified by recognizing that a system is analogous to a **chain** 11\. Its performance is dictated by its **weakest link**, or constraint 12, 13\. Advice for dealing with complexity includes:

* **Focusing on the "Critical Few":** Rather than trying to improve everything, focus exclusively on the constraint (the **"Archimedes Point"**), where a measured amount of effort produces a disproportionate benefit 14-16.  
* **Ignoring the "Trivial Many":** Improvements made to non-constraints are "mirages" that do nothing for the overall system and actually waste resources 17, 18\.  
* **The Five Focusing Steps:** Utilise a structured process to **Identify, Exploit, Subordinate, and Elevate** the constraint, while being wary of inertia when the constraint shifts 19-21.

### 3\. Use the Logical Thinking Process (LTP)

The LTP provides a set of logic trees to model complex functional interactions and provide a **"destination finder"** for systems 22, 23\.

* **Intermediate Objectives (IO) Maps** help establish a clear goal and critical success factors to serve as a benchmark for performance 24, 25\.  
* **Current Reality Trees (CRT)** trace visible problems back to their **hidden root causes**, revealing the few key issues that must be changed to eliminate the gap between current reality and the desired goal 26-28.  
* **Future Reality Trees (FRT)** act as a simulation model to "bench test" solutions and identify unintended consequences (negative branches) before they occur 29-31.

### 4\. Achieve Agility through the OODA Loop

To cope with the **uncertainty and volatility** inherent in complex environments, you should adopt John Boyd’s **OODA loop** (Observe-Orient-Decide-Act) 32, 33\. By cycling through this process faster than your opponents, you can gain the initiative and drive your competitors into confusion 34\. This requires **delegation** and a shift from authoritarian control to **mutual trust (einheit)**, allowing subordinate elements to act independently based on the "commander’s intent" 35-37.

### 5\. Utilise "Destructive Deduction" and "Creative Induction"

To survive in a changing environment, you must be able to destroy old mental patterns and create new ones 38\. Dealing with disorder requires:

* **Destructive Deduction:** Breaking down pre-existing concepts into their constituent "bits and pieces" 39, 40\.  
* **Creative Induction:** Looking for new common qualities or connecting threads to synthesise those bits into a higher, broader concept that better matches reality 40, 41\. This allows you to diminish disorder by creating more general concepts to represent and manage the complex world 41\.



FILE: 'Tim Allen.md'
---
tags:
  - Tim-Allen
  - What-is-complexity
title: Tim Allen on 💬What is Complexity
author: Tim Allen
---
In the study of systems, **complexity** is not considered a material property of the external world but is instead defined as an **epistemological condition** arising from the relationship between an observer and a phenomenon 1, 2, 3\. The sources provide two primary frameworks for defining complexity and a comprehensive set of strategies for managing it.

### What is Complexity?

The sources distinguish between two major conceptualisations of complexity:

* **Rosennean Complexity:** Robert Rosen defines a system as complex if it cannot be fully captured by a formal model 4, 5, 1\. In this view, complexity is an **all-or-nothing proposition**; a system is either simple (simulable by a computer without semantics) or complex (requiring semantics to handle uncertainty and contradiction) 4, 6, 7\.  
* **Tainter’s Social Complexity:** Joseph Tainter defines complexity structurally as the **differentiation in social roles and institutions** combined with the organizational constraints required to bind those parts together 3, 8, 9, 10\. Within this framework, complexity can exist in **degrees** and is primarily used as a tool for problem-solving 11, 2, 12\.  
* **Complexity vs. Complicatedness:** A system is merely **complicated** if it has many parts but remains predictable and simulable within a single level of control 13, 14\. **Complexity** emerges when organization removes degrees of freedom from the parts, often creating unpredictable or non-linear outcomes 15, 16, 9\.

### Advice on How to Deal with Complexity

Dealing with complexity requires moving beyond traditional reductionism toward more integrative, reflexive methods.

#### 1\. Use Narrative as the Primary Tool

Because models must be internally consistent, they often fail when faced with the inherent contradictions of a complex system 17, 18, 19\. **Narrative** is the most robust device for handling complexity because it can **stably juxtapose incommensurable or contradictory components** 17, 18, 19\.

* **Advice:** Use models to improve the **quality of your narrative** rather than treating the model as the ultimate product 20, 21\. Narratives facilitate "commensurate experience," allowing diverse stakeholders to agree on a shared story even if their individual models conflict 22, 23, 24\.

#### 2\. Apply the Triadic Structure of Levels

To describe a complex system adequately, one must address at least **three adjacent levels** simultaneously 25, 26, 27\.

* **Focal Level ($N$):** The level where the phenomenon resides 26\.  
* **Lower Level ($N-1$):** Provides the **mechanisms** or the "how" of the system 26\.  
* **Upper Level ($N+1$):** Provides the **context**, role, or "why" of the system 26\.  
* **Advice:** Treat slow behaviours at higher levels as constants and fast behaviours at lower levels as averages to make the dynamics of the focal level observable 28, 29\.

#### 3\. Manage the Context, Not the Parts

Sustainable management in complex systems is achieved by **managing from the context** rather than by direct intervention in specific parts 30, 31\.

* **Advice:** Successful management is the act of **replacing or subsidising a missing context** 30\. If the context is correctly provided, the system will self-organize and "take care of itself" 32, 30\.

#### 4\. Adopt Adaptive Management and Reframing

Since complex systems are "informationally open" and constantly "becoming," problem-solving is an iterative process that is never truly finished 33, 34, 35\.

* **Advice:** Use **Adaptive Management** by cycling between the observer’s model (the "map") and the material happenings of the system (the "territory") 36, 37, 38\. When a model fails, you must **reframe the problem**—change the level of analysis or the story you are telling—rather than simply collecting more data 39, 40, 41, 42\.

#### 5\. Account for the Economic Burden

Complexity is a problem-solving strategy that carries an **increasing metabolic cost** in energy, time, and resources 43, 44, 45\.

* **Advice:** Be aware of **diminishing returns**; as a system becomes more complex to solve problems, each extra unit of effort yields less benefit 46, 47, 48\. Success in dealing with complexity consists of **"staying in the game"** through continuous adjustment and learning rather than aiming for a static final state 49, 50\.



FILE: 'Triz.md'
---
exported: 2026-02-07T20:40:07.237Z
source: NotebookLM
type: chat
title: Triz on 💬What is Complexity
tags:
  - What-is-complexity
  - Triz
author: Triz
---
Based on the provided sources, **complexity** is defined not just as a state of having many parts, but as a specific characteristic of systems and problems that involves the expenditure of resources, the presence of contradictions, and the difficulty of creation or control.

Here is the breakdown of what complexity is and the specific advice on how to deal with it according to the texts.

### **What is Complexity?**

**1\. The Resource Expenditure Definition (Physical View)**From the perspective of the Bartini LT-system and physical effects, complexity is quantifiable.

• **Numerical Complexity (NC):** Complexity is defined numerically based on the transfer matrix of a physical effect. The "Complexity Number" (NC) reflects the expenditures of spatial and temporal resources required to transform an input action into an output action\[1\].

• **Formula:**NC\=∣m∣+∣n∣, where m and n represent the dimensions of Length and Time in the transfer matrix\[1\].

**2\. The Contradiction Definition (Problem-Solving View)**In Triz, complexity distinguishes a "standard" problem from an "inventive" problem.

• **Simple vs. Complex Problems:** A simple problem can be solved with existing knowledge or compromise. A **complex problem** contains a **Technical Contradiction**—a situation where improving one parameter inevitably worsens another\[2\],\[3\].

• **Hidden Conflicts:** Complexity arises when the physics of the phenomena are unclear, or when the specific element causing the conflict is not identified\[4\].

• **Software Complexity:** In IT, complexity is explicitly defined as a parameter involving the relative difficulty of creating a system or the number of components required for control and measurement\[5\].

**3\. The System Architecture Definition (Evolutionary View)**

• **Hierarchy:** Complexity increases through the recursive arrangement of systems into sub-systems (hierarchy) and the combination of effects into "effect chains" to perform complex functions\[6\],\[7\],\[8\].

• **Big Data:** In modern environments, complexity is driven by "complex big data environments" which increase the cost of decision-making\[9\].

\--------------------------------------------------------------------------------

### **Advice: How to Deal with Complexity**

The sources reject the idea of managing complexity by simply adding more resources or making compromises. Instead, they propose a **"Technology for Innovation"** that reduces complexity through rigor, abstraction, and simplification.

**1\. Simplify via "Trimming" (Reduction)**

The most direct advice for dealing with system complexity is to remove it while keeping the utility.

• **The Trimming Method:** This is a design simplification strategy. You must identify components that are problematic (high cost or harmful functions) and **remove** them. Their useful functions must then be redistributed to the remaining components or the super-system\[10\],\[11\].

• **Ideal Final Result (IFR):** Aim for the ideal system, which is one that performs its functions but _does not exist_ (has no mass, volume, or cost)\[12\],\[13\].

**2\. Objectify via Mathematical Modeling (LT-System)**

To deal with the subjective complexity of inventive problems, you should move from verbal logic to physical/mathematical logic.

• **Use the LT-Matrix:** Instead of brainstorming, map the problem to the **LT-Contradiction Matrix**. This allows you to calculate the "X-element" (the required resource) mathematically, reducing the psychological inertia and subjectivity that make problems seem complex\[14\],\[15\].

• **Calculate Invariants:** Use the complexity number (NC) to classify and compare physical effects, allowing you to choose the most efficient physical principle for a device\[16\],\[1\].

**3\. Resolve (Don't Compromise) Contradictions**

Complexity often persists because engineers try to optimize or compromise (trade-offs). The advice is to eliminate the conflict entirely.

• **Use ARIZ (Algorithm for Inventive Problem Solving):** For the most complex problems, use ARIZ. It is a disciplined algorithm designed to guide the brain from a vague problem statement to a specific **Physical Contradiction**\[17\],\[18\].

• **Separation Principles:** Once the physical contradiction is found (e.g., an object must be hot and cold), resolve it by separating the properties in **time**, **space**, or **condition**\[4\],\[19\].

**4\. Structure the Design (Bio-inspired Engineering)**

For designing complex systems (like genetic circuits or software), borrow principles from biological evolution.

• **Modularity:** Divide the system into sub-systems with high internal connectivity but little interdependency. This allows parts to change without breaking the whole\[20\].

• **Regularity:** Use repeating patterns and standardized parts to reduce the information required to describe the system, essentially reducing the search space for solutions\[21\].

**5\. Manage Information Complexity**

For dealing with data and software complexity, specific principles are recommended:

• **Intermediary/Mediator:** Use a proxy or intermediary to manage complex interactions between clients and servers\[22\].

• **Copying:** Replace a complex, expensive object with a simpler, cheaper copy (e.g., using a virtual image or simulation)\[23\].

• **Feedback:** Introduce monitoring software to check the health of complex subcomponents\[24\].

### **Summary of the Strategy**

To deal with complexity, you must **diagnose** the root contradiction using Functional Analysis and Root Cause Analysis\[25\], **simplify** the system using Trimming\[26\], and **solve** the core conflict using the Laws of System Evolution (such as the transition to the micro-level)\[27\] and the LT-Contradiction Matrix\[28\].

---
> [!info]- References
> [1] Bushuev - Trends of Physical Effects.pdf
> [2] Salamatov Book Triz The Right Solution at the Right Time - Chapter 2.pdf
> [3] Salamatov Book Triz The Right Solution at the Right Time - Chapter 2.pdf
> [4] Innovative synergism as a result of Triz and LT - system synthesis.pdf
> [5] [Book] Bukhman - Technology for Innovation.pdf
> [6] Product Improvement Using Knowledge Mining and Effect Analogy.pdf
> [7] Towards an engineering theory of evolution.pdf
> [8] Product Improvement Using Knowledge Mining and Effect Analogy.pdf
> [9] Product Improvement Using Knowledge Mining and Effect Analogy.pdf
> [10] Product Improvement Using Knowledge Mining and Effect Analogy.pdf
> [11] [Book] Bukhman - Technology for Innovation.pdf
> [12] Innovative synergism as a result of Triz and LT - system synthesis.pdf
> [13] [Book] Bukhman - Technology for Innovation.pdf
> [14] Innovative synergism as a result of Triz and LT - system synthesis.pdf
> [15] Rajic - Mathematical - Physical Model of Solving Inventive Problems.pdf
> [16] Bushuev - Trends of Physical Effects.pdf
> [17] Innovative synergism as a result of Triz and LT - system synthesis.pdf
> [18] [Book] Bukhman - Technology for Innovation.pdf
> [19] [Book] Bukhman - Technology for Innovation.pdf
> [20] Towards an engineering theory of evolution.pdf
> [21] Towards an engineering theory of evolution.pdf
> [22] [Book] Bukhman - Technology for Innovation.pdf
> [23] [Book] Bukhman - Technology for Innovation.pdf
> [24] [Book] Bukhman - Technology for Innovation.pdf
> [25] [Book] Bukhman - Technology for Innovation.pdf
> [26] [Book] Bukhman - Technology for Innovation.pdf
> [27] [Book] Bukhman - Technology for Innovation.pdf
> [28] Solving the same inventive problem using two different contradiction matrixes.pdf


FILE: 'Warren Weaver.md'
---
exported: 2026-02-07T20:40:35.650Z
source: NotebookLM
type: chat
title: Warren Weaver on 💬What is Complexity
tags:
  - What-is-complexity
  - Warren-Weaver
author: Warren Weaver
---
Based on the sources provided, **complexity** is defined not just by the number of parts in a system, but by the nature of the interactions between them. Dealing with complexity requires a fundamental shift from a "mechanistic" mindset (predict and control) to a "systemic" and "adaptive" mindset (sense, respond, and influence).

### Part 1: What is Complexity?

The sources distinguish "complexity" through three primary frameworks:

**1\. Organized vs. Disorganized Complexity (Warren Weaver)**

• **Problems of Simplicity:** Systems with very few variables (e.g., two or three) which can be handled by analytical mechanics\[1\].

• **Disorganized Complexity:** Systems with billions of variables (e.g., gas molecules) where the individual behavior is erratic, but the system possesses orderly average properties. These are handled by probability theory and statistical mechanics\[2\].

• **Organized Complexity:** The vast "middle region" involving a moderate number of variables (e.g., an economy, a biological cell, a military operation) that are interrelated into an organic whole\[3\]. In these systems, the interaction between variables is critical; you cannot average them out (as in statistics) or isolate them (as in mechanics) without destroying the system's essential nature\[4\],\[5\].

**2\. Complex vs. Complicated (Alex Ryan)**

• **Complicated systems** (like a car engine) may have many parts, but they are decomposable. You can take them apart and put them back together; the whole is the sum of the parts. They act like machines\[6\].

• **Complex systems** (like an insurgency or a marriage) are characterized by **interdependence**. The parts change their behavior in response to one another (feedback loops)\[6\].

    ◦ They generate **novelty** and **emergence**: properties that exist at the level of the whole but cannot be found in the parts (e.g., "wetness" is not in a water molecule; "morale" is not in a single soldier)\[7\],\[8\].    ◦ They are **non-linear**: Small inputs can cause massive effects (the "butterfly effect"), and massive efforts can sometimes yield no results\[9\],\[10\].
**3\. The Information-Theoretic View (Prokopenko et al.)**

• Complexity is distinct from randomness. A completely random system (high entropy) is actually "simple" to describe statistically.

• True complexity lies at the "edge of chaos"—a balance between order and disorder where **predictive information** (richness of structure) is maximized\[11\],\[12\],\[13\].

### Part 2: Advice on How to Deal with Complexity

Because complex systems are interconnected and open to their environment, traditional "engineering" approaches—which rely on decomposing problems and optimizing solutions—often fail or cause unintended consequences\[14\],\[15\]. The sources suggest the following strategies:

1\. Shift from Optimization to Adaptation

You cannot "solve" a complex system once and for all. You must **adapt** to improve the fit between your organization and the environment\[16\].

• **Use the VSR Cycle:** Adaptation consists of **Variation** (trying different things), **Selection** (seeing what works), and **Retention** (amplifying the success)\[17\].

• **Fisher's Fundamental Theorem:** Be careful of over-optimization. The better adapted you are to the _current_ environment, the less adaptable you tend to be to _future_ changes\[18\].

2\. Design for Emergence (Indirect Design)

You cannot directly control the outcome of a complex system (like "herding a million billiard balls"\[19\]). Instead of designing the _action_, design the _environment_.

• **The Bird vs. Rock Metaphor:** You can predict the trajectory of a rock (complicated), but not a bird (complex). To get a bird where you want it, you don't throw it; you build a feeder (an attractor) or a fence (a constraint)\[20\].

• **Shape Incentives:** Modify the environment to encourage desirable patterns to self-organize from the bottom up\[21\],\[22\].

3\. Act to Learn (Developing the Situation)

In complex systems, understanding cannot precede action. You often cannot understand the system until you stimulate it.

• **Iterative Probing:** Take "probing actions" designed specifically to provoke a response from the system, revealing its hidden structure and intent\[23\],\[24\].

• **The Adaptation Cycle:** Move from **Act → Sense → Decide → Adapt**. Action comes _first_ because you must interact with the system to generate the information needed for decision-making\[25\],\[26\].

4\. Use Systemic Design Methodology

• **Framing:** Do not accept the problem as given. Spend time "framing" the problem—constructing a narrative or visual map (like a "rich picture") that defines the boundaries, relationships, and tensions\[27\],\[28\].

• **Multiple Perspectives:** Complex systems look different depending on where you stand. Use "The Systems Triumvirate" of questions: _Why do I see what I see? Why do things stay the same? Why do things change?_\[29\].

• **Broaden the Scope:** Avoid the "decomposition error" (thinking you can solve the whole by fixing the parts)\[30\]. Look for "what is missing" rather than just filtering what is present\[31\].

5\. Manage Your Own Complexity (Ashby’s Law)

• **Requisite Variety:** To cope with a complex environment, your internal organization must possess enough variety (options/responses) to match the variety of the environment\[32\],\[33\].

• **Simple Rules:** Complex collective behavior often emerges from simple local rules (e.g., flocking birds). Rather than micromanaging, establish simple guiding principles (e.g., "capture the high ground") and allow decentralized execution\[34\],\[35\].

---
> [!info]- References
> [1] weaver - science and complexity.pdf
> [2] weaver - science and complexity.pdf
> [3] weaver - science and complexity.pdf
> [4] Weaver - The emerging Unity of Science.pdf
> [5] weaver - science and complexity.pdf
> [6] [Book] Ryan - Art of Design Student Text.pdf
> [7] Emergence is coupled to scope not level - Ryan.pdf
> [8] [Book] Ryan - Art of Design Student Text.pdf
> [9] Ryan - Science of Adaptation The foundation for an adaptive approach.pdf
> [10] [Book] Ryan - Art of Design Student Text.pdf
> [11] An Information Theoretic Primer on Complexity Self-organisation and Emergence.pdf
> [12] An Information Theoretic Primer on Complexity Self-organisation and Emergence.pdf
> [13] An Information Theoretic Primer on Complexity Self-organisation and Emergence.pdf
> [14] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [15] [Book] Ryan - Art of Design Student Text.pdf
> [16] Ryan - Science of Adaptation The foundation for an adaptive approach.pdf
> [17] Ryan - Science of Adaptation The foundation for an adaptive approach.pdf
> [18] [Book] Weinberg - The Secrets of Consulting A Guide to Giving and Getting Advice Successfully.pdf
> [19] Ryan - Science of Adaptation The foundation for an adaptive approach.pdf
> [20] Ryan - Science of Adaptation The foundation for an adaptive approach.pdf
> [21] Ryan - Applications of Complex Systems to Operational Design.pdf
> [22] [Book] Ryan - Art of Design Student Text.pdf
> [23] Ryan - Applications of Complex Systems to Operational Design.pdf
> [24] [Book] Ryan - Art of Design Student Text.pdf
> [25] Ryan - Science of Adaptation The foundation for an adaptive approach.pdf
> [26] [Book] Ryan - Art of Design Student Text.pdf
> [27] A Theory of Systemic Design - Ryan.pdf
> [28] [Book] Ryan - Art of Design Student Text.pdf
> [29] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [30] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [31] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [32] weaver.pdf
> [33] Ryan 2011 - Military applications of Complex Systems.pdf
> [34] Ryan - Applications of Complex Systems to Operational Design.pdf
> [35] Ryan - Science of Adaptation The foundation for an adaptive approach.pdf


FILE: 'index.md'
---
aliases:
  - Summary
  - What is Complexity
tags:
  - Summary
  - What-is-complexity
title: 💬What is Complexity
author: index
linter-yaml-title-alias: Summary
---
This prompt is to probe the collected material for each authors view on complexity which varies from the ontological (and produced a list of material factors) to the epistemic (which ultimately turns to the state of a confused mind). It is a gulf which is never reconciled and often forms the basis of arguments. when thinkers meet.

> [!question] Prompt
> What is complexity and what is the advice in how to deal with complexity

# Summary

These sources collectively define **complexity** as a dynamic state of **interconnectedness** and **unpredictability** where the whole cannot be understood by merely examining its individual parts. Unlike complicated mechanical systems, complex systems are characterized by **emergent behaviours**, non-linear relationships, and "wicked problems" that lack definitive solutions. The authors argue that traditional **command-and-control** management fails in these environments, necessitating a shift toward **adaptive learning**, systemic thinking, and the use of multiple perspectives. Key strategies for navigating this landscape include conducting **safe-to-fail experiments**, distributing authority to the system's edges, and maintaining **flexibility** rather than pursuing rigid optimization. Ultimately, the texts suggest that complexity is often a **perceived quality** dependent on an observer’s mental models, requiring **humility** and a "chaordic" balance between order and chaos.


